/*
 * Decompiled with CFR 0.152.
 */
import com.arbortext.catalog.Catalog;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Vector;

public class catalog {
    public static void main(String[] args) throws FileNotFoundException, MalformedURLException, IOException {
        if (args.length == 0) {
            System.out.println("Usage: catalogtest [options] command");
            System.out.println("Where options are:");
            System.out.println("-c catalogfile");
            System.out.println("-d debuglevel");
            System.out.println("-p parser class");
            System.out.println("-s");
            System.out.println("");
            System.out.println("The debug level should be an integer (0..3)");
            System.out.println("The -c option can be repeated to load several catalogs");
            System.out.println("The parser class is the name of a parser class to use for XML Catalogs");
            System.out.println("If the -s option is specified, the system catalogs are loaded before any");
            System.out.println("   catalogs specified by the -c options.");
            System.out.println("");
            System.out.println("Command is one of the following:");
            System.out.println("  document");
            System.out.println("  doctype  name publicid systemid");
            System.out.println("  entity   name publicid systemid");
            System.out.println("  notation name publicid systemid");
            System.out.println("  public        publicid systemid");
            System.out.println("  system                 systemid");
            System.out.println("");
            System.out.println("Arguments are positional, use the string \"null\" to indicate a null value.");
            System.exit(1);
        }
        Vector<String> catalogFiles = new Vector<String>();
        String debugLevel = null;
        boolean debugSet = false;
        String parserClass = null;
        boolean loadSystemCatalogs = false;
        Vector<String> commandArgs = new Vector<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-c")) {
                catalogFiles.addElement(args[++i]);
            } else if (args[i].equals("-d")) {
                debugLevel = args[++i];
                debugSet = true;
            } else if (args[i].equals("-p")) {
                parserClass = args[++i];
            } else if (args[i].equals("-s")) {
                loadSystemCatalogs = true;
            } else {
                commandArgs.addElement(args[i]);
            }
            ++i;
        }
        Catalog c = new Catalog();
        if (loadSystemCatalogs) {
            System.out.println("Loading system catalogs.");
            c.loadSystemCatalogs();
        } else {
            System.out.println("Ignoring system catalogs.");
        }
        if (debugSet) {
            try {
                int debug;
                c.debug = debug = Integer.parseInt(debugLevel);
                System.out.println("Set debug to: " + debug);
            }
            catch (Exception exception) {
                System.out.println("Cannot parse debug level: " + debugLevel);
                debugSet = false;
            }
        }
        if (!debugSet) {
            int defaultDebug = 3;
            System.out.println("Setting debug to default: " + defaultDebug);
            c.debug = defaultDebug;
        }
        if (parserClass != null) {
            System.out.println("Set XML Parser class to: " + parserClass);
            c.setParserClass(parserClass);
        }
        Enumeration cats = catalogFiles.elements();
        while (cats.hasMoreElements()) {
            String catalog2 = (String)cats.nextElement();
            System.out.println("Adding catalog: " + catalog2);
            c.parseCatalog(catalog2);
        }
        int entityType = 0;
        String entityTypeName = null;
        String entityName = null;
        String publicId = null;
        String systemId = null;
        Enumeration argEnum = commandArgs.elements();
        while (argEnum.hasMoreElements()) {
            String arg = (String)argEnum.nextElement();
            if (entityType == 0) {
                entityTypeName = arg;
                if (arg.equalsIgnoreCase("DOCUMENT")) {
                    entityType = 3;
                }
                if (arg.equalsIgnoreCase("DOCTYPE")) {
                    entityType = 7;
                }
                if (arg.equalsIgnoreCase("ENTITY")) {
                    entityType = 9;
                }
                if (arg.equalsIgnoreCase("NOTATION")) {
                    entityType = 11;
                }
                if (arg.equalsIgnoreCase("PUBLIC")) {
                    entityType = 12;
                }
                if (arg.equalsIgnoreCase("SYSTEM")) {
                    entityType = 13;
                }
                if (entityType != 0) continue;
                System.out.println("Invalid entity type: " + arg);
                System.exit(1);
                continue;
            }
            if ((entityType == 7 || entityType == 9 || entityType == 11) && entityName == null) {
                entityName = arg;
                continue;
            }
            if (publicId == null) {
                publicId = arg;
                continue;
            }
            systemId = arg;
        }
        if (entityName != null && entityName.equals("null")) {
            entityName = null;
        }
        if (publicId != null && publicId.equals("null")) {
            publicId = null;
        }
        if (systemId != null && systemId.equals("null")) {
            systemId = null;
        }
        if (entityType == 13 && systemId == null) {
            systemId = publicId;
            publicId = null;
        }
        System.out.println("Resolving " + entityTypeName + ":");
        if (entityType == 7 || entityType == 9 || entityType == 11) {
            System.out.println("\tName: " + entityName);
        }
        System.out.println("\tPublic: " + publicId);
        System.out.println("\tSystem: " + systemId);
        String resolved = null;
        switch (entityType) {
            case 3: {
                resolved = c.resolveDocument();
                break;
            }
            case 7: {
                resolved = c.resolveDoctype(entityName, publicId, systemId);
                break;
            }
            case 9: {
                resolved = c.resolveEntity(entityName, publicId, systemId);
                break;
            }
            case 11: {
                resolved = c.resolveNotation(entityName, publicId, systemId);
                break;
            }
            case 12: {
                resolved = c.resolvePublic(publicId, systemId);
                break;
            }
            case 13: {
                resolved = c.resolveSystem(systemId);
                break;
            }
        }
        System.out.println("\nResolved: " + resolved);
        if (systemId != null && resolved == null) {
            System.out.println("So use " + systemId);
        }
    }
}

