/*
 * Decompiled with CFR 0.152.
 */
package com.arbortext.xsl.sax;

import com.arbortext.catalog.Catalog;
import com.arbortext.catalog.CatalogEntityResolver;
import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax.FileDescriptorDestination;
import com.jclark.xsl.sax.FileDestination;
import com.jclark.xsl.sax.OutputMethodHandler;
import com.jclark.xsl.sax.OutputMethodHandlerImpl;
import com.jclark.xsl.sax.XMLProcessorEx;
import com.jclark.xsl.sax.XSLProcessor;
import com.jclark.xsl.sax.XSLProcessorImpl;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Driver {
    static Catalog catalog = new Catalog();
    static CatalogEntityResolver resolver = new CatalogEntityResolver();

    public static InputSource fileInputSource(File file) {
        String path = file.getAbsolutePath();
        String fSep = System.getProperty("file.separator");
        if (fSep != null && fSep.length() == 1) {
            path = path.replace(fSep.charAt(0), '/');
        }
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = String.valueOf('/') + path;
        }
        try {
            return new InputSource(new URL("file", "", path).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    public static InputSource fileInputSource(String str) {
        return Driver.fileInputSource(new File(str));
    }

    public static void main(String[] args) {
        File out;
        XSLProcessorImpl xsl = new XSLProcessorImpl();
        Driver.setParser(xsl);
        xsl.setErrorHandler((ErrorHandler)new ErrorHandlerImpl());
        int nArgs = 0;
        int i = 0;
        while (i < args.length) {
            int k = args[i].indexOf(61);
            if (k > 0) {
                xsl.setParameter(args[i].substring(0, k), (Object)args[i].substring(k + 1));
            } else {
                args[nArgs++] = args[i];
            }
            ++i;
        }
        try {
            catalog.loadSystemCatalogs();
            resolver.setCatalog(catalog);
        }
        catch (Exception exception) {}
        if (nArgs != 2 && nArgs != 3) {
            System.err.println("usage: java com.arbortext.xsl.sax.Driver source stylesheet [result] [param=value]...");
            System.exit(1);
        }
        OutputMethodHandlerImpl outputMethodHandler = new OutputMethodHandlerImpl((XSLProcessor)xsl);
        xsl.setOutputMethodHandler((OutputMethodHandler)outputMethodHandler);
        boolean succeeded = true;
        File in = new File(args[0]);
        File stylesheet = new File(args[1]);
        File file = out = nArgs == 3 ? new File(args[2]) : null;
        if (!in.isDirectory()) {
            succeeded = Driver.transformFile((XSLProcessor)xsl, outputMethodHandler, in, stylesheet, out);
        } else {
            String[] inFiles = in.list();
            int i2 = 0;
            while (i2 < inFiles.length) {
                File inFile = new File(in, inFiles[i2]);
                if (!inFile.isDirectory()) {
                    if (!stylesheet.isDirectory()) {
                        if (!Driver.transformFile((XSLProcessor)xsl, outputMethodHandler, inFile, stylesheet, new File(out, inFiles[i2]))) {
                            succeeded = false;
                        }
                    } else {
                        int ext = inFiles[i2].lastIndexOf(46);
                        File stylesheetFile = new File(stylesheet, ext < 0 ? inFiles[i2] : String.valueOf(inFiles[i2].substring(0, ext)) + ".xsl");
                        if (stylesheetFile.exists() && !Driver.transformFile((XSLProcessor)xsl, outputMethodHandler, inFile, stylesheetFile, new File(out, inFiles[i2]))) {
                            succeeded = false;
                        }
                    }
                }
                ++i2;
            }
        }
        if (!succeeded) {
            System.exit(1);
        }
    }

    static void printSAXParseException(SAXParseException e) {
        String systemId = e.getSystemId();
        int lineNumber = e.getLineNumber();
        if (systemId != null) {
            System.err.print(String.valueOf(systemId) + ":");
        }
        if (lineNumber >= 0) {
            System.err.print(String.valueOf(lineNumber) + ":");
        }
        if (systemId != null || lineNumber >= 0) {
            System.err.print(" ");
        }
        System.err.println(e.getMessage());
    }

    static void setParser(XSLProcessorImpl xsl) {
        String parserClass = System.getProperty("com.jclark.xsl.sax.parser");
        if (parserClass == null) {
            parserClass = System.getProperty("org.xml.sax.parser");
        }
        if (parserClass == null) {
            parserClass = "com.jclark.xml.sax.CommentDriver";
        }
        try {
            Object parserObj = Class.forName(parserClass).newInstance();
            if (parserObj instanceof XMLProcessorEx) {
                System.out.println("Catalogs not supported by this parser class.");
                xsl.setParser((XMLProcessorEx)parserObj);
            } else {
                ((Parser)parserObj).setEntityResolver((EntityResolver)resolver);
                xsl.setParser((Parser)parserObj);
            }
            if (parserObj instanceof Parser) {
                catalog.setParserClass(parserClass);
            }
            return;
        }
        catch (ClassNotFoundException e) {
            System.err.println(e.toString());
        }
        catch (InstantiationException e) {
            System.err.println(e.toString());
        }
        catch (IllegalAccessException e) {
            System.err.println(e.toString());
        }
        catch (ClassCastException classCastException) {
            System.err.println(String.valueOf(parserClass) + " is not a SAX driver");
        }
        System.exit(1);
    }

    static boolean transform(XSLProcessor xsl, InputSource stylesheetSource, InputSource inputSource) {
        try {
            xsl.loadStylesheet(stylesheetSource);
            xsl.parse(inputSource);
            return true;
        }
        catch (SAXParseException e) {
            Driver.printSAXParseException(e);
        }
        catch (SAXException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
        return false;
    }

    static boolean transformFile(XSLProcessor xsl, OutputMethodHandlerImpl outputMethodHandler, File inputFile, File stylesheetFile, File outputFile) {
        Object dest = outputFile == null ? new FileDescriptorDestination(FileDescriptor.out) : new FileDestination(outputFile);
        outputMethodHandler.setDestination((Destination)dest);
        return Driver.transform(xsl, Driver.fileInputSource(stylesheetFile), Driver.fileInputSource(inputFile));
    }

    static class ErrorHandlerImpl
    implements ErrorHandler {
        ErrorHandlerImpl() {
        }

        public void error(SAXParseException e) {
            Driver.printSAXParseException(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public void warning(SAXParseException e) {
            Driver.printSAXParseException(e);
        }
    }
}

