/*
 * $Header: /home/cvspublic/jakarta-commons/httpclient/src/test/org/apache/commons/httpclient/TestHttpUrlMethod.java,v 1.2 2002/04/22 03:14:47 marcsaeg Exp $
 * $Revision: 1.2 $
 * $Date: 2002/04/22 03:14:47 $
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.commons.httpclient;

import junit.framework.*;
import java.net.MalformedURLException;
import java.lang.reflect.*;

import org.apache.commons.httpclient.methods.*;

/**
 *
 * Unit tests for {@link HttpUrlMethod} based methods.  These tests
 * do not require any network connection or web app.
 *
 * @author Marc A. Saegesser
 * @version $Id: TestHttpUrlMethod.java,v 1.2 2002/04/22 03:14:47 marcsaeg Exp $
 */
public class TestHttpUrlMethod extends TestCase {

    // ------------------------------------------------------------ Constructor
    public TestHttpUrlMethod(String testName) {
        super(testName);
    }

    // ------------------------------------------------------------------- Main
    public static void main(String args[]) {
        String[] testCaseName = { TestHttpUrlMethod.class.getName() };
        junit.textui.TestRunner.main(testCaseName);
    }

    // ------------------------------------------------------- TestCase Methods

    public static Test suite() {
        return new TestSuite(TestHttpUrlMethod.class);
    }


    // ----------------------------------------------------------- Test Methods

    // Test constructors
    public void testUrlDeleteMethodConstructor() {
        try{
            UrlDeleteMethod method = new UrlDeleteMethod("http://www.fubar.com/path1/path2?query=string");
            validateConstructorResults(method);
        }catch(MalformedURLException e){
            fail("Caught unexpected exception " + e.toString());
        }
    }

    public void testUrlGetMethodConstructor() {
        try{
            UrlGetMethod method = new UrlGetMethod("http://www.fubar.com/path1/path2?query=string");
            validateConstructorResults(method);
        }catch(MalformedURLException e){
            fail("Caught unexpected exception " + e.toString());
        }
    }

    public void testUrlHeadMethodConstructor() {
        try{
            UrlHeadMethod method = new UrlHeadMethod("http://www.fubar.com/path1/path2?query=string");
            validateConstructorResults(method);
        }catch(MalformedURLException e){
            fail("Caught unexpected exception " + e.toString());
        }
    }

    public void testUrlOptionsMethodConstructor() {
        try{
            UrlOptionsMethod method = new UrlOptionsMethod("http://www.fubar.com/path1/path2?query=string");
            validateConstructorResults(method);
        }catch(MalformedURLException e){
            fail("Caught unexpected exception " + e.toString());
        }
    }

    public void testUrlPostMethodConstructor() {
        try{
            UrlPostMethod method = new UrlPostMethod("http://www.fubar.com/path1/path2?query=string");
            validateConstructorResults(method);
        }catch(MalformedURLException e){
            fail("Caught unexpected exception " + e.toString());
        }
    }

    public void testUrlPutMethodConstructor() {
        try{
            UrlPutMethod method = new UrlPutMethod("http://www.fubar.com/path1/path2?query=string");
            validateConstructorResults(method);
        }catch(MalformedURLException e){
            fail("Caught unexpected exception " + e.toString());
        }
    }

    private void validateConstructorResults(HttpUrlMethod method)
    {
        assertEquals("Get URL", "http://www.fubar.com/path1/path2?query=string", method.getUrl());
        assertEquals("Get Path", "/path1/path2", method.getPath());
        assertEquals("Get query string", "query=string", method.getQueryString());
    }


    // Test UrlDeleteMethod
    public void testUrlDeleteMethodAccessorsValidPath() {
        UrlDeleteMethod method = new UrlDeleteMethod();
        testAccessorsValidPath(method);
    }

    public void testUrlDeleteMethodAccessorsNoPath() {
        UrlDeleteMethod method = new UrlDeleteMethod();
        testAccessorsNoPath(method);
    }

    public void testUrlDeleteMethodAccessorsWithQuery() {
        UrlDeleteMethod method = new UrlDeleteMethod();
        testAccessorsWithQuery(method);
    }

    // Test UrlGetMethod
    public void testUrlGetMethodAccessorsValidPath() {
        UrlGetMethod method = new UrlGetMethod();
        testAccessorsValidPath(method);
    }

    public void testUrlGetMethodAccessorsNoPath() {
        UrlGetMethod method = new UrlGetMethod();
        testAccessorsNoPath(method);
    }

    public void testUrlGetMethodAccessorsWithQuery() {
        UrlGetMethod method = new UrlGetMethod();
        testAccessorsWithQuery(method);
    }

    // Test UrlHeadMethod
    public void testUrlHeadMethodAccessorsValidPath() {
        UrlHeadMethod method = new UrlHeadMethod();
        testAccessorsValidPath(method);
    }

    public void testUrlHeadMethodAccessorsNoPath() {
        UrlHeadMethod method = new UrlHeadMethod();
        testAccessorsNoPath(method);
    }

    public void testUrlHeadMethodAccessorsWithQuery() {
        UrlHeadMethod method = new UrlHeadMethod();
        testAccessorsWithQuery(method);
    }

    // Test UrlOptionsMethod
    public void testUrlOptionsMethodAccessorsValidPath() {
        UrlOptionsMethod method = new UrlOptionsMethod();
        testAccessorsValidPath(method);
    }

    public void testUrlOptionsMethodAccessorsNoPath() {
        UrlOptionsMethod method = new UrlOptionsMethod();
        testAccessorsNoPath(method);
    }

    public void testUrlOptionsMethodAccessorsWithQuery() {
        UrlOptionsMethod method = new UrlOptionsMethod();
        testAccessorsWithQuery(method);
    }

    // Test UrlPostMethod
    public void testUrlPostMethodAccessorsValidPath() {
        UrlPostMethod method = new UrlPostMethod();
        testAccessorsValidPath(method);
    }

    public void testUrlPostMethodAccessorsNoPath() {
        UrlPostMethod method = new UrlPostMethod();
        testAccessorsNoPath(method);
    }

    public void testUrlPostMethodAccessorsWithQuery() {
        UrlPostMethod method = new UrlPostMethod();
        testAccessorsWithQuery(method);
    }

    // Test UrlPutMethod
    public void testUrlPutMethodAccessorsValidPath() {
        UrlPutMethod method = new UrlPutMethod();
        testAccessorsValidPath(method);
    }

    public void testUrlPutMethodAccessorsNoPath() {
        UrlPutMethod method = new UrlPutMethod();
        testAccessorsNoPath(method);
    }

    public void testUrlPutMethodAccessorsWithQuery() {
        UrlPutMethod method = new UrlPutMethod();
        testAccessorsWithQuery(method);
    }

    private void testAccessorsValidPath(HttpUrlMethod method) {
        try{
            method.setUrl("http://www.fubar.com/path1/path2");
            assertEquals("Get URL", "http://www.fubar.com/path1/path2", method.getUrl());
            assertEquals("Get Path", "/path1/path2", method.getPath());
        }catch(MalformedURLException e){
            fail("Caught unexpected exception " + e.toString());
        }
    }

    private void testAccessorsNoPath(HttpUrlMethod method) {
        try{
            method.setUrl("http://www.fubar.com");
            assertEquals("Get URL", "http://www.fubar.com", method.getUrl());
            assertEquals("Get Path", "/", method.getPath());
        }catch(MalformedURLException e){
            fail("Caught unexpected exception " + e.toString());
        }
    }

    private void testAccessorsWithQuery(HttpUrlMethod method) {
        try{
            method.setUrl("http://www.fubar.com/path1/path2?query=string");
            assertEquals("Get URL", "http://www.fubar.com/path1/path2?query=string", method.getUrl());
            assertEquals("Get Path", "/path1/path2", method.getPath());
            assertEquals("Get query string", "query=string", method.getQueryString());
        }catch(MalformedURLException e){
            fail("Caught unexpected exception " + e.toString());
        }
    }
}
