/*  Festalon - NSF Player
 *  Copyright (C) 2002 Ben Parnell
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "types.h"
#include "x6502.h"
#include "sound.h"
#include "nsf.h"
#include "cart.h"
#include "ext/defs.h"
static DECLFW(NSF_write);
static DECLFR(NSF_read);
static void NSF_init(void);

static int CurrentSong;
int playon=0;

uint32 uppow2(uint32 n)
{
 int x;
 for(x=31;x>=0;x--)
  if(n&(1<<x))
  {
   if((1<<x)!=n)
    return(1<<(x+1));
   break;
  }
 return n;
}


static uint8 NSFROM[]=
{
/* First, the "NMI" handler, which is called to init a song and then
   play it.
*/
0xA2,0xFF,
0x9A,   	                        /* Initialize the stack pointer. */
0xAD,0xF1,0x5F,                         /* Confirm and load A      */
0xAE,0xF3,0x5F,                         /* Load X with PAL/NTSC byte */
0x20,0x00,0x00,                         /* JSR to init routine     */
0x8D,0xF1,0x5F,				/* Enable play routine. */
0xF2,					/* Jam. */

0xA2,0xFF,
0x8d,0xF0,0x5F,				/* Disable play routine. */
0x20,0x00,0x00,                         /* JSR to play routine  */
0x8d,0xF1,0x5F,				/* Enable play routine. */
0xF2,					/* Jam. */
};

static DECLFR(NSFROMRead)
{
 return (NSFROM-0x3800)[A];
}

static uint8 *NSFDATA=0;
static int NSFMaxBank;

static int NSFSize;
static uint8 BSon;
static uint16 PlayAddr;
static uint16 InitAddr;
static uint16 LoadAddr;

static NSF_HEADER NSFHeader;

uint8 RAM[0x800];
uint8 PAL=0;
static uint8 WRAM[8192];
static uint8 FDSMEM[32768+8192];
static DECLFW(BRAML)
{
        RAM[A&0x7FF]=V;
}

static DECLFR(ARAML)
{
        return RAM[A&0x7FF];
}
void ResetMapping(void)
{
        SetReadHandler(0x0000,0xFFFF,0);
        SetWriteHandler(0x0000,0xFFFF,0);

        SetReadHandler(0,0x1FFF,ARAML);
        SetWriteHandler(0,0x1FFF,BRAML);
        SetNESSoundMap();
}
void FCEU_ResetVidSys(int w)
{
 if(w)
  PAL=1;
 else
  PAL=0;
 SetSoundVariables();
}
void FESTAI_Emulate(void)
{
 for(;;)
 {
  static int kook=0;
  kook=(kook+1)&1;

  if(PAL)
   X6502_Run(312*(256+85)-kook);
  else
   X6502_Run(262*(256+85)-kook);
  if(playon) TriggerIRQNSF();
  if(!FlushEmulateSound()) break;
 }
}

FCEUS FSettings;

static INLINE void BANKSET(uint32 A, uint32 bank)
{
 bank&=NSFMaxBank;
 if(NSFHeader.SoundChip&4)
  memcpy(FDSMEM+(A-0x6000),NSFDATA+(bank<<12),4096);
 else 
  setprg4(A,bank);
}

static void CloseNSF(void)
{
 if(GameExpSound.Kill)
  GameExpSound.Kill();
 memset(&GameExpSound,0,sizeof(GameExpSound));
 if(NSFDATA)
 {
  free(NSFDATA);
  NSFDATA=0;
 }
}

void FESTAI_Close(void)
{
 CloseNSF();
}

NSF_HEADER *FESTAI_Load(uint8 *buf, uint32 size)
{
  int x;

  CloseNSF();

  memcpy(&NSFHeader,buf,0x80);
  buf+=0x80;
  if (memcmp(NSFHeader.ID,"NESM\x1a",5))
   return 0;

  NSFHeader.SongName[31]=NSFHeader.Artist[31]=NSFHeader.Copyright[31]=0;

  LoadAddr=NSFHeader.LoadAddressLow;
  LoadAddr|=NSFHeader.LoadAddressHigh<<8;

  InitAddr=NSFHeader.InitAddressLow;
  InitAddr|=NSFHeader.InitAddressHigh<<8;

  PlayAddr=NSFHeader.PlayAddressLow;
  PlayAddr|=NSFHeader.PlayAddressHigh<<8;

  NSFSize=size-0x80;

  NSFMaxBank=((NSFSize+(LoadAddr&0xfff)+4095)/4096);
  NSFMaxBank=uppow2(NSFMaxBank);

  if(!(NSFDATA=(uint8 *)malloc(NSFMaxBank*4096)))
   return 0;

  memset(NSFDATA,0x00,NSFMaxBank*4096);
  memcpy(NSFDATA+(LoadAddr&0xfff),buf,NSFSize);
 
  NSFMaxBank--;

  BSon=0;
  for(x=0;x<8;x++)
   BSon|=NSFHeader.BankSwitch[x];

 for(x=0;;x++)
 {
  if(NSFROM[x]==0x20)
  {
   NSFROM[x+1]=InitAddr&0xFF;
   NSFROM[x+2]=InitAddr>>8;
   NSFROM[x+0xD]=PlayAddr&0xFF;
   NSFROM[x+0xE]=PlayAddr>>8;
   break;
  }
 }

 FCEU_ResetVidSys(NSFHeader.VideoSystem&1);
 {
        memset(RAM,0x00,0x800);
        ResetMapping();
        NSF_init();
        X6502_Power();
        PowerSound();
        timestampbase=0;
 }
 playon=0;
 return(&NSFHeader);
}

static DECLFW(BWRAM)
{
                (WRAM-0x6000)[A]=V;
}

static DECLFW(NSFFDSWrite)
{
	(FDSMEM-0x6000)[A]=V;
}

static DECLFR(NSFFDSRead)
{
	return (FDSMEM-0x6000)[A];
}

static DECLFR(AWRAM)
{
	return WRAM[A-0x6000];
}

static void NSF_init(void)
{
  if(NSFHeader.SoundChip&4)
  {
   memset(FDSMEM,0x00,32768+8192);
   SetWriteHandler(0x6000,0xDFFF,NSFFDSWrite);
   SetReadHandler(0x6000,0xFFFF,NSFFDSRead);
  }
  else
  {
   memset(WRAM,0x00,8192);
   SetReadHandler(0x6000,0x7FFF,AWRAM);
   SetWriteHandler(0x6000,0x7FFF,BWRAM);
   ResetCartMapping();
   SetupCartPRGMapping(0,NSFDATA,((NSFMaxBank+1)*4096),0);
   SetReadHandler(0x8000,0xFFFF,CartBR);
  }

  if(BSon)
  {
   int32 x;
   for(x=0;x<8;x++)
   {
    if(NSFHeader.SoundChip&4 && x>=6)
     BANKSET(0x6000+(x-6)*4096,NSFHeader.BankSwitch[x]);
    BANKSET(0x8000+x*4096,NSFHeader.BankSwitch[x]);
   }
  }
  else
  {
   int32 x;
    for(x=(LoadAddr&0x7000);x<0x8000;x+=0x1000)
     BANKSET(0x8000+x,((x-(LoadAddr&0x7000))>>12));
  }

  SetWriteHandler(0x2000,0x3fff,0);
  SetReadHandler(0x2000,0x37ff,0);
  SetReadHandler(0x3836,0x3FFF,0);
  SetReadHandler(0x3800,0x3836,NSFROMRead);

  SetWriteHandler(0x5ff0,0x5fff,NSF_write);
  SetReadHandler(0x5ff0,0x5fff,NSF_read);


  if(NSFHeader.SoundChip&1) { 
   VRC6_ESI();
  } else if (NSFHeader.SoundChip&2) {
   VRC7_ESI();
  } else if (NSFHeader.SoundChip&4) {
   FDSSoundReset();
  } else if (NSFHeader.SoundChip&8) {
   Mapper5_ESI();
  } else if (NSFHeader.SoundChip&0x10) {
   Mapper19_ESI();
  } else if (NSFHeader.SoundChip&0x20) {
   Mapper69_ESI();
  }
  CurrentSong=NSFHeader.StartingSong;
}

uint8 DoUpdateStuff=0;
static DECLFW(NSF_write)
{
switch(A)
{
 case 0x5ff0:playon=0;break;
 case 0x5ff1:playon=1;break;
 case 0x5FF6:
 case 0x5FF7:if(!(NSFHeader.SoundChip&4)) return;
 case 0x5FF8:
 case 0x5FF9:
 case 0x5FFA:
 case 0x5FFB:
 case 0x5FFC:
 case 0x5FFD:
 case 0x5FFE:
 case 0x5FFF:if(!BSon) return;
             A&=0xF;
             BANKSET((A*4096),V);
	     break;
}
}

static DECLFR(NSF_read)
{
 int x;

 if((X.PC&0xF000)==0x3000)
 switch(A)
 {
 case 0x5ff1:
             memset(RAM,0x00,0x800);
             memset(WRAM,0x00,8192);
             BWrite[0x4015](0x4015,0x0);
             for(x=0;x<0x14;x++)
              BWrite[0x4000+x](0x4000+x,0);
             BWrite[0x4015](0x4015,0x0F);
	     BWrite[0x4017](0x4017,0x40);
	     if(NSFHeader.SoundChip&4) 
	     {
	      BWrite[0x4089](0x4089,0x80);
	      BWrite[0x408A](0x408A,0xE8);
	     }
             if(BSon)
             {
              for(x=0;x<8;x++)
	       BANKSET(0x8000+x*4096,NSFHeader.BankSwitch[x]);
             }
             return (CurrentSong-1);
 case 0x5FF2:x=DoUpdateStuff;DoUpdateStuff=0;return(x);
 case 0x5FF3:return PAL;
 }
 return 0;
}

int FESTAI_NSFControl(int z, int o)
{ 
 if(o)
  CurrentSong=z;
 else
  CurrentSong+=z;
 if(CurrentSong<1) CurrentSong=1;
 else if(CurrentSong>NSFHeader.TotalSongs) CurrentSong=NSFHeader.TotalSongs;
 playon=0;
 TriggerNMINSF();
 return(CurrentSong);
}
