/***************************************************************************
                          setiparse.cpp  -  description
                             -------------------
    begin                : Tue Jan 1 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
  26.01.2002 Just learned about the keyword "const"
              Seems to be a good thing(tm)

*/

#include "setiparse.h"

#include <math.h>
#include <time.h>
#include <iostream>
#include <fstream>

/** Constructor of setiparse */
setiparse::setiparse()
{
}


/** Destructor of class setiparse */
setiparse::~setiparse()
{
}


/** Set path to the SAH Files */
void setiparse::setSetiPath(string p)
{
    SetiPath=p;
}


/** Return path to the SAH files */
string setiparse::getSetiPath() const
{
    return SetiPath;
}


/** This parses all the SAH files */
int setiparse::parseSAH()
{

    pls.valid=false;                              //Setting to no Pulse detected
    gau.valid=false;                             //Setting to no Gaussian detected
		trp.valid=false;														//Setting no triplet detected

    int ret = 0;
    string currFile;
    string currLine;

//Read & parse state.sah
//Scoping because GCC3/Glibc doesn't like reusing of ifstream

	//SCOPE 1
    {
    	ifstream in;
    	currFile = SetiPath+"state.sah";
    	in.open(currFile.c_str());
    	if (!in)
    	{
        std::cout << "Couldn't open state.sah in directory " << SetiPath << endl;
        return -11;
    	}

    	while (in)
    	{
      	  getline(in,currLine);                     //C++ I/O sucks...
       	 analyseStateLine(currLine);
    	}
    	in.close();
     }

    //SCOPE 2
		{
	  	ifstream in;
			//Read and parse user_info.sah
    	currFile = SetiPath+"user_info.sah";
    	in.open(currFile.c_str());
    	if (!in)
    	{
       	 	std::cout << "Couldn't open user_info.sah in directory " << SetiPath << endl;
        	return -12;
    	}

    	while (in)
    	{
        	getline(in,currLine);                     //C++ I/O sucks...
        	analyseUserLine(currLine);
    	}
    	in.close();
     }

//SCOPE 3
    {
			//Read and parse work_unit.sah
			ifstream in;
    	currFile = SetiPath+"work_unit.sah";
    	in.open(currFile.c_str());
    	if (!in)
    	{
        	std::cout << "Couldn't open work_unit.sah in directory " << SetiPath << endl;
        	return -13;
    	}

    	while (in)
    	{
       	 getline(in,currLine);                     //C++ I/O sucks...
       	 analyseWULine(currLine);
    	}
    	in.close();
     }

		return ret;
}


/* Main parsers
-------------------------------------------------------------------- */

/** State.sah parser */
void setiparse::analyseStateLine(string cl)
{
    if (cl.find("prog=") == 0)
    {
        extractProc(cl);
        return;
    }

    if (cl.find("ncfft=") == 0)
    {
        extractInt(cl,6,&ncfft);
        return;
    }

    if (cl.find("cr=") == 0)
    {
        extractDouble(cl,3,&chirp);
        return;
    }

    if (cl.find("cpu=") == 0)
    {
        extractDouble(cl,4,&wuCpuTime);
        return;
    }

    if (cl.find("bg_score=") == 0)
    {
        extractDouble(cl,9,&gau.score);
        return;
    }

    if (cl.find("bg_sigma=") == 0)
    {
        extractDouble(cl,9,&gau.sigma);
        return;
    }

    if (cl.find("bg_power=") == 0)
    {
        extractDouble(cl,9,&gau.power);
				if(gau.power != 0.0) { gau.valid = true; }
        return;
    }

    if (cl.find("bg_true_mean=") == 0)
    {
        extractDouble(cl,13,&gau.trueMean);
        return;
    }

    if (cl.find("bg_chisq=") == 0)
    {
        extractDouble(cl,9,&gau.chiSquare);
        return;
    }

    if (cl.find("bg_fft_ind=") == 0)
    {
        extractInt(cl,11,&gau.fftInd);
        return;
    }

    if (cl.find("bg_chirp_rate=") == 0)
    {
        extractDouble(cl,14,&gau.chirpRate);
        return;
    }

    if (cl.find("bg_fft_len=") == 0)
    {
        extractInt(cl,11,&gau.fftLen);
        return;
    }

    if (cl.find("bg_bin=") == 0)
    {
        extractInt(cl,7,&gau.bin);
        return;
    }

    if (cl.find("bg_pot") == 0)
    {
        extractGPot(cl);
        return;
    }

    if (cl.find("bp_power=") == 0)
    {
        extractDouble(cl,9,&pls.power);
				if(pls.power != 0.0) { pls.valid = true; }
        return;
    }

    if (cl.find("bp_score=") == 0)
    {
        extractDouble(cl,9,&pls.score);
        return;
    }

    if (cl.find("bp_mean=") == 0)
    {
        extractDouble(cl,8,&pls.mean);
        return;
    }

    if (cl.find("bp_chirp_rate=") == 0)
    {
        extractDouble(cl,14,&pls.chirpRate);
        return;
    }

    if (cl.find("bp_period=") == 0)
    {
        extractDouble(cl,10,&pls.period);
        return;
    }

    if (cl.find("bp_fft_len=") == 0)
    {
        extractInt(cl,11,&pls.fftLen);
        return;
    }

    if (cl.find("bp_pot") == 0)
    {
        extractPPot(cl);
        return;
    }

		if (cl.find("bt_score=") == 0)
    {
        extractDouble(cl,9,&trp.score);
        return;
    }

		if (cl.find("bt_power=") == 0)
    {
        extractDouble(cl,9,&trp.power);
				if(trp.power != 0.0) { trp.valid = true; }
        return;
    }

		if (cl.find("bt_mean=") == 0)
    {
        extractDouble(cl,8,&trp.mean);
        return;
    }

		if (cl.find("bt_period=") == 0)
    {
        extractDouble(cl,10,&trp.period);
        return;
    }

		if (cl.find("bt_chirp_rate=") == 0)
    {
        extractDouble(cl,14,&trp.chirpRate);
        return;
    }

		if (cl.find("bt_fft_len=") == 0)
    {
        extractInt(cl,11,&trp.fftLen);
        return;
    }

		if (cl.find("bt_tpotind0_0=") == 0)
    {
        extractInt(cl,14,&trp.peak1);
        return;
    }

		if (cl.find("bt_tpotind1_0=") == 0)
    {
        extractInt(cl,14,&trp.peak2);
        return;
    }

		if (cl.find("bt_tpotind2_0=") == 0)
    {
        extractInt(cl,14,&trp.peak3);
        return;
    }

		if (cl.find("bt_pot") == 0)
    {
        extractTPot(cl);
        return;
    }

}


/** user_info.sah parser */
void setiparse::analyseUserLine(string cl)
{
    if (cl.find("id=") == 0)
    {
        extractInt(cl,3,&userId);
        return;
    }

    if (cl.find("name=") == 0)
    {
        extractString(cl,5,&userName);
        return;
    }

    if (cl.find("register_time= ") == 0)
    {
        extractString(cl,cl.find("(")+1,&timeRegistered);
        timeRegistered = timeRegistered.substr(0,timeRegistered.length()-1);
        return;
    }

    if (cl.find("last_result_time=") == 0)
    {
        extractString(cl,cl.find("(")+1,&timeLastResult);
        timeLastResult = timeLastResult.substr(0,timeLastResult.length()-1);
        return;
    }

    if (cl.find("nresults=") == 0)
    {
        extractInt(cl,9,&nrCompleted);
        return;
    }

    if (cl.find("total_cpu=") == 0)
    {
        cl.erase(cl.find("."),cl.length());
        extractDouble(cl,10,&cpuTime);
        return;
    }
}


/** work_unit.sah parser */
void setiparse::analyseWULine(string cl)
{
    if (cl.find("name=") == 0)
    {
        extractString(cl,5,&wu_name);
        return;
    }

    if (cl.find("start_ra=") == 0)
    {
        extractDouble(cl,9,&wu_StartRa);
        return;
    }
    if (cl.find("end_ra=") == 0)
    {
        extractDouble(cl,7,&wu_EndRa);
        return;
    }

    if (cl.find("start_dec=") == 0)
    {
        extractDouble(cl,10,&wu_StartDec);
        return;
    }

    if (cl.find("end_dec=") == 0)
    {
        extractDouble(cl,8,&wu_EndDec);
        return;
    }

    if (cl.find("angle_range=") == 0)
    {
        extractDouble(cl,12,&wu_AngleRange);
        return;
    }

    if (cl.find("subband_center=") == 0)
    {
        extractDouble(cl,15,&wu_SubbandCenter);
        return;
    }

    if (cl.find("subband_base=") == 0)
    {
        extractDouble(cl,13,&wu_SubbandBase);
        return;
    }

    if (cl.find("subband_sample_rate=") == 0)
    {
        extractDouble(cl,20,&wu_SubbandSampleRate);
        return;
    }

    if (cl.find("subband_number=") == 0)
    {
        extractInt(cl,15,&wu_SubbandNumber);
        return;
    }

}


/* One line parsers
------------------------------------------------------------------ */
void setiparse::extractProc(string cl)
{
    proc = atof(cl.substr(5,cl.length()).c_str());
    percent = (int)rint(proc*100);
}


void setiparse::extractInt(string cl, int startpos, int* dest)
{
    *dest = atoi(cl.substr(startpos,cl.length()).c_str());
}


void setiparse::extractDouble(string cl, int startpos, double* dest)
{
    *dest = atof(cl.substr(startpos,cl.length()).c_str());
}


void setiparse::extractString(string cl, int startpos, string* dest)
{
    *dest = cl.substr(startpos,cl.length());
}


void setiparse::extractTime(string cl, int startpos, tm* dest) { }

void setiparse::extractGPot(string cl)
{
    int ind =  atoi(cl.substr(7,cl.find("=")).c_str());
//cout << "Found index " << ind << endl;
    if (ind > 63 || ind < 0)
    {
        cout << "GPot index aout of range : "<<  ind << endl;
        return;
    }
    string tmp = cl.substr(cl.find("=")+1,cl.length());
    gau.data[ind] = atof(cl.substr(cl.find("=")+1,cl.length()).c_str() );
}


void setiparse::extractPPot(string cl)
{
    cl = cl.substr(7,cl.length());
//cout << "Pulse potential energy " << cl << endl;
    string stmp;
    int itmp;
    int count = 0;
    for (unsigned int i = 0; i < cl.length(); i+=2)
    {
        stmp = cl.substr(i,2);
        sscanf(stmp.c_str(), "%x", &itmp);
        pls.data[i/2] = itmp;
        count++;
//cout << "Translated " << stmp << " to " << itmp << endl;
    }
    pls.dataLen=count;
}

void setiparse::extractTPot(string cl)
{
    cl = cl.substr(7,cl.length());
//cout << "Pulse potential energy " << cl << endl;
    string stmp;
    int itmp;
    int count = 0;
    for (unsigned int i = 0; i < cl.length(); i+=2)
    {
        stmp = cl.substr(i,2);
        sscanf(stmp.c_str(), "%x", &itmp);
        trp.data[i/2] = itmp;
        count++;
//cout << "Translated " << stmp << " to " << itmp << endl;
    }
		//cout << "Lenght is " << count << endl;
    trp.dataLen=count;
}

/* Param get methods
------------------------------------------------------------------- */
/* state.sah getters */
float setiparse::getProc() const
{
    return proc;
}


int setiparse::getNcfft() const
{
    return ncfft;
}


int setiparse::getPercent() const
{
    return percent;
}


double setiparse::getChirp() const
{
    return chirp;
}


double setiparse::getWuCpuTime() const
{
    return wuCpuTime;
}


Gaussian setiparse::getGaussian() const
{
    return gau;
}

Pulse setiparse::getPulse() const
{
 		return pls;
}

Triplet setiparse::getTriplet() const
{
 		return trp;
}


/* user_info.sah getters */
int setiparse::getUserId() const
{
    return userId;
}


string setiparse::getUserName() const
{
    return userName;
}


string setiparse::getTimeRegistered() const
{
    return timeRegistered;
}


string setiparse::getTimeLastResult() const
{
    return timeLastResult;
}


int setiparse::getNrCompleted() const
{
    return nrCompleted;
}


double setiparse::getCpuTime() const
{
    return cpuTime;
}


/* work_unit.sah getters */
string setiparse::getWu_name() const
{
    return wu_name;
}


double setiparse::getWu_StartRa() const
{
    return wu_StartRa;
}


double setiparse::getWu_EndRa() const
{
    return wu_EndRa;
}


double setiparse::getWu_StartDec() const
{
    return wu_StartDec;
}


double setiparse::getWu_EndDec() const
{
    return wu_EndDec;
}


double setiparse::getWu_AngleRange() const
{
    return wu_AngleRange;
}


double setiparse::getWu_SubbandCenter() const
{
    return wu_SubbandCenter;
}


double setiparse::getWu_SubbandBase() const
{
    return wu_SubbandBase;
}


double setiparse::getWu_SubbandSampleRate() const
{
    return wu_SubbandSampleRate;
}


int setiparse::getWu_SubbandNumber() const
{
    return wu_SubbandNumber;
}
