# Part of the A-A-P recipe executive: Testing of :usetool gcc with :lib

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

#
# This test checks that the following works properly:
# - A recipe uses :usetool gcc to use the GCC toolchain.
# - The recipe then tries to build a library from a trivial C file.
#

import sys, os, re, glob, shutil

def runaap(args):
    return os.system("%s ..%sMain.py %s" % (sys.argv[1], os.sep, args))

os.chdir("rectest")

# Create a recipe, run it and check the output.
# Checks expanding $VAR.
rec = "rectest.aap"
out = "rectest.out"
inp = "rectest.c"
lib = "librectest.a"

def cleanup():
    for file in [ rec, out, inp, lib ]:
	try:
	    os.remove(file)
	except:
	    pass
    try:
	for dir in glob.glob('build-*'):
	    shutil.rmtree(dir)
    except:
	pass

cleanup()

# Create the recipe.
f = open(rec, "w")
f.write("""
:usetool gcc
:lib %s : %s
all: %s
    :print PASS
""" % (lib, inp, lib))
f.close()

# Create the source file.
f = open(inp, "w")
f.write("""
int foo() {return 0;}
""")
f.close()


res = runaap("-f %s >%s" % (rec, out))

f = open(out)
l = f.read()
if not re.search("PASS", l):
    print 'Aap failed to behave as expected - output was:'
    print l
    res = 1
f.close()

cleanup()
sys.exit(res)

# vim: set sw=4 et sts=4 tw=79 fo+=l:
