(in-package "ACL2")

(local (include-book "fl2"))
(local (include-book "expt2"))
(local (include-book "expt"))
(local (include-book "expo2"))

#|(defun ash (i c)
 (FLOOR (BINARY-* (IFIX I) (EXPT '2 C))
        '1))
|#
(defun fl (x)
;  (declare (xargs :guard (real/rationalp x)))
  (floor x 1))

(defun bvecp (x k)
  (and (integerp x)
       (>= x 0)
       (< x (expt 2 k))))

;(thm (rationalp (ash x n))) goes through?

;this form shows up in the function decode
(defthm bvecp-ash-1
  (implies (and (case-split (< x n))
                (case-split (integerp n))
                (case-split (integerp x))
                )
           (bvecp (ASH 1 x) n))
  :hints (("Goal" :in-theory (enable ash bvecp floor)))
)

;is this dumb?
(defthm ash-rewrite
    (implies (integerp n)
	     (equal (ash n i)
		    (fl (* n (expt 2 i)))))
)

(in-theory (disable ash-rewrite))


(defthm ash-nonnegative
  (implies (<= 0 i)
           (<= 0 (ash i c)))
  :hints (("Goal" :in-theory (enable ash))))

(defthm ash-nonnegative-type
  (implies (<= 0 i)
           (and (rationalp (ash i c))
                (<= 0 (ash i c))))
  :rule-classes ( :type-prescription)
  :hints (("Goal" :in-theory (enable ash))))

(defthm ash-with-c-non-integer
  (implies (not (integerp c))
           (equal (ash i c)
                  (ifix i))))
