(in-package "ACL2")

;move
(encapsulate ()
             (local (defthm fw
                      (implies (rationalp y)
                               (implies (complex-rationalp (+ x y))
                                        (complex-rationalp x)))))

             (local (defthm bk
                      (implies (rationalp y)
                               (implies (complex-rationalp x)
                                        (complex-rationalp (+ x y))))))

             (defthm complex-rationalp-+-when-second-term-is-rational
               (implies (rationalp y)
                        (equal (complex-rationalp (+ x y))
                               (complex-rationalp x)))
               :hints (("Goal" :in-theory (disable fw bk)
                        :use (fw bk)
                        ))))


;add more cases?
(encapsulate ()
             (local (defthm fw
                      (implies (rationalp y)
                               (implies (complex-rationalp (* y x))
                                        (complex-rationalp x)))))

             (local (defthm bk
                      (implies (and (not (equal y 0))
                                    (rationalp y))
                               (implies (complex-rationalp x)
                                        (complex-rationalp (* y x))))))

             (defthm complex-rationalp-*-drop-first-term-if-rational
               (implies (and (case-split (not (equal y 0)))
                             (rationalp y))
                        (equal (complex-rationalp (* y x))
                               (complex-rationalp x)))
               :hints (("Goal" :in-theory (disable fw bk)
                        :use (fw bk)
                        ))))