(in-package "ACL2")

;there's now a separate expo-proofs book !!!

;(include-book "include-book-macros")
;(include-book "float")
(include-book "negative-syntaxp")
(include-book "power2p")
(include-book "expo")
(local (include-book "expo2-proofs"))
;(include-book "expt")

(defthm expo-of-not-rationalp
  (implies (not (rationalp x))
           (equal (expo x) 0)))

;more gen than expo-of-non-negative-integerp in irepsproofs
(defthm expo-type-when-x-is-integerp
  (implies (integerp x)
           (and (integerp (expo x)) ;included to make the conclusion a "type" fact
                (<= 0 (expo x))))
  :rule-classes (:rewrite (:type-prescription :typed-term (expo x))))

;expo shifty rules should case-split the (not (equal x 0)) hyp


#| old
;has case-split on hyps
(defthm expo-shift-nice
  (IMPLIES (AND (case-split (RATIONALP X)) ;if not, we want to know about it
                (case-split (NOT (= X 0))) ;if x=0 we can simplify further
                (case-split (INTEGERP i)) ;if not, (expt 2 n) is 1
                )
           (= (EXPO (* (EXPT 2 i) X))
              (+ i (EXPO X)))))
|#

;added ifix to conclusion and dropped the hyp about i
(defthm expo-shift-nice
  (IMPLIES (AND (case-split (RATIONALP X)) ;if not, we want to know about it
                (case-split (NOT (= X 0))) ;if x=0 we can simplify further
                )
           (= (EXPO (* (EXPT 2 i) X))
              (+ (ifix i) (EXPO X))))
  :HINTS (("Goal" :USE (:instance SIG-EXPO-SHIFT (n i)))))

(defthm expo-shift-nice-2
  (IMPLIES (AND (case-split (RATIONALP X)) ;if not, we want to know about it
                (case-split (NOT (= X 0))) ;if x=0 we can simplify further
                (case-split (INTEGERP i)) ;if not, (expt 2 n) is 1
                )
           (= (EXPO (* X (EXPT 2 i)))
              (+ i (EXPO X)))))

(local (in-theory (disable expo-shift)))


(DEFTHM EXPO-SHIFT-3
  (IMPLIES (AND (case-split (RATIONALP X))
                (case-split (RATIONALP y))
                (case-split (not (= (* x y) 0)))
                (case-split (INTEGERP N)))
           (equal (EXPO (* X y (EXPT 2 N)))
                  (+ N (EXPO (* X y))))))

(defthm expo-shift-4
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (integerp n)
                (not (equal (* a b c) 0))
                )
           (equal (EXPO (* a b c (EXPT 2 n)))
                  (+ n (expo (* a b c))))))

(defthm expo-shift-6
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (integerp n)
                (not (equal (+ a (* b c)) 0))
                )
           (equal (EXPO (+ (* a (EXPT 2 n)) (* b c (EXPT 2 n))))
                  (+ n (EXPO (+ a (* b c )))))))

(defthm expo-shift-8
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (integerp n)
                (not (equal (+ a (* b c)) 0))
                )
           (equal (EXPO (+ (* a (EXPT 2 n)) (* b (EXPT 2 n) c)))
                  (+ n (EXPO (+ a (* b c )))))))



(defthm expo-shift-9
  (implies (and (rationalp a)
                (rationalp b)
                (integerp n)
                (not (equal (+ a b) 0))
                )
           (equal (EXPO (+ (* a (/ (EXPT 2 n))) (* (/ (EXPT 2 n)) b)))
                  (+ (- n) (EXPO (+ a b))))))

(defthm expo-shift-7
  (implies (and (rationalp a)
                (rationalp b)
                (integerp n)
                (not (equal (+ a b) 0))
                )
           (equal (EXPO (+ (* a (EXPT 2 n)) (* b (EXPT 2 n))))
                  (+ n (EXPO (+ a b))))))

(defthm expo-shift-10
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp c)
                (integerp n)
                (not (equal (+ a (* b c)) 0))
                )
           (equal (EXPO (+ (* a (/ (EXPT 2 n))) (* b c (/ (EXPT 2 n)))))
                  (+ (- n) (EXPO (+ a (* b c)))))))

(defthm expo-shift-11
  (implies (and (case-split (integerp n))
                (case-split (rationalp x))
                (case-split (rationalp y))
                (case-split (rationalp z))
                (case-split (rationalp a))
                (case-split (rationalp b))
                (case-split (rationalp c))
                (case-split (not (EQUAL (+ X (* Y Z) (* A B C)) 0)))
                )
           (equal (EXPO (+ (* x
                              (EXPT 2
                                    n))
                           (* y
                              z
                              (EXPT 2
                                    n))
                           (* a b c
                              (EXPT 2
                                    n))))
                  (+ n (expo (+ x (* y z) (* a b c))))))

          )

(defthm expo-shift-11-2
  (implies (and (case-split (integerp n))
                (case-split (rationalp x))
                (case-split (rationalp y))
                (case-split (rationalp z))
                (case-split (rationalp a))
                (case-split (rationalp b))
                (case-split (not (EQUAL (+ X (* Y Z) (* A B)) 0)))
                )
           (equal (EXPO (+ (* x
                              (EXPT 2
                                    n))
                           (* y
                              z
                              (EXPT 2
                                    n))
                           (* a b
                              (EXPT 2
                                    n))))
                  (+ n (expo (+ x (* y z) (* a b))))))

          )

(defthm expo-shift-13
  (implies (and (case-split (integerp n))
                (case-split (rationalp x))
                (case-split (rationalp y))
                (case-split (rationalp z))
                (case-split (rationalp a))
               (case-split (not (equal (+ (* x a) (* y z)) 0)))

                )
           (equal (EXPO (+ (* x a
                              (EXPT 2
                                    n))
                           (* y
                              z
                              (EXPT 2
                                    n))))
                  (+ n (expo (+ (* x a) (* y z) )))))
  :hints (("Goal"           
           :USE (:instance SIG-EXPO-SHIFT (n n) (x (+ (* x a) (* y z) )))))
           
)

#|
;nice one
(defthm expo-shift-12
  (implies (and (syntaxp (should-have-a-2-factor-divided-out x))
                (case-split (rationalp x))
                (case-split (not (equal x 0)))
                )
           (equal (expo x)
                  (+ 1 (expo (* 1/2 x))))))
|#

(defthm expo-shift-14
  (implies (and (case-split (integerp n))
                (case-split (rationalp x))
                (case-split (rationalp y))
                (case-split (rationalp z))
                (case-split (rationalp a))
                (case-split (rationalp b))
                (case-split (not (equal (+ x (* y a b z)) 0)))
                )
           (equal (EXPO (+ (* x
                              (EXPT 2
                                    n))
                           (* y
                              z
                              a
                              b
                              (EXPT 2
                                    n))))
                  (+ n (expo (+ x (* a y b z) )))))
)



(defthm expo-shift-15
  (implies (and (case-split (integerp n))
                (case-split (rationalp c))
                (case-split (rationalp a))
                (case-split (rationalp b))
                (case-split (not (equal (+ 1 (* a b c)) 0)))
                )
           (equal (EXPO (+ (/ (EXPT 2 n))
                           (*
                            a
                            b
                            (/ (EXPT 2
                                     n))
                            c)))
                  (+ (- n) (expo (+ 1 (* a b c) )))))
  )

(defthm expo-shift-16
  (implies (and (case-split (integerp n))
                (case-split (rationalp x))
                (case-split (not (equal x 0)))
                )
           (equal (expo (* (/ (expt 2 n)) x))
                  (+ (- n) (expo x))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-pull-negation-into-power)
                              '(expt-pull-negation-out-of-power))))
           
  )



(DEFTHM EXPO-MINUS-eric
  (implies (syntaxp (negative-syntaxp x))
           (equal (EXPO X) 
                  (EXPO (* -1 X)))))

(local (in-theory (disable expo-minus)))
;also don't need expo-minus-dist from irepsproofs




;expensive?
;n is a free var
(defthm expo-unique-eric
  (implies (and (rationalp x)
                (integerp n)
                (<= (expt 2 n) (abs x))
                (< (abs x) (expt 2 (1+ n))))
           (equal (expo x) n))
  :hints (("goal" :in-theory (disable expo abs)
           :use ((:instance expo-unique-1)
                 (:instance expo-unique-2)))))

(in-theory (disable expo-unique-eric))

;could be even better if move hyps into the conclusion? (perhaps only when n is a constant?)
; wow! this actually worked when the one above didn't!
(defthm expo-unique-eric-2
  (implies (and (rationalp x)
                (integerp n)
                (<= (expt 2 n) (abs x))
                (< (abs x) (expt 2 (1+ n))))
           (equal (equal (expo x) n)
                  t)))




;find a way to make this hit (EQUAL (+ I (EXPO (/ X))) -1) to (i.e., an expression containing one call to expo)
(defthm expo-equality-reduce-to-bounds
  (implies (and (case-split (rationalp x))
                (case-split (integerp n)))
           (equal (equal (expo x) n)
                  (if (equal 0 x)
                      (equal 0 n)
                    (and (<= (expt 2 n) (abs x))
                         (< (abs x) (expt 2 (1+ n))))))))

(in-theory (disable expo-equality-reduce-to-bounds)) ;leave enabled?


;combine this with others?
(DEFTHM EXPO-SHIFT-alt
  (IMPLIES (AND (syntaxp (quotep k))
                (equal k (expt 2 (expo k))) ; use power2p?
                (RATIONALP X)
                (NOT (= X 0)))
           (= (EXPO (* k X))
              (+ (expo k) (EXPO X))))
  :HINTS (("Goal" :in-theory (disable  expo-shift)
           :USE (:instance expo-shift (n (expo k))))))

#|
(defthm expo-x+2**k-eric
    (implies (and (syntaxp (quotep k))
                  (power2p k)
		  (rationalp x)
		  (<= 0 x)
		  (< (expo x) (expo k)))
	     (equal (expo (+ k x))
		    (expo k)))
    :hints (("Goal" :in-theory (disable expo-x+2**k)
             :use (:instance expo-x+2**k (k (expo k))))))
|#

(local
 (in-theory (disable EXPO-2**N)))

;dont export?
;like EXPO-2**N but better (now hypothesis-free)
(DEFTHM EXPO-expt2-i
  (EQUAL (EXPO (EXPT 2 i))
         (if (integerp i)
             i
           0)))

;these next 2 can be very expensive since (expt 2 k) gets calculated!

;restrict to constants k?
(defthm expo-comparison-rewrite-to-bound
  (implies (and (case-split (not (equal 0 x)))
                (integerp k) ;gen?
                (case-split (rationalp x))
                )
           (equal (< (expo x) k)
                  (< (abs x) (expt 2 k)))))

;restrict to constants k?
(defthm expo-comparison-rewrite-to-bound-2
  (implies (and (case-split (not (equal 0 x)))
                (integerp k) ;gen?
                (case-split (rationalp x))
                )
           (equal (< k (expo x))
                  (<= (expt 2 (+ k 1)) (abs x)))))




(defthm expo-/-power2p-1
  (implies (power2p x)
           (equal (expo (/ (expt 2 i)))
                  (- (expo (expt 2 i))))))

(defthm expo-/-power2p
  (implies (power2p x)
           (equal (expo (/ x))
                  (- (expo x)))))

;restrict to only x's which look like powers of 2
(defthm expo-/-power2p-alt
  (implies (and (syntaxp (power2-syntaxp x))
                (power2p x))
           (equal (expo (/ x))
                  (- (expo x)))))

(in-theory (disable expo-/-power2p-1 expo-/-power2p))




(defthm expo-bound-eric
  (implies (case-split (rationalp x))
           (and (equal (< (* 2 (EXPT 2 (EXPO X))) X)
                       nil)
                (equal (< X (* 2 (EXPT 2 (EXPO X))))
                       t)
                (equal (< (EXPT 2 (+ 1 (EXPO X))) X)
                       nil)
                (equal (< X (EXPT 2 (+ 1 (EXPO X))))
                       t)
                )))

;if this loops, disable all the expo-shift rules!
(defthm expo-/-notpower2p
  (implies (and (not (power2p x))
                (case-split (not (equal x 0)))
                (<= 0 x)
                (case-split (rationalp x))
                )
           (equal (expo (/ x))
                  (+ -1 (- (expo x)))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expo expt-split-rewrite  expo-equality-reduce-to-bounds)
                              '(a15)))))

(in-theory (disable expo-/-notpower2p))




#| these might be nice:


(defthm expo-shift-nicest
  (IMPLIES (AND (syntaxp (power2-syntaxp y)) 
                (case-split (RATIONALP X)) ;if not, we want to know about it
                (case-split (NOT (= X 0))) ;if x=0 we can simplify further
;                (case-split (INTEGERP i)) ;if not, (expt 2 n) is 1
                )
           (= (EXPO (* y X))
              (+ (expo y) (EXPO X))))
  :HINTS (("Goal" :USE (:instance expo-shift-nice (i (expo y))))))

|#


(defthm power2p-expt2-i
  (power2p (expt 2 i)))

(defthm power2p-/
  (equal (power2p (/ x))
         (power2p x)))

(defthm power2p-prod
   (implies (and (power2p x)
                 (power2p y))
            (power2p (* x y))))

(in-theory (disable power2p-prod))

(defthm power2p-prod-not
  (implies (and (not (power2p x))
                (power2p y))
           (not (power2p (* x y)))))

(in-theory (disable power2p-prod-not))

#|
(defthm power2p-shift
  (implies (and (syntaxp (power2-syntaxp y))
                (case-split (power2p y)) ;this should be true if the syntaxp hyp is satisfied
                )
           (equal (power2p (* y x))
                  (power2p x))))

(defthm power2p-shift-2
  (implies (and (syntaxp (power2-syntaxp y))
                (case-split (power2p y)) ;this should be true if the syntaxp hyp is satisfied
                )
           (equal (power2p (* x y))
                  (power2p x))))
|#
;make rules for quotient of powers of 2

;perhaps would be a good forward chaining rule?
(defthm power2p-means-positive-rationalp
  (implies (power2p x)
           (and (< 0 x)
                (rationalp x))))

(in-theory (disable power2p-means-positive-rationalp))

#|
(defthm power2p-quotient
  (implies (and (syntaxp (power2-syntaxp y))
                (case-split (power2p y)) ;this should be true if the syntaxp hyp is satisfied
                )
           (equal (power2p (/ y x))
                  (power2p x))))

(defthm power2p-quotient-2
  (implies (and (syntaxp (power2-syntaxp y))
                (case-split (power2p y)) ;this should be true if the syntaxp hyp is satisfied
                )
           (equal (power2p (/ x y))
                  (power2p x))))  
|#

#|
(defthm expo-of-x-minus-1-nopower2-case
  (implies (and (integerp x)
                (not (power2p x))
                (<= 0 x) ;gen and add abs phrasing?
                )
           (equal (expo (+ -1 x))
                  (expo x)))
)




(defthm expo-of-x-minus-1-power2-case
  (implies (and (integerp x) ;drop?
                (power2p x)
                (case-split (< 1 x)) ;gen?
                )
           (equal (expo (+ -1 x))
                  (+ -1 (expo x))))
)


;add more conclusions.  is (expt 2...) < or <= n?
(defthm expt-expo-bound-1
  (implies (and (integerp n)
                (case-split (< 0 n))
                )
           (equal (< N (EXPT 2 (EXPO (+ -1 N))))
                  nil))


  )|#

;move
(defthm expo-lower-bound-2
  (implies (and (case-split (rationalp x))
                (case-split (<= 0 x))
                (case-split (not (= x 0)))
                )
           (<= (expt 2 (expo x)) x))
  :rule-classes :linear
)