#ifndef _COMFLAGS_H_
#define _COMFLAGS_H_

#define COMFLAG_CHAT          0
#define COMFLAG_SHOUT         1
#define COMFLAG_GO            2
#define COMFLAG_QUIT          3
#define COMFLAG_LOOK          4
#define COMFLAG_EXITS         5
#define COMFLAG_USERS         6
#define COMFLAG_SAY           7
#define COMFLAG_BLDRLOAD      8
#define COMFLAG_BLDRMODIFY    9
#define COMFLAG_DESCRIBE     10
#define COMFLAG_BLDRSAVE     11
#define COMFLAG_BLDRSET      12
#define COMFLAG_BLDRLIST     13
#define COMFLAG_COMMIT       14
#define COMFLAG_BLDRNEW      15
#define COMFLAG_BLDRDELETE   16
#define COMFLAG_EXAMINE      17
#define COMFLAG_OPEN         18
#define COMFLAG_CLOSE        19
#define COMFLAG_DROP         20
#define COMFLAG_GET          21
#define COMFLAG_INVENTORY    22
#define COMFLAG_SHUTDOWN     23
#define COMFLAG_BHOSTS       24
#define COMFLAG_BANHOSTS     25
#define COMFLAG_COMFLAGS     26
#define COMFLAG_SAVE         27
#define COMFLAG_RELOAD       28
#define COMFLAG_LOCK         29
#define COMFLAG_UNLOCK       30
#define COMFLAG_INFO         31
#define COMFLAG_READ         32
#define COMFLAG_TELL         33
#define COMFLAG_MOVE         34
#define COMFLAG_COPY         35
#define COMFLAG_RENAME       36
#define COMFLAG_ADMINFLAG    37
#define COMFLAG_GAMEFLAG     38
#define COMFLAG_GOTO         39
#define COMFLAG_GIVE         40
#define COMFLAG_AUTOEXITS    41
#define COMFLAG_COLOR        42
#define COMFLAG_DISCON       43
#define COMFLAG_WIELD        44
#define COMFLAG_PUT          45
#define COMFLAG_WEAR         46
#define COMFLAG_STATS        47
#define COMFLAG_ACTION       48
#define COMFLAG_EAT          49
#define COMFLAG_LIGHT        50
#define COMFLAG_KILL         51
#define COMFLAG_SUMMON       52
#define COMFLAG_CONDITION    53
#define COMFLAG_FLEE         54
#define COMFLAG_HELP         55
#define COMFLAG_EMOTE        56
#define COMFLAG_ABILITIES    57
#define COMFLAG_CAST         58
#define COMFLAG_PERFORM      59
#define COMFLAG_SET          60
#define COMFLAG_REPEAT       61
#define COMFLAG_BRIEF        62
#define COMFLAG_AUTOPAY      63
#define COMFLAG_SUGGEST      64
#define COMFLAG_BUG          65
#define COMFLAG_TIME         66
#define COMFLAG_CONSIDER     67
#define COMFLAG_SIT          68
#define COMFLAG_STAND        69
#define COMFLAG_SLEEP        70
#define COMFLAG_TIE          71
#define COMFLAG_UNTIE        72
#define COMFLAG_SYSLOG       73
#define COMFLAG_ERRLOG       74
#define COMFLAG_BUGLOG       75
#define COMFLAG_SUGGLOG      76
#define COMFLAG_PLAY         77
#define COMFLAG_NOSLAIN      78
#define COMFLAG_QINFO        79
#define COMFLAG_QUESTS       80
#define COMFLAG_ENTER        81
#define COMFLAG_LEAVE        82
#define COMFLAG_FULLEDIT     83
#define COMFLAG_MAIL         84
#define COMFLAG_TYPO         85
#define COMFLAG_TYPOLOG      86
#define COMFLAG_PRONOUNS     87
#define COMFLAG_PAGER        88
#define COMFLAG_DIG          89
#define COMFLAG_LISTEN       90
#define COMFLAG_SMELL        91
#define COMFLAG_FEEL         92
#define COMFLAG_FULLEXITS    93
#define COMFLAG_ATTRIBUTES   94
#define COMFLAG_BULLETIN     95
#define COMFLAG_AUTOASSOC    96
#define COMFLAG_AUTODIAGNOSE	97
#define COMFLAG_SOCKET       98
#define COMFLAG_NOSPECTATE   99
#define COMFLAG_SPECTATE     100
#define COMFLAG_MASK         101
#define COMFLAG_SLAY         102
#define COMFLAG_SUICIDE      103
#define COMFLAG_CLONE        104
#define COMFLAG_FORCE        105
#define COMFLAG_BOOT         106
#define COMFLAG_GAMELIST     107
#define COMFLAG_WEAPONS      108
#define COMFLAG_CLASSIFY     109
#define COMFLAG_ADMININVIS   110
#define COMFLAG_INCOGNITO    111
#define COMFLAG_VISIBLE      112

#ifdef COMMANDS_C

char *comflagnames[] = {"Chat", "Shout", "Go", "Quit", "Look", "Exits",
       "Users", "Say", "BuilderLoad", "BuilderModify", "BuilderDescribe",
       "BuilderSave", "BuilderSet", "BuilderList", "BuilderCommit", 
       "BuilderNew", "BuilderDelete", "Examine", "Open", "Close", "Drop", 
       "Get", "Inventory", "Shutdown", "BuilderHosts", "BanHosts", 
       "Comflags", "Save", "Reload", "Lock", "Unlock", "Info", "Read",
       "Tell", "Move", "Copy", "Rename", "AdminFlags", "GameFlags", 
       "Goto", "Give", "Autoexits", "Color", "Disconnect", "Wield",
       "Put",  "Wear", "Stats", "Action", "Eat", "Light", "Kill",
       "Summon", "Condition",  "Flee",    "Help", "Emote", "Abilities",
       "Cast", "Perform", "Set", "Repeat", "Brief", "AutoPay", "Suggest",
       "Bug", "Time", "Consider", "Sit",   "Stand", "Sleep", "Tie",
       "Untie", "SysLog", "ErrLog", "BugLog", "SuggestLog", "Play",
       "NoSlain", "QInfo", "Quests", "Enter", "Leave", "FullEdit", 
       "Mail", "Typo", "TypoLog", "Pronouns", "Pager", "Dig",
       "Listen", "Smell", "Feel", "FullExits", "Attributes", "Bulletin",
       "AutoAssoc", "AutoDiagnose", "Socket", "NoSpectate", "Spectate",
       "Mask", "Slay", "Suicide", "Clone", "Force", "Boot", "GameList",
       "Weapons", "Classify", "AdminInvis", "Incognito", "Visible",
       NULL};


int comflagnewbiemask[] = {COMFLAG_CHAT, COMFLAG_SHOUT, COMFLAG_GO,
      COMFLAG_QUIT, COMFLAG_LOOK, COMFLAG_EXITS, COMFLAG_USERS, COMFLAG_SAY,
      COMFLAG_EXAMINE, COMFLAG_OPEN, COMFLAG_CLOSE, COMFLAG_DROP, 
      COMFLAG_GET, COMFLAG_INVENTORY, COMFLAG_SAVE, COMFLAG_LOCK, 
      COMFLAG_UNLOCK, COMFLAG_INFO, COMFLAG_READ, COMFLAG_TELL, 
      COMFLAG_MOVE, COMFLAG_GIVE, COMFLAG_AUTOEXITS, COMFLAG_COLOR,
      COMFLAG_WIELD, COMFLAG_PUT, COMFLAG_WEAR, COMFLAG_ACTION, 
      COMFLAG_EAT,  COMFLAG_LIGHT, COMFLAG_KILL, COMFLAG_CONDITION,
      COMFLAG_FLEE, COMFLAG_HELP, COMFLAG_EMOTE, COMFLAG_ABILITIES, 
      COMFLAG_CAST, COMFLAG_PERFORM, COMFLAG_SET, COMFLAG_REPEAT, 
      COMFLAG_BRIEF, COMFLAG_AUTOPAY, COMFLAG_SUGGEST, COMFLAG_BUG, 
      COMFLAG_TIME, COMFLAG_CONSIDER, COMFLAG_SIT, COMFLAG_STAND, 
      COMFLAG_SLEEP, COMFLAG_TIE, COMFLAG_UNTIE, COMFLAG_PLAY, 
      COMFLAG_QINFO, COMFLAG_QUESTS, COMFLAG_ENTER, COMFLAG_LEAVE,
      COMFLAG_FULLEDIT, COMFLAG_MAIL, COMFLAG_TYPO, COMFLAG_PRONOUNS,
      COMFLAG_PAGER, COMFLAG_DIG, COMFLAG_LISTEN, COMFLAG_SMELL,
      COMFLAG_FEEL, COMFLAG_FULLEXITS, COMFLAG_ATTRIBUTES,
      COMFLAG_BULLETIN, COMFLAG_AUTODIAGNOSE, COMFLAG_SUICIDE, COMFLAG_VISIBLE
      -1};

#else

extern char *comflagnames[];
extern int comflagnewbiemask[];

#endif
#endif




