#ifndef _CONFIGS_H
#define _CONFIGS_H

#include <stdio.h>
#include "flags.h"

#define CF_DAEMONIZE     0
#define CF_AUTOWIZ       1
#define CF_DISTANCETELL  2
#define CF_USEQUESTS     3
#define CF_USEMAILBOXES  4
#define CF_QUIETMODE     5
#define CF_LOGDEATH      6
#define CF_LOGFLAGS      7
#define CF_LOGFORCE      8
#define CF_LOGCLONE      9
#define CF_LOGBHOSTS    10
#define CF_LOGBANHOSTS  11
#define CF_LOGSLAY      12
#define CF_LOGDELETE    13
#define CF_GAMEALLOW    14
#define CF_BLDRALLOW    15
#define CF_LOGBOOT      16
#define CF_NOPROMPTCONV 17
#define CF_LOOKUPHOSTS  18
#define CF_CRASHSEGFLT  19
#define CF_CRASHSIGNAL  20
#define CF_PERMDEATH    21
#define CF_WIN32AUTOSTART 22

class Configs
{
public:
   ~Configs();
   Configs();
   int load_configs();

   /* all configs are below */
   Strings            basedir;
   Strings            mudname;
   unsigned short int gameport;
   unsigned short int buildport;
   int                maxpasswdtries;
   int                minpasswdlen;
   int                pollspersec;
   int                maxreadsperpoll;
   int                secs_in_day;
   int                days_in_year;
   int                first_day_summer;
   int                first_day_winter;
   Flags              *conf_flags;
   Strings            timezone;
   Strings            buildprompt;
   //   Strings            masteruser;
   //   Strings            masterpasswd;
   int                secs_player_heal;
   int                secs_mobile_heal;
   int                secs_player_magic;
   int                secs_player_endur;
   int                secs_level_check;
   int                weight_str_mult;
   long               max_global_exp;
   int                max_num_attacking;
   int                secs_till_timeout;
   int                max_line_len;
   int                default_pager_lines;
   Strings            users_level_chain;
   Strings            hardcoded_areaname;
   Strings            backup_locname;
   Strings            backup_loctitle;
   Strings            backup_locdesc;
   Strings            entry_locname;
   Strings            entry_loctitle;
   Strings            entry_locdesc;
   Strings            conffile_loc;
   Strings            ghost_name;
   Strings            ghost_title;
   Strings            ghost_altnames;
   Strings            ghost_brief;
   Strings            ghost_desc;
   int                default_speed;
   int                default_strength;
   int                default_dexterity;
   int                default_constitution;
   int                default_intel;
   int                default_maxendur;
   int                default_maxmagic;
   int                default_indweight;
   int                default_indsize;
   int                default_wimpy;
   int                default_mob_wimpy;
   int                default_wisdom;
   int                default_charisma;
   int                secs_to_rot;
   int                endurance_divisor;
   int                talent_funds;

private:

   int read_config(char *the_ident, FILE *the_file);
   void init_configs();

   Strings filename;
};

#endif






