//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef CONFIGURATION_ALERTSWIDGET_H
#define CONFIGURATION_ALERTSWIDGET_H

#include <qdialog.h>

//forward declarations
class QGridLayout;
class QLabel;
class QFrame;
class QCheckBox;
class QVGroupBox;
class Configuration;

//=====================================
/*! \brief Alerts Settings
 */
//=====================================

//======================
class AlertsWidget : public QWidget
{
Q_OBJECT
//----------------------
public:
  AlertsWidget( Configuration* config, QWidget *parent=0, const char* name=0);
  static void setDefaults(Configuration* config);
  void loadSettings();
  void saveSettings();
//----------------------
private:
  ///Backend config object pointer
  Configuration* config;

  QGridLayout* grid;

  QLabel* categoryLabel;
  QFrame* horizontalLine;

  QVGroupBox* behavior;
  QCheckBox* showDestructiveAlerts;
  QCheckBox* showSoftwareUpdateAlerts;

//----------------------
};
//======================

#endif //CONFIGURATION_ALERTSWIDGET_H
