/* $Id: wmmain.c,v 1.47 2000/11/11 23:41:54 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdlib.h> /* getenv  */
#include <stdio.h>  /* vprintf */
#include <stdarg.h> /* vprintf */
#include <string.h> /* strcat  */
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <X11/Xlib.h>  /* For XShape */
#include <X11/Xutil.h> /* For XShape */
#include <X11/extensions/shape.h> /* XShapeSelectInput */

#include "wmmain.h"
#include "wmwindow.h"
#include "wmclient.h"
#include "wmerror.h"
#include "wmroot.h"
#include "wmmisc.h"
#include "wmprop.h"
#include "wmgnome.h"
#include "wmmotif.h"

GdkAtom wm_atom_wm_state;
GdkAtom wm_atom_wm_hints;
GdkAtom wm_atom_wm_change_state;
GdkAtom wm_atom_wm_client_leader;

int ShapeEventBase;
int ShapeErrorBase;

WmRc      *wmrc = NULL;
GtkWidget *root;
GtkWidget *dummy_window;
GtkWidget *launcher;
GList     *all_groups;
WmGroup   *all_clients;
GList     *wm_group_name_list;

static GList* wm_main_client_widgets(void);
static void wm_main_init_clients(void);
static GtkWidget* wm_main_init_root(void);
static WmRc* wm_main_init_rc(void);
static void wm_main_init_cursor(void);
static void wm_main_init_debug(void);
static void wm_main_init_values(void);
static void wm_main_release(void);

static gchar  *wm_program_name;
static gint32  wm_current_desktop;
static gint32  wm_workspace_count;
static gint    wm_debug;

int main(int argc, char *argv[])
{
    wm_program_name = (argv && argv[0] != '\0') ? argv[0] : PACKAGE;

    gtk_set_locale();
    gtk_init(&argc, &argv);

    gtk_rc_parse("./gtkrc");

    wm_main_init_debug();
    wmrc = wm_main_init_rc();
    wm_main_init_values();
    wm_gnome_init();
    wm_motif_init();
    root = wm_main_init_root();
    wm_error_init();

    wm_main_init_cursor();
    wm_main_init_clients();

    if (*rc_error != '\0') {
	fprintf(stderr, "%s", rc_error);
	wm_alert(".amaterus error", rc_error);
    }

    gtk_main();
    return 0;
}

/* ͤν */
static void wm_main_init_values(void)
{
    wm_current_desktop = 0;
    wm_workspace_count = 4;

    dummy_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_widget_realize(dummy_window);

    wm_atom_wm_state         = gdk_atom_intern("WM_STATE",         FALSE);
    wm_atom_wm_hints         = gdk_atom_intern("WM_HINTS",         FALSE);
    wm_atom_wm_change_state  = gdk_atom_intern("WM_CHANGE_STATE",  FALSE);
    wm_atom_wm_client_leader = gdk_atom_intern("WM_CLIENT_LEADER", FALSE);
    XShapeQueryExtension(GDK_DISPLAY(), &ShapeEventBase, &ShapeErrorBase);

    all_clients = wm_group_new("All Clients", NULL, GDK_ROOT_WINDOW(),  FALSE);
    all_groups = NULL;
    wm_group_name_list = NULL;
    wm_group_name_list = g_list_append(wm_group_name_list, "Work");
    wm_group_name_list = g_list_append(wm_group_name_list, "Devel");
    wm_group_name_list = g_list_append(wm_group_name_list, "Game");
    wm_group_name_list = g_list_append(wm_group_name_list, "Misc");
    wm_group_name_list = g_list_append(wm_group_name_list, "Group1");
    wm_group_name_list = g_list_append(wm_group_name_list, "Group2");
    wm_group_name_list = g_list_append(wm_group_name_list, "Group3");

    wm_rc_system_set_func(wm_group_dialog, "group_new");

    launcher    = wm_launcher_new();
}

/* ν */
static void wm_main_init_cursor(void)
{
    GdkCursor *cursor;
	
    cursor = gdk_cursor_new(GDK_LEFT_PTR);
    gdk_window_set_cursor(GDK_ROOT_PARENT(), cursor);
    gdk_cursor_destroy(cursor);
}

void wm_main_group_add(GtkWidget *widget, WmClient *client, gpointer pointer);
void wm_main_group_del(GtkWidget *widget, WmClient *client, gpointer pointer);

static GtkWidget *wm_main_init_root(void)
{
    GtkWidget *root_widget;
    root_widget = wm_root_new();

    wm_message("WM_ROOT(width, height) = (%d, %d)\n", 
	       WM_ROOT_WIDTH(root_widget), WM_ROOT_HEIGHT(root_widget));

    gtk_signal_connect(GTK_OBJECT(root_widget), "create_client",
		       GTK_SIGNAL_FUNC(wm_main_group_add), NULL);
    gtk_signal_connect(GTK_OBJECT(root_widget), "delete_client",
		       GTK_SIGNAL_FUNC(wm_main_group_del), NULL);

    return root_widget;
}

static WmRc *wm_main_init_rc(void)
{
    gchar *rcfile;
    WmRc *wmrc;
    
    rc_error = g_strdup("");
    if (wmrc = wm_rc_init(AMATERUSRC)) {
	return wmrc;
    }

    rcfile = g_strconcat(getenv("HOME"), "/", AMATERUSRC, NULL);
    wmrc = wm_rc_init(rcfile);
    /* getenv  free Ϥʤ褦 */
/*     free(home); */
    g_free(rcfile);

    return wmrc;
}

/* Τñۤ */
void wm_main_group_add(GtkWidget *widget, WmClient *client, gpointer pointer)
{
    Window  leader;
    WmGroup *group;

    wm_message("WmMain[%x]: wm_main_group_add\n", client->client);

    client->group = NULL;
    wm_group_append(all_clients, client);
    wm_group_new("Only this", client, client->client, TRUE);
    if((leader = wm_prop_get_WMClientLeader(client))) {
	if((group = wm_group_find_leader(leader))) {
	    wm_group_append(group, client);
	    client->target = group;
	} else {
	    /* WM_CLIENT_TITLE , leader  TITLE ѹ. */
	    group = wm_group_new(wm_prop_get_WMName(client), 
				 client, leader, TRUE);
	    client->target = group;
	    all_groups = g_list_append(all_groups,group); /* group_newǤ */
	}
    } else {
	client->target = all_clients;
    }
}

/* Τñۤ */
void wm_main_group_del(GtkWidget *widget, WmClient *client, gpointer pointer)
{
    wm_message("WmMain: wm_main_group_del\n");

    while(WM_CLIENT_GROUP(client)) {
	/* ɬ withdrawn ֤ʤΤ remove Ƥ֤Τ̵̤ */
	wm_group_remove(WM_CLIENT_GROUP(client)->data, WM_CLIENT(client));
    }
}

static void wm_main_init_clients(void) 
{
    GList *clients;
    GtkWidget *window;
    
    for(clients = wm_main_client_widgets(); clients; clients = clients->next) {
	window = wm_window_border_add(clients->data);
	gtk_widget_show(window);
	WM_CLIENT_STATE(clients->data) = NormalState;

	if(wm_prop_get_WMState(clients->data) == IconicState) {
	    wm_client_iconify(clients->data);
	} else {
	    wm_client_set_WMState(clients->data, NormalState);
	}
    }
}

static GList* wm_main_client_widgets(void)
{
    GList *clientWidgets;
    Window xroot, parent, *children;
    guint i, children_num;
    XWindowAttributes attr;

    XQueryTree(GDK_DISPLAY(), GDK_ROOT_WINDOW(),
		&xroot, &parent, &children, &children_num);
    
    clientWidgets = NULL;
    
    if(children_num > 0) {
	for(i = 0; i < children_num; i++) {
            XGetWindowAttributes(GDK_DISPLAY(), children[i], &attr);
	    if(!attr.override_redirect && attr.map_state == IsViewable ) {
		clientWidgets = 
		    g_list_prepend(clientWidgets, wm_client_new(children[i]));
            }
	}
	XFree(children);
    }
    return clientWidgets;
}

static void wm_main_release(void)
{
    GList *list;
    for(list = all_clients->list; list; list = list->next) {
	wm_window_border_release(WM_CLIENT(list->data));
    }
    XSelectInput(GDK_DISPLAY(), GDK_ROOT_WINDOW(), 0);
    gdk_flush();
}

void wm_main_restart(gchar *path)
{
    gchar *window_manager;

    window_manager = (path && *path != '\0') ? path : wm_program_name;

    wm_main_release();

    if(execlp(window_manager, window_manager, NULL) == -1) {
	wm_message("WmMain: wm_main_restart: execlp failed.\n");
	wm_main_exit(1);
    }
}

void wm_main_exit(gint return_value)
{
    wm_main_release();
    gtk_exit(return_value);
}


/* ǥХåѴؿ */
void wm_message(const gchar *format, ...)
{
    if(wm_debug) {
	va_list args;

	va_start(args, format);
	vfprintf(stderr, format, args);
	va_end(args);
	fflush(stderr);
    }
}

static void wm_main_init_debug(void)
{
    if(getenv("WM_DEBUG")) {
	wm_debug = 1;
    } else {
	wm_debug = 0;
    }
}   

/*
 * XXX: [Ŭڤʥե˰ưͽ]: ᤯ۥǥȥåפʤȤ :-)
 */
gint32 wm_get_current_desktop(void)
{
    return wm_current_desktop;
}

gint32 wm_get_workspace_count(void)
{
    return wm_workspace_count;
}
