/* $Id: wmmisc.h,v 1.13 2000/08/17 12:00:23 komatsu Exp $ */

#ifndef __WM_MISC_H__
#define __WM_MISC_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include "wmgroup.h"
#include "wmrc.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void wm_signal_connect_safety(GtkObject *object, const gchar *name,
			      GtkSignalFunc func, gpointer func_data);
void wm_signal_connect_with_struct(GtkObject *object, const gchar *name,
				   GtkSignalFunc func, gpointer tmp_struct);
struct _WmWidgetStruct {
    GtkWidget *widget;
    gpointer   data;
};

typedef struct _WmWidgetStruct WmWidgetStruct;

#if 1
void wm_signal_connect_safety_with_struct(GtkObject *object, const gchar *name,
					  GtkSignalFunc func,
					  gpointer tmp_struct);
#endif
void wm_event_add(GtkWidget *widget, GdkEventMask mask);
void wm_event_del(GtkWidget *widget, GdkEventMask mask);
void wm_exec(gchar *command);

GtkWidget* wm_launcher_new(void);
GtkWidget* wm_launcher_new_default(void);
GtkWidget* wm_launcher_new_from_rc(WmRcMenu *rc);
GtkWidget* wm_launcher_get(const gchar *id);

void wm_marshal_NONE__INT_INT_INT(GtkObject *object,  GtkSignalFunc func,
				  gpointer func_data, GtkArg *args);

void wm_alert(const char* title, const char* message);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __WM_MISC_H__ */
