/*
    Copyright (C) 2001 Paul Davis
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: physical_keyboard.h,v 1.6 2002/07/28 19:31:26 trutkin Exp $
*/

#ifndef __pbd_physical_keyboard_h__  
#define __pbd_physical_keyboard_h__

#include <sigc++/signal_system.h>
#undef CONFIG_SPEAKUP // we could fix this if we don't include <linux/config.h> in pbd/atomic.h
#include <termios.h>
#include <linux/keyboard.h>
#ifndef EMIT_SIGNAL
#define EMIT_SIGNAL
#endif
/* book keeping for when we emit a signal--it does nothing xcept look pretty */

class PhysicalKeyboard : public SigC::Object {

  public:
	
	/* constructor for direct access to keyboard via /dev/console */

	PhysicalKeyboard();

	/* constructor for proxy access via a socket */

	PhysicalKeyboard (int socketfd);
	
	virtual ~PhysicalKeyboard();
	
void print_key(unsigned char);
	enum State {
		Shift_L = 0x1,
		Shift_R = 0x2,
		Control_L = 0x4,
		Control_R = 0x8,
		Alt_L = 0x10,
		Alt_R = 0x20,
		
		Alt = (0x10|0x20),
		Control = (0x4|0x8),
		Shift = (0x1|0x2),
	};
	
	int main ();
	int get_state() { return keyboard_state; }
	int selectable() { return fd; }
	int handle_input ();
	
	SigC::Signal1<int,unsigned char> key_event;
	SigC::Signal2<int,int,int> key_press;
	SigC::Signal2<int,int,int> key_release;
	
  private:
	
	int fd;
	int oldkbmode;
	struct termios old;
	int keyboard_state;
	int keys[NR_KEYS];
	bool isproxy;
	
	int getfd ();
	int get_mode ();
	bool is_a_console (int);
	int open_a_console (const char *name);
	int process_key (unsigned char);
	int get_keybindings ();
	int unmanage_hardware ();
	int manage_hardware ();
	void switch_vt (int which);
};

#endif // __pbd_physical_keyboard_h__
