/* $Id: ArkImgTGAw.cpp,v 1.7 2002/10/11 01:10:02 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <Ark/ArkTexture.h>
#include <Ark/ArkStream.h>


namespace Ark
{

static void WriteTGAHeader (WriteStream &file,
                            int gray, int bps,
                            int width, int height)
{
  uint16 w = 0;
  char c = 2;

  /* write header */
  c = 0; file.write (&c, 1); /* identFieldLength */
  c = 0; file.write (&c, 1); /* colorMapType == 0, no color map */

  if (gray == 0)
  {
    /* imageTypeCode == 2, uncompressed RGB */
    c = 2; file.write (&c, 1);
  }
  else
  {
    /* imageTypeCode == 3, uncompressed Mono (ie Gray) */
    c = 3; file.write (&c, 1);
  }

  file.write ((const char*) &w, 2); /* colorMapOrigin */
  file.write ((const char*) &w, 2); /* colorMapLength */
  c = 0; file.write (&c, 1); /* colorMapEntrySize */

  file.write ((const char*) &w, 2); /* imageOriginX */
  file.write ((const char*) &w, 2); /* imageOriginY */

  w = width;
  file.write ((const char*) &w, 2); /* imageWidth */

  w = (uint16) height;
  file.write ((const char*) &w, 2); /* imageHeight */

  c = bps; file.write (&c, 1); /* imagePixelSize */
  c = 0; file.write (&c, 1); /* imageDescriptorByte */

  /* write no ident field
  ** write no color map
  */
}

/* Write a 24-bit TARGA file */
void WriteTGA_RGB (WriteStream &file, uchar *image, int width, int height)
{
  uchar *data = (uchar *) image;
  int y, x;

  WriteTGAHeader (file, 0, 24, width, height);

  /* write imagedata */
  for (y = 0; y < height ; y++)
  {
    uchar *scanline = (uchar *) &data[y * width * 3];

    for (x = 0; x < width; x++)
    {
      file.write ((const char*) &scanline[x * 3 + 2], 1);
      file.write ((const char*) &scanline[x * 3 + 1], 1);
      file.write ((const char*) &scanline[x * 3 + 0], 1);
    }
  }
}

/* Write a Graylevel TARGA file */
void WriteTGA_Gray (WriteStream &file, uchar *image, int width, int height)
{
  int y;

  WriteTGAHeader (file, 1, 8, width, height);

  /* write imagedata */
  for (y = 0; y < height ; y++)
    file.write ((const char*) &image[y * width], width);
}

}
