/* $Id: Main.cpp,v 1.17 2003/03/11 23:42:31 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef WIN32
#include <windows.h>
#endif

#include <Ark/ArkSystem.h>
#include <Ark/ArkFileSys.h>
#include <Client/GLClient.h>

#include <sstream>

static const char *IdentFile = "{game}/data/identifier";

void ParseServerString()
{
   Ark::String serverstring = Ark::Sys()->Cfg()->GetStr("client::ServerString",
							"");
   if (serverstring != "")
   {
      Ark::String server, user, port, server_port;
      Ark::String::size_type pos = serverstring.find("@", 0);

      if (pos == Ark::String::npos)
      {
	 server_port = serverstring;
	 user = Ark::Sys()->GetEnv("USER");
      }
      else 
      {
	 server_port = serverstring.substr(pos+1, Ark::String::npos);
	 user = serverstring.substr(0, pos);
      }

      pos = server_port.find(":", 0);
      if (pos == Ark::String::npos)
      {
	 server = server_port;
	 port = "5555";
      }
      else 
      {
	 port = server_port.substr(pos+1, Ark::String::npos);
	 server = server_port.substr(0, pos);
      }

      std::stringstream stream;
      stream << "client::Updater=\"ark::Updater::Remote\";\n";
      stream << "client::Login=\"" << user << "\";\n";
      stream << "remoteUpdater::Server=\"" << server << "\";\n";
      stream << "remoteUpdater::Port=\"" << port << "\";\n";

      std::cout << stream.str();

      Ark::Sys()->Cfg()->Load("ParseServerString()", stream);
   }
}


int main (int argc, char **argv)
{
   Ark::System::Init (&argc, &argv);
   Ark::Math::Init ();

   bool id_found = false;
   Ark::String gamename;

   if (Ark::Sys()->FS()->IsFile (IdentFile))
   {
      Ark::AutoReadStream id (IdentFile);
      Ark::String line;

      std::getline(id.Get(), line);

      if (line == "===ARKRPG-GAME-IDENTIFIER===")
	 id_found = true;

      std::getline(id.Get(), gamename);
   }

   if (id_found == false)
   {
      Ark::String idfn = Ark::Sys()->FS()->GetFileName (IdentFile, false);
    
      Ark::String datanotfound = Ark::Sys()->Cfg()->GetStr(
	  "errorMsg::DataNotFound",
	  "Cannot find game data identifier...\n"
	  "This probably means that you didnt install the game data in the \n"
	  "right directory. Please go to the website in wich you found this \n"
	  "program, and search for a game data package..."   );

      Ark::Sys()->Fatal( Ark::Sys()->Cfg()->Expand(datanotfound).c_str() );
   }

   std::cout << "Game pack :\n  " << gamename << "\n\n";

   Client::GLClient client(argc, argv);

   ParseServerString();
   client.Loop ();

   return 0;
}
