/* $Id: Entity.h,v 1.9 2003/02/14 05:21:18 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ENGINE_ENTITY_H
#define ENGINE_ENTITY_H

#include <Ark/ArkEntity.h>
#include <Ark/ArkDataClass.h>

#include <Engine/ArkEngine.h>


namespace Ark
{
   class EngineClient;
   class Engine;

   class ARKENGINE_DLL_API EngineEntity : public Entity
   {
	 friend class Engine;
      private:
	 EngineClient *m_Client;
	 std::vector <EntityTimer> m_Timers;

      public:
	 EngineEntity (Ark::World *world);
	 virtual ~EngineEntity ();

	 /**
	  * Create the entity on the script side. This should be called only
	  * after all entities properties have been set...
	  */
	 virtual void Create () = 0;
	 
	 /**
	  * This calls the "normal" update function ; it then sends events
	  * to the  entity if needed (ie: the goal has been reached, a timer
	  * has expired, etc..)
	  */
	 virtual void Update (scalar dt);

	 /**
	  * Add a timer. When timeout is reached, the EvTimer function is
	  * called, with id as parameter. Remark : the granularity of the
	  * timer depends on the number of frame per seconds, since the
	  * entity is Updated only once a frame.
	  */
	 virtual bool AddTimer (int id, scalar timeout);
	 
      public:
	 // === Functions to be implemented by script entities ===

	 /**
	  * Called to set entity properties, EntryList is an association of
	  * name with int/scalar/string values.
	  */
	 virtual bool SetEntries (Engine *engine,
				  const Ark::EntryList &entries);

	 /**
	  * Called to set entity callback properties, EntryList is an
	  * association of name with int/scalar/string values.
	  */
	 virtual bool SetCallback (Engine *engine,
				   const Ark::EntryList &entries) = 0;
	 
	 /**
	  * Called when the entity has reached its goal.
	  */
	 virtual bool EvGoalReached ()=0;
	 
	 /**
	  * Called when a timer has expired. n is the timer id, as given to
	  * the Timer() function.
	  */
	 virtual bool EvTimer (int n)=0;
	 
	 /// Called when an entity to which we are bound sends a message.
	 /// This message can be retrieved in 'm_Messages'.
	 //virtual bool EvMessage ()=0;
	 
	 /**
	  * Called when someone speaks to this entity.
	  */
	 virtual bool EvTell ();

	 /**
	  * Called when a collision has occured.
	  */
	 virtual void EvHit (const EntityCollision &col) = 0;

     public:
	 Vector3 m_PreviousPos;
   };
   
}
#endif
