/* $Id: Script.h,v 1.12 2003/03/22 23:51:49 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef WIN32
 #undef LoadLibrary
#endif

#ifndef ENGINE_SCRIPT_H
#define ENGINE_SCRIPT_H


namespace Ark
{
   class ClassList;
   class Script;
}

#include <Ark/ArkFactory.h>

#include <Engine/ArkEngine.h>
#include <Engine/Engine.h>

namespace Ark
{
   
   class EngineEntity;
   
   class ARKENGINE_DLL_API Script
   {
      public:
	 ClassList *m_ClassList;
	 ClassList *m_CbClassList;
	 
      protected:
	 Script ();
	 
      public:
	 /// Destroy the given script engine.
	 virtual ~Script ();

	 virtual void SetEntries (Entity *entity,
				  const String &buffername, 
	                          Stream &buffer,
				  bool callbacks = false);
	 
	 /// Create a new using the given script engine.
	 virtual EngineEntity *NewEntity () = 0;
	 
	 /// Parse a script, contained in file named \c filename
	 virtual bool LoadScript (const String &filename) = 0;
	 
	 /// Load all the scripts from a "library".
	 virtual bool LoadLibrary (const String &filename);

	 /// Go to the next frame... (Execute code needed once per frame)
	 virtual bool NextFrame () = 0;

	 /// Main code, exectuted after the world is loaded
	 virtual bool Main () = 0;
   };

   class ARKENGINE_DLL_API ScriptFactory : public Ark::Factory
   {
      public:
         ScriptFactory();
	 virtual ~ScriptFactory() {};
	 virtual Script *NewScript() = 0;
	 static Script *CreateScript(const Ark::String impl,
				     Ark::FactoryList *lst = 0);
   };

}

#endif
