/****************************************************************
**
** Attal : Lords of Doom
**
** fightUnit.h
** Manage Units
**
** Version : $Id: fightUnit.h,v 1.8 2004/05/12 17:33:41 tribunal2 Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 28/12/2000
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


#ifndef FIGHTUNIT_H
#define FIGHTUNIT_H


// generic include files
// include files for QT
#include <qcanvas.h>
#include <qptrqueue.h>
// application specific include files
#include "libCommon/unit.h"
#include "libCommon/creature.h"

class FightCell;
class GraphicalFightCell;

/*              ------------------------------
 *                         FightUnit
 *              ------------------------------ */


/** comment for the class */
class FightUnit : public QCanvasSprite, public GenericFightUnit
{

public:
	/** Constructor */
	FightUnit( QCanvas * canvas );

	FightUnit( QCanvas * canvas, GenericFightUnit * unit, bool mirror );

	virtual ~FightUnit();

	/** Hit unit by 'nb' hitpoints */
	int hit( int nb );

	/** unit go to cell */
	void goTo( FightCell * cell );

	void setPosition( FightCell * cell );

	virtual void draw( QPainter& painter );

	/** Advance animation */
	void advance( int stage );

	/** Highlight (or not) the unit if active (or not) */
	void setActive( bool /*state = true*/ ) {}

	/** Draw destroyed unit (or not) if destroyed (or not) */
	void setDestroyed( bool state );

	void animateShooting ();

	void animateDefending ();

	void animateFighting ();

	/** Return RTTI */
	int rtti() const { return RTTI; };

	static const int RTTI;

protected:
	void initCreatureForMove( GraphicalFightCell * cell );

	QCanvasPixmap* imageAdvanced() const;
	uint _cpt;
	FightCell * _moving;
	QPtrQueue<FightCell> _fifo;

	CreatureAnimationType _currentAnimationType;
};

#endif // FIGHTUNIT_H
