/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import nz.net.catalyst.ELog;
import nz.net.catalyst.Log;
import nz.net.catalyst.RtException;
import nz.net.catalyst.lucene.server.IPackage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;

public class WriterControl
implements IPackage {
    private static final String WRITER_CHECK_PROPERTY = String.valueOf(IPackage.PACKAGE) + "WriterCheck";
    private static final int DEFAULT_WRITER_CHECK = 15;
    private static final String CLOSE_WAIT_PROPERTY = String.valueOf(IPackage.PACKAGE) + "CloseWait";
    private static final int DEFAULT_CLOSE_WAIT = 30;
    private static final String WAIT_SECONDS_PROPERTY = String.valueOf(IPackage.PACKAGE) + "LockWait";
    private static final int DEFAULT_WAIT_SECONDS = 5;
    private static final Map writers = new HashMap();
    private final File directory;
    private IndexWriter indexWriter;
    private Thread user;
    private long timeStamp;
    private Analyzer analyzer;
    private int waiters = 0;

    static {
        WriterControl.startMonitor();
    }

    private WriterControl(File directory) {
        this.directory = directory;
    }

    private static WriterControl getInstance(File directory) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Unable to create directory: " + directory);
        }
        directory = directory.getCanonicalFile();
        Map map = writers;
        synchronized (map) {
            WriterControl writerControl = (WriterControl)writers.get(directory);
            if (writerControl == null) {
                writerControl = new WriterControl(directory);
                writers.put(directory, writerControl);
            }
            return writerControl;
        }
    }

    static WriterControl getWriterControl(File directory, Analyzer analyzer) throws IOException {
        return WriterControl.getInstance(directory).getWriterControl(analyzer);
    }

    static WriterControl closeWriter(File directory, boolean lock) throws IOException {
        return WriterControl.getInstance(directory).closeWriter(lock);
    }

    static void closeIdleWriter(File directory) throws IOException {
        WriterControl.getInstance(directory).closeIdleWriter();
    }

    private void waitForWriter(String debugMessage) throws IOException {
        Thread myThread = Thread.currentThread();
        long before = System.currentTimeMillis();
        boolean waited = false;
        if (this.user != myThread) {
            try {
                ++this.waiters;
                while (this.user != null) {
                    waited = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                --this.waiters;
                throw throwable;
            }
            Object var7_9 = null;
            --this.waiters;
        }
        if (waited) {
            long duration = System.currentTimeMillis() - before;
            Log.debug(String.valueOf(myThread.getName()) + " waited " + duration + " ms to " + debugMessage);
        }
    }

    IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    private synchronized WriterControl getWriterControl(Analyzer analyzer) throws IOException {
        this.waitForWriter("get IndexWriter");
        this.user = Thread.currentThread();
        try {
            if (this.indexWriter == null) {
                this.indexWriter = this.openIndex(this.directory, analyzer);
                Log.debug("Opened new IndexWriter in " + this.directory);
                this.analyzer = analyzer;
            } else if (this.analyzer != analyzer) {
                this.indexWriter.close();
                this.indexWriter = null;
                this.indexWriter = this.openIndex(this.directory, analyzer);
                Log.debug("Closed and reopened IndexWriter in " + this.directory);
                this.analyzer = analyzer;
            } else {
                Log.debug("Reused IndexWriter in " + this.directory);
            }
            this.timeStamp = System.currentTimeMillis();
            WriterControl writerControl = this;
            Object var2_3 = null;
            if (this.indexWriter == null) {
                this.user = null;
            }
            return writerControl;
        }
        catch (Throwable throwable) {
            block7: {
                Object var2_4 = null;
                if (this.indexWriter != null) break block7;
                this.user = null;
            }
            throw throwable;
        }
    }

    private synchronized WriterControl closeWriter(boolean lock) throws IOException {
        this.waitForWriter("close IndexWriter");
        if (this.indexWriter != null) {
            this.indexWriter.close();
            this.indexWriter = null;
            this.timeStamp = System.currentTimeMillis();
            Log.debug("Closed IndexWriter in " + this.directory);
        }
        if (lock) {
            this.user = Thread.currentThread();
            return this;
        }
        this.user = null;
        this.notifyAll();
        return null;
    }

    synchronized void closeIdleWriter() throws IOException {
        if (this.indexWriter != null) {
            if (this.user == null) {
                try {
                    this.indexWriter.close();
                    Log.debug("Closed idle IndexWriter in " + this.directory);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.indexWriter = null;
            } else {
                Log.debug("IndexWriter not idle in " + this.directory);
            }
        }
    }

    private IndexWriter openIndex(File directory, Analyzer analyzer) throws IOException {
        int waitSeconds = Integer.getInteger(WAIT_SECONDS_PROPERTY, 5);
        if (waitSeconds < 0) {
            waitSeconds = 5;
        }
        long endTime = System.currentTimeMillis() + (long)waitSeconds * 1000L;
        while (true) {
            try {
                try {
                    IndexWriter indexWriter = new IndexWriter(directory, analyzer, false);
                    Log.debug("Opened IndexWriter in: " + directory);
                    return indexWriter;
                }
                catch (FileNotFoundException e) {
                    Log.log(ELog.NOTICE, "Failed to open existing Lucene index in: " + directory);
                    IndexWriter indexWriter = new IndexWriter(directory, analyzer, true);
                    Log.debug("Created IndexWriter in: " + directory);
                    return indexWriter;
                }
            }
            catch (IOException e) {
                Log.log(ELog.ERROR, "Failed to open Lucene index in: " + directory + ": " + e.toString());
                String error = e.getMessage();
                if (error.startsWith("Index locked for write")) {
                    long now = System.currentTimeMillis();
                    if (now >= endTime) {
                        throw e;
                    }
                    long sleepTime = Math.min(200L, endTime - now);
                    try {
                        this.wait(sleepTime);
                    }
                    catch (InterruptedException ie) {}
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    synchronized void release() {
        if (this.user != Thread.currentThread()) {
            throw new RtException("Attempt to release an IndexWriter not owned by this thread (probably previously released)");
        }
        this.user = null;
        if (this.indexWriter != null) {
            try {
                this.indexWriter.close();
                Log.debug("Closed IndexWriter in " + this.directory);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.indexWriter = null;
        }
        this.timeStamp = System.currentTimeMillis();
        this.notifyAll();
    }

    private synchronized void check(long now, long idleTime, long useLimit) {
        if (this.waiters > 0) {
            Log.debug("There " + (this.waiters == 1 ? "is 1 waiter" : "are " + this.waiters + " waiters") + " for " + this.directory + " and " + (this.indexWriter == null ? "no" : "an") + " IndexWriter and " + (this.user == null ? "no" : "one") + " user");
        }
        if (this.indexWriter == null) {
            return;
        }
        if (this.user == null) {
            if (this.timeStamp + idleTime <= now) {
                Log.debug("Closing IndexWriter in: " + this.directory);
                try {
                    this.indexWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.indexWriter = null;
            }
            return;
        }
        if (this.timeStamp + useLimit <= now) {
            Date useStart = new Date(this.timeStamp);
            Log.warn("useLimit exceeded for IndexWriter");
            Log.warn(" UserThread: " + this.user.getName());
            Log.warn(" Directory:  " + this.directory.toString());
            Log.warn(" useLimit:   " + useLimit + " ms");
            Log.warn(" useStart:   " + useStart);
            Log.warn(" Probable long optimize command, worse-case: runaway thread.");
        }
    }

    private static void startMonitor() {
        Thread monitor = new Thread(new Runnable(){

            public void run() {
                WriterControl.monitor();
            }
        }, "WriterControl");
        monitor.setDaemon(true);
        int priority = monitor.getPriority() - 1;
        if (priority < 1) {
            ++priority;
        }
        monitor.setPriority(priority);
        monitor.start();
    }

    private static void checkWriters(long useLimit) {
        WriterControl[] wc;
        Map map = writers;
        synchronized (map) {
            wc = new WriterControl[writers.size()];
            writers.values().toArray(wc);
        }
        long idleTime = 1000L * (long)Integer.getInteger(CLOSE_WAIT_PROPERTY, 30).intValue();
        long now = System.currentTimeMillis();
        int i = 0;
        while (i < wc.length) {
            wc[i].check(now, idleTime, useLimit);
            ++i;
        }
    }

    private static void monitor() {
        try {
            try {
                while (true) {
                    int sleepSeconds;
                    if ((sleepSeconds = Integer.getInteger(WRITER_CHECK_PROPERTY, 15).intValue()) < 1) {
                        sleepSeconds = 1;
                    }
                    long sleepTime = (long)sleepSeconds * 1000L;
                    Thread.sleep(sleepTime);
                    WriterControl.checkWriters(sleepTime);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            WriterControl.startMonitor();
            throw throwable;
        }
        Object var3_5 = null;
        WriterControl.startMonitor();
    }

    public static void Start(String[] args) {
    }
}

