/* changeset-utils.h:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__CHANGESET_UTILS_H
#define INCLUDE__LIBARCH__CHANGESET_UTILS_H


#include "libawk/relational.h"
#include "libarch/inv-ids.h"



struct arch_changeset_inventory
{
  /* [0] == loc;  [1] == id   (sort by 1)
   */
  rel_table dirs;
  rel_table files;

  enum arch_id_tagging_method method;
};



/* automatically generated __STDC__ prototypes */
extern void arch_changeset_inventory (struct arch_changeset_inventory * inv_out,
                                      t_uchar * tree_root, t_uchar * path,
                                      enum arch_id_tagging_method method,
                                      enum arch_inventory_category untagged_source_category,
                                      int escape_classes);
extern void arch_free_changeset_inventory_data (struct arch_changeset_inventory * i);
extern rel_table arch_read_changeset_index (t_uchar * path);
extern rel_table arch_read_changeset_dir_metadata (t_uchar * path);
extern mode_t arch_read_permissions_patch (t_uchar * file);
extern char * no_dot (char *name);
extern void preserve_old_patch_spew (t_uchar * dest_root, t_uchar * target, t_uchar * loc);
extern void save_patch_for_missing_file (t_uchar * missing_patch_dir, t_uchar * patch_path, t_uchar * mod_loc);

#endif  /* INCLUDE__LIBARCH__CHANGESET_UTILS_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (changeset-utils.h)
 */
