#include <string.h>

#include "dns.h"

int dns_build_query(const char* domain, const char* suffix,
		    int type, str* packet)
{
  char buf[2];
  if (!str_copyb(packet, "\0\0\1\0\0\1\0\0\0\0\0\0", 12)) return 0;
  if (!dns_dots_to_name(domain, packet)) return 0;
  if (suffix) {
    --packet->len;
    if (!dns_dots_to_name(suffix, packet)) return 0;
  }
  uint16_pack_msb(type, buf);
  if (!str_catb(packet, buf, 2)) return 0;
  if (!str_catb(packet, "\0\1", 2)) return 0;
  return 1;
}

static int dns_query_2(const char* domain, const char* suffix,
		       int type, str* packet)
{
  unsigned querylen;
  int r;
  if (!dns_build_query(domain, suffix, type, packet)) return -1;
  querylen = packet->len;
  if ((r = dns_txrx(packet, packet)) <= 0) return r;
  if (packet->len <= querylen) return 0;
  return dns_header_rcode(packet->s) == DNS_RCODE_OK;
}

int dns_query(const char* domain, int type, str* packet)
{
  const char* d;
  const char* end;
  int r;
  if ((r = dns_query_2(domain, 0, type, packet)) != 0) return r;
  end = domain + strlen(domain);
  if (end > domain && end[-1] == '.') return 0;
  if (dns_search.len == 0) return 0;
  for (d = dns_search.s, end = d + dns_search.len; d < end; d += strlen(d)+1)
    if ((r = dns_query_2(domain, d, type, packet)) != 0) return r;
  return 0;
}

int dns_query_fqdn(const char* fqdn, int type, str* packet)
{
  return dns_query_2(fqdn, 0, type, packet);
}
