#!/usr/bin/perl -w -I..

# Tests whether may_move works


$| = 1 ;

use Bloksi ;

$s= "AA01\n".
    "AA01\n".
    "23 8\n".
    "4467\n".
    "5567\n".
    "   9";

$g = new Bloksi $s ;

# Test each piece for the directions left,right,down,up
%test = ("A"=> ["","","2345A",""],
	 "0"=> ["","","0",""],
	 "1"=> ["","","",""],
	 "2"=> ["","23","245",""],
	 "3"=> ["", "3","345",""],
	 "4"=> ["","","45",""],
	 "5"=> ["","","5",""],
	 "6"=> ["", "","6","6"],
	 "7"=> ["","","",""],
	 "8"=> ["8","","",""],
	 "9"=> ["9","","",""],
	 ) ;

$errcnt = 0 ; 
$testcnt = 0 ;

while( ($p,$q) = each( %test ) )
{

    foreach ( @dirs )
    {
	$testcnt++ ;
	$a = shift(@$q);
	@r = may_move( $g, $p, $_ ) ;
	$r = join "",sort @r ;
	$r =~ s/(.)\1+/$1/g ;
	if( $r eq $a )
	{
	    print "OK $testcnt\n" ;

	} else {
	    print "Not OK $testcnt\n";
	    print "Move $p in direction $_ should yield '$a', not '$r'\n" ;
	    $errcnt++ ;
	}
	## <>;
    }
}


print "In all, there were $errcnt errors in $testcnt trials\n";
print $errcnt ? "back to the drawing board ..." : "Cool!", "\n" ;

