/***************************************************************************
                          dlgviewbookmarks.h  -  description
                             -------------------
    begin                : Sat Nov 16 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kenschenke at yahoo dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, as a special exception, Ken Schenke gives permission to  *
 *   link the code of this program with the Qt non-commercial edition (or  *
 *   with modified versions of the Qt non-commercial edition that use the  *
 *   same license as the Qt non-commercial edition, and distribute linked  *
 *   combinations including the two.  You must obey the GNU General Public *
 *   License in all respects for all of the code used other than the Qt    *
 *   Non-Commercial edition.  If you modify this file, you may extend this *
 *   exception to your version of the file, but you are not obligated to   *
 *   do so.  If you do not wish to do so, delete this exception statement  *
 *   from your version.                                                    *
 *                                                                         *
 ***************************************************************************/

#ifndef DLGVIEWBOOKMARKS_H
#define DLGVIEWBOOKMARKS_H

#include "dlgviewbookmarksbase.h"
#include "bridgecfg.h"
#include "bknode.h"

/***************************************************************************
 *                                                                         *
 *   The DlgViewBookmarks class represents the dialog box used to display  *
 *   the bookmarks tree.                                                   *
 *                                                                         *
 ***************************************************************************/

class DlgViewBookmarks : public DlgViewBookmarksBase
{
	Q_OBJECT
public:
	DlgViewBookmarks(
		const BridgeCfg &cfg,
		BkFolder *root,
		QWidget *parent = 0,
		const char *name = 0,
		bool modal = FALSE,
		WFlags f = 0);
	virtual ~DlgViewBookmarks();

	virtual void buttonCopyClicked(void);
	virtual void checkIgnoreClicked(void);
	virtual void listBkSelectionChanged(QListViewItem *);

protected:
	virtual void resizeEvent(QResizeEvent *);

private:
	void SetFolderIgnore(BkFolder &folder, bool checked);
	void fillFolder(BkFolder &parent, QListViewItem *parentItem);
	void fillList(BkFolder *root);
	void displayText(QLabel *label, const QString &text);

	const BridgeCfg &m_cfg;
};

#endif  // end of DLGVIEWBOOKMARKS_H
