/* (c) 1994 by Axel Zinser aka Fifi (fifi@hiss.han.de) */
#include	<ctype.h>
#include	<string.h>
#include	"xstring.h"

char *
strustr(string,pattern)
char	*string, *pattern;
{
	int	s,p,c;

	if (!string || !pattern || !*string || !*pattern)
		return(0);
	p = strlen(pattern);
	s = strlen(string);
	c = 1;
	while((p <= s) && (c=strnucmp(string,pattern,p))) {
		string++;
		s--;
	}
	if (!c) return(string);
	return(0);
}

char *
skipch(cp,c)
char	*cp, c;
{
	while(cp && *cp && (*cp != c)) {
		switch(*cp) {
		case '\'':
			cp = skipch(cp+1,'\'');
			break;
		case '"':
			cp = skipch(cp+1,'"');
			break;
		case '(':
			cp = skipch(cp+1,')');
			break;
		case '<':
			cp = skipch(cp+1,'>');
			break;
		case '{':
			cp = skipch(cp+1,'}');
			break;
		case '[':
			cp = skipch(cp+1,']');
			break;
		}
		if (cp) cp++;
	}
	if (!cp || !*cp) return(0);
	return(cp);
}

int
cmptail(string,tail)
char	*string, *tail;
{
	int	l;

	if ((l=strlen(string)) < strlen(tail))
		return(1);
/* printf("%s %s %s\n",string,string + l - strlen(tail),tail); */
	return(strucmp((string + l - strlen(tail)), tail));
}


char *
basename(path)
char	*path;
{
	register char	*cp = strrchr(path,'/');

	if (cp) return(cp+1);
	return(path);
}

char *
substr(s1,s2)
char	*s1, *s2;
{
	int	l;

	if (!s1 || !s2 || !*s1 || !*s2)
		return(0);
	l = strlen(s2);
	while(*s1 && strncmp(s1,s2,l)) s1++;
	if (*s1) return(s1);
	return(0);
}

int
issubstr(s1,s2)
char	*s1, *s2;
{
	char	*total, *part;
	int	diff;

	/* checks, wether s2 is a substring of s1 => return(1)
	 * or s1 is a substring off s2 => return(-1)
	 * or none of it => return(0) */
	if ((diff = strlen(s1) - strlen(s2)) > 0) {
		total = s1;
		part = s2;
	} else {
		diff *= -1;
		total = s2;
		part = s1;
	}
	if (strcmp(total+diff,part))
		return(0);
	if (total == s1)
		return(1);
	return(-1);
}

char *
skipline(cp)
char *cp;
{
	while(cp && *cp && (*cp != '\n')) cp++;
	if(*cp == '\n') cp++;
	return(cp);
}

int
strnucmp(cp1,cp2,n)
char *cp1,*cp2;
int n;
{
	char	c1, c2;

	while(*cp1 && *cp2 && n) {
		c1 = (isupper(*cp1) ? tolower(*cp1) : *cp1);
		c2 = (isupper(*cp2) ? tolower(*cp2) : *cp2);
		if (c1 != c2) return(1);
		cp1++; cp2++; n--;
	}
	if (n) return(1);
	return(0);
}

int
strucmp(cp1,cp2)
char *cp1,*cp2;
{
	char	c1, c2;

	while(*cp1 && *cp2) {
		c1 = (isupper(*cp1) ? tolower(*cp1) : *cp1);
		c2 = (isupper(*cp2) ? tolower(*cp2) : *cp2);
		if (c1 != c2) return(1);
		cp1++; cp2++;
	}
	if (*cp1 || *cp2) return(1);
	return(0);
}

char *
skip2space(cp)
char *cp;
{
	while(cp && *cp && !isspace(*cp)) cp++;
	return(cp);
}

char *
skip20(cp)
char *cp;
{
	while(cp && *cp && isspace(*cp)) cp++;
	return(cp);
}

char *
stripcr(cp)
char *cp;
{
	char	*xp;

	if (cp && *cp) {
		xp = cp + strlen(cp) - 1;
		while((xp >= cp) && *xp && ((*xp == '\n') || (*xp == '\r'))) *xp-- = '\0';
	}
	return(cp);
}

char *
strip(cp)
char *cp;
{
	char	*xp;

	if (cp && *cp) {
		xp = cp + strlen(cp) - 1;
		while((xp >= cp) && *xp && ((*xp == '\n') || isspace(*xp))) *xp-- = '\0';
	}
	return(cp);
}

char *
lowcase(cp)
register char *cp;
{
	char	*xp = cp;
	while(cp && *cp) {
		if (isupper(*cp)) *cp = tolower(*cp);
		cp++;
	}
	return(xp);
}

int
str2arr(src,dst,maxind)
char	*src;
char	*dst[];
int	maxind;
{
	int	j,i = 0;
	char	*cp = skip20(src);

	while(cp && *cp && (i<maxind)) {
		dst[i++] = cp;
		cp = skip2space(cp);
		if (*cp && (i<maxind)) *cp++ = 0;
		cp = skip20(cp);
	}
	for(j=i ;i<maxind; dst[i++] = 0);
	return(j);
}

