#ifndef BUFFY_WINDOW_H
#define BUFFY_WINDOW_H

/*
 * Folder list window
 *
 * Copyright (C) 2004  Enrico Zini
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma interface

#include "FolderList.h"
#include "PrefDialog.h"

#include <gtkmm/window.h>
//#include <gtkmm/table.h>
#include <gtkmm/button.h>
#include <gtkmm/uimanager.h>
#include <gtkmm/toggleaction.h>
#include <gtkmm/dialog.h>

class BuffyWindow : public Gtk::Window//, public MailFolderConsumer
{
protected:
	Gtk::VBox mainVBox;
	Gtk::HBox buttonBox;
	Gtk::Button updateButton;
	FolderList folderList;
	PrefDialog prefDialog;

	sigc::connection timer_connection;

	Glib::RefPtr<Gtk::UIManager> uimanager;
	Glib::RefPtr<Gtk::ActionGroup> actionGroup;

	Glib::RefPtr<Gtk::Action> actionRescanFolders;
	Glib::RefPtr<Gtk::Action> actionPreferences;
	Glib::RefPtr<Gtk::ToggleAction> actionViewEmpty;
	Glib::RefPtr<Gtk::ToggleAction> actionViewRead;
	Glib::RefPtr<Gtk::ToggleAction> actionViewImportant;

	/*
	Gtk::Menu editMenu;
	Gtk::Menu helpMenu;

	Gtk::Widget* saveMenuItem;
	Gtk::Widget* saveasMenuItem;
	Gtk::Widget* undoMenuItem;
	Gtk::Widget* redoMenuItem;
	Gtk::Widget* mergeMenuItem;
	Gtk::Widget* intersectMenuItem;
	Gtk::Widget* copyToOtherMenuItem;
	Gtk::Widget* moveToOtherMenuItem;
	Gtk::Widget* deleteUnselectedMenuItem;
	*/

	void on_program_exited(int pid, int status);

public:
	BuffyWindow();
	virtual ~BuffyWindow() {}

	void rescanFolders();

	void on_open_folder(MailFolder folder);
	void on_quit();
	void on_filter_changed();
	void do_preferences();

	/// Set the update timer to the given interval in seconds
	void set_timer(int interval);
		
	//void consume(const MailFolder& folder);

	/*
	void on_open();
	void on_open_debtags();
	void on_save();
	void on_save_as();
	void on_undo();
	void on_redo();
	void on_merge();
	void on_intersect();
	void on_copy_to_other();
	void on_move_to_other();
	void on_delete_unselected();

	void on_doc_change();
	void on_filename_change();
	void on_selection_change();

	void on_request_tagcoll_change(Tagcoll::TagcollChange<std::string, Tagcoll::Tag> change);

	void on_select_tagset_panel1(Tagcoll::TagSet tagset);
	void on_select_tagset_panel2(Tagcoll::TagSet tagset);

	void on_addButton_clicked();
	*/
};

// vim:set ts=4 sw=4:
#endif
