/*
 * $Id: swcase.c,v 1.2 2003/09/25 15:37:46 jmmv Exp $
 *
 * buildtool
 * Copyright (c) 2003 Julio M. Merino Vidal
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the author nor the names of contributors may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <config.h>

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "bltin.h"

#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 0
#endif

#define main swcasecmd

static void
usage(void)
{
	fprintf(stderr, "usage: %s [-d] -l|-u\n", getprogname());
	exit(EXIT_FAILURE);
}

int
main(int argc, char **argv)
{
	int ch, dflag, lflag, uflag;

	dflag = 0; /* Use dashes (underscores) */
	lflag = 0; /* To lower */
	uflag = 0; /* To upper */
	while ((ch = getopt(argc, argv, "dlu")) != -1) {
		switch (ch) {
		case 'd':
			dflag = 1;
			break;
		case 'l':
			lflag = 1;
			break;
		case 'u':
			uflag = 1;
			break;
		case '?':
		default:
			usage();
			/* NOTREACHED */
		}
	}
	argc -= optind;
	argv += optind;

	if (lflag && uflag) {
		warnx("-l and -u are incompatible");
		usage();
		/* NOTREACHED */
	}

	if (!lflag && !uflag) {
		warnx("one of -l or -u is required");
		usage();
		/* NOTREACHED */
	}

	while ((ch = getc(stdin)) != EOF) {
		if (isalpha(ch)) {
			if (lflag)
				putc(tolower(ch), stdout);
			if (uflag)
				putc(toupper(ch), stdout);
		} else if (isdigit(ch) || iscntrl(ch)) {
			putc(ch, stdout);
		} else if (dflag) {
			putc('_', stdout);
		} else {
			putc(ch, stdout);
		}
	}

	if (ferror(stdin))
		errx(EXIT_FAILURE, "read error from standard input");

	return EXIT_SUCCESS;
}
