/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * Based on IMHO  Stefan Wallstrm and Bosse Lincoln.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: parser.pmod,v 1.12 2004/01/13 11:01:38 vida Exp $
 */


#include <camas/parser.h>

/*
#define PS_EAT_BLANKS 0
#define PS_EXPECT_TOKEN 1
#define PS_PARSE_IDENT 2
#define PS_PARSE_QSTR 3
#define PS_PARSE_STR1 4
#define PS_PARSE_STR2 5
#define PS_PARSE_STR3 6
#define PS_PARSE_INTEGER 8

#define TOKEN_QSTRING 1
#define TOKEN_STRING 2
#define TOKEN_INTEGER 3
*/

constant blanks   = (< ' ', '\r', '\n', '\t' >);
constant notident = (< ' ', '\r', '\n', '\t', ')' >);

class Parser {
  // variables
  string parse_tmp, parse_label = "";
  int parse_state, parse_level, parse_str_len;
  array (mixed) tokens = ({ });
  mixed parse_result = 0;

  // methods
  void init () {
    tokens = ({ });
    parse_state = 0;
    parse_result = ({ });
    parse_label = "";
  }

  array parseimap (string data, int parse_type, int tokens_to_get, array parserstate) {
    int done = 0;
    int datapos = 0;
    if (parse_state == 1) {
      if (parse_str_len <= sizeof(data)) {
        parse_result = ({ parse_tmp+data[0..parse_str_len-1] }) + parse_result;
        if (sizeof(parse_result) > 1 && parse_type != PT_TOKENS) {
          if (mappingp(parse_result[1])) {
            if (sizeof(parse_label)) {
              parse_result[1][parse_label] = parse_result[0];
              parse_result = parse_result[1..];
              parse_label = "";
            } else {
              parse_label = parse_result[0];
              parse_result = parse_result[1..];
            }
          } else {
            parse_result[1] += ({ parse_result[0] });
            parse_result = parse_result[1..];
          }
        }
        data = data[parse_str_len..];
        parse_state = 0;
      }
      else {
        parse_tmp += data;
        parse_str_len -= sizeof(data);
        data = "";
      }
    }

    int datasize = sizeof (data);
    int lastn = search (reverse (data), "\n");
    if (lastn < 0)
      lastn = 0;
    int leaf = 0;

    while (datapos < datasize-lastn && !done) {
      parse_state = 0;
      while (datapos < datasize-lastn && blanks[data[datapos]])
        datapos++;
      leaf = 0;
      switch (data[datapos]) {
      case '(':
        parse_level++;
        if ((parse_level == 1) && (parse_type == PT_MAPPING)) {
          mapping m = ([ ]);
          parse_result = ({ m }) + parse_result;
        }
        else {
          array a = ({ });
          parse_result = ({ a }) + parse_result;
        }
        datapos++;
        break;

      case ')':
        if(!(--parse_level))
          done=1;
        leaf = 1;
        datapos++;
        break;

      case '\"':
        if (datapos+100 < datasize-lastn) {
          if (sscanf(replace(data[datapos..datapos+100],
                             ({ "\\\\", "\\\"" }), ({ "\\", "\\" })),
                     "\"%s\"", parse_tmp) == 0)
            sscanf(replace(data[datapos..],
                           "\\\"", "\\"), "\"%s\"", parse_tmp);
        }
        else
          sscanf(replace(data[datapos..],
                         ({ "\\\\", "\\\"" }), ({ "\\", "\\" })),
                 "\"%s\"", parse_tmp);
        if (parse_type==PT_QSTR)
          done=1;
        parse_result = ({ replace(parse_tmp,
                                  ({"\\", "\\" }),({ "\"", "\\" })) })+parse_result;
        datapos += sizeof(parse_tmp)+2;
        leaf = 1;
        break;

      case '{':
        string junk = "";
        if (datapos+15 < datasize-lastn)
          sscanf(data[datapos..datapos+15], "{%s}%s\n", parse_tmp, junk);
        else
          sscanf(data[datapos..], "{%s}%s\n", parse_tmp, junk);
        datapos += 3+sizeof(parse_tmp)+sizeof(junk);
        parse_str_len = (int) parse_tmp;
        if (datapos+parse_str_len <= datasize) {
          if (parse_str_len)
            parse_result = ({ data[datapos..datapos+parse_str_len-1] }) + parse_result;
          else
            parse_result = ({ "" }) + parse_result;
          datapos += parse_str_len;
          leaf = 1;
        }
        else {
          parse_tmp = data[datapos..];
          parse_str_len -= (datasize-datapos);
          parse_state=1;
          datapos = datasize;
        }
        break;

      default:
        if (datapos +30 < datasize-lastn) {
          if (sscanf(replace(data[datapos..datapos+30], "]", ")"), "%[^ )\r\n\t]",
                     parse_tmp) == 1 && !notident[data[datapos+sizeof(parse_tmp)]])
            sscanf(replace(data[datapos..], "]", ")"), "%[^ )\r\n\t]",
                   parse_tmp);
        }
        else
          sscanf(replace(data[datapos..], "]", ")"), "%[^ )\r\n\t]",
                 parse_tmp);
        if(parse_tmp=="NIL")
          parse_result = ({ 0 }) + parse_result;
        else
          parse_result = ({ parse_tmp }) + parse_result;
        datapos += sizeof(parse_tmp);
        leaf = 1;
      }
      if ((parse_type == PT_TOKENS) && (sizeof (parse_result) == tokens_to_get))
        done = 1;
      if (leaf) {
        if (sizeof(parse_result) > 1 && parse_type != PT_TOKENS) {
          if (parse_level == 1 && parse_type == PT_MAPPING) {
            if (sizeof(parse_label)) {
              parse_result[1][parse_label] = parse_result[0];
              parse_result = parse_result[1..];
              parse_label = "";
            }
            else {
              parse_label = parse_result[0];
              parse_result = parse_result[1..];
            }
          }
          else {
            parse_result[1] += ({ parse_result[0] });
            parse_result = parse_result[1..];
          }
        }
      }
    }
    data = data[datapos..];

    if (done)
      return ({ 1, (parse_type == PT_TOKENS) ? reverse (parse_result) : parse_result[0], data });
    else
      return ({ 0, "", data });
  }
}
/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

