#include "main.h"

#define MS_PER_MOVE 400
#define MS_UNTIL_NEXT_MOVEMENT 70

PlacePlayer PPlayer[PLAYERNUM];

void DrawCursor()
{
    int i,x,y;
    
    for (i=0;i<PlayerNum;i++) {
	if ( (!BPlayer[i].Lost ) && (PPlayer[i].CannonsLeft) ) {
	    if ( PPlayer[i].SelectedCannon == 0 ) {
		SDL_SetAlpha( CannonPic[0], SDL_SRCALPHA, 128);
    		Blit( BPlayer[i].x*BSIZE, BPlayer[i].y*BSIZE, CannonPic[0]);
		SDL_SetAlpha( CannonPic[0], SDL_SRCALPHA, 0);
	    } else {
		SDL_SetAlpha( BigCannonPic[0], SDL_SRCALPHA, 128);
    		Blit( BPlayer[i].x*BSIZE, BPlayer[i].y*BSIZE, BigCannonPic[0]);
		SDL_SetAlpha( BigCannonPic[0], SDL_SRCALPHA, 0);
	    }
	}
	
	for (x=0; x<2+PPlayer[i].SelectedCannon; x++) {
	    for (y=0; y<2+PPlayer[i].SelectedCannon; y++) {
		if ( PPlayer[i].CannonsLeft > 0 ) {
		    if ( ! FieldFree( BPlayer[i].x+x, BPlayer[i].y+y ) ) {
			Blit( (BPlayer[i].x+x)*BSIZE, (BPlayer[i].y+y)*BSIZE, CantBuildPic );
		    }
		}
	    }
	}
    }
}

void UndrawCursor()
{
    SDL_Rect Rect;
    int i;
    
    Rect.w=20;
    Rect.h=20;

    for (i=0;i<PlayerNum;i++) {
	if ( PPlayer[i].SelectedCannon == 0 ) {
	    Rect.w=2*BSIZE;
	    Rect.h=2*BSIZE;
	} else {
	    Rect.w=3*BSIZE;
	    Rect.h=3*BSIZE;
	}
	Rect.x=BPlayer[i].x*BSIZE;
	Rect.y=BPlayer[i].y*BSIZE;
	SDL_BlitSurface( BackBuffer, &Rect, Screen, &Rect);
	AddThisRect(Rect);
    }
}

int FieldFree( int x, int y)
{
    int WhichPlayer,i,free=1;
    
    for (WhichPlayer=0;WhichPlayer<PlayerNum;WhichPlayer++)
	for (i=0;i<BaPlayer[WhichPlayer].CannonNum;i++) {
	    if (  (x>=BaPlayer[WhichPlayer].Cannon[i].x)&&(x<BaPlayer[WhichPlayer].Cannon[i].x+BaPlayer[WhichPlayer].Cannon[i].Size)
		&&(y>=BaPlayer[WhichPlayer].Cannon[i].y)&&(y<BaPlayer[WhichPlayer].Cannon[i].y+BaPlayer[WhichPlayer].Cannon[i].Size))
		free=0;
	    //printf("%d-%d\t%d-%d\n",BaPlayer[WhichPlayer].Cannon[i].x,x,BaPlayer[WhichPlayer].Cannon[i].y,y);
	}
    for (i=0;i<CastleNum;i++) {
        if (  (x>=Castle[i].x)&&(x<Castle[i].x+2)
	    &&(y>=Castle[i].y)&&(y<Castle[i].y+2))
            free=0;
    }

    for (i=0;i<TankNum;i++) {
	if ( (x==Tank[i].x)&&(y==Tank[i].y) )
	    free=0;	
    }
    
    if ( (x<0)||(x>Width-1)||(y<0)||(y>Height-1) ) return 0;
    
    if (Wall[x][y]) free=0;
    if ((Garbage[x][y])||(Landscape[x][y]==127)) free=0;
    
    return free;
}

void ReallyPutCannon( int WhichPlayer )
{
    SDL_Surface *Pic;

    if ( PPlayer[WhichPlayer].SelectedCannon == 0 ) 
	Pic=CannonPic[0];
    else
	Pic=BigCannonPic[0];

    Blit    ( BPlayer[WhichPlayer].x*BSIZE, BPlayer[WhichPlayer].y*BSIZE, Pic);
    BlitToBB( BPlayer[WhichPlayer].x*BSIZE, BPlayer[WhichPlayer].y*BSIZE, Pic);
    PPlayer[WhichPlayer].CannonsLeft-=1+PPlayer[WhichPlayer].SelectedCannon*2;
    if (BaPlayer[WhichPlayer].CannonNum<MAX_CANNON_NUM) {
        BaPlayer[WhichPlayer].Cannon[BaPlayer[WhichPlayer].CannonNum].x=BPlayer[WhichPlayer].x;
        BaPlayer[WhichPlayer].Cannon[BaPlayer[WhichPlayer].CannonNum].y=BPlayer[WhichPlayer].y;
        BaPlayer[WhichPlayer].Cannon[BaPlayer[WhichPlayer].CannonNum].Shot=0;
        BaPlayer[WhichPlayer].Cannon[BaPlayer[WhichPlayer].CannonNum].Destroyed=0;
        BaPlayer[WhichPlayer].Cannon[BaPlayer[WhichPlayer].CannonNum].Type=PPlayer[WhichPlayer].SelectedCannon;
        BaPlayer[WhichPlayer].Cannon[BaPlayer[WhichPlayer].CannonNum].Size=2+PPlayer[WhichPlayer].SelectedCannon;
        BaPlayer[WhichPlayer].Cannon[BaPlayer[WhichPlayer].CannonNum].Stability=6+12*PPlayer[WhichPlayer].SelectedCannon;
        BaPlayer[WhichPlayer].CannonNum++;
    } else 
	printf("Too many Cannons\n");
}

void PutCannon( int WhichPlayer )
{
    int x,y,w,h,ready=1;
    
    if (PPlayer[WhichPlayer].CannonsLeft<1+PPlayer[WhichPlayer].SelectedCannon*2)
	return;
	
    if ( PPlayer[WhichPlayer].SelectedCannon == 0 ) {
	w=2;
	h=2;
    } else {
	w=3;
	h=3;
    }
    
    for (x=0;x<w;x++)
	for (y=0;y<h;y++)
	    if (!BPlayer[WhichPlayer].Secured[x+BPlayer[WhichPlayer].x][y+BPlayer[WhichPlayer].y]) ready=0;

    for (x=0;x<w;x++)
	for (y=0;y<h;y++)
	    if ( ! FieldFree(BPlayer[WhichPlayer].x+x,BPlayer[WhichPlayer].y+y) ) ready=0;
    
    if (ready) {
        char data[3];

	ReallyPutCannon( WhichPlayer );
        data[0]=2;
        data[1]=NET_PUTCANNON;
        data[2]=WhichPlayer;
        Net_Send(data);

    }
}

void AdjustPosition( int i )
{
    if ( BPlayer[i].y > Height-2 ) BPlayer[i].y=Height-2;
    if ( BPlayer[i].y < -1 ) BPlayer[i].y=-1;
    if ( BPlayer[i].x > Width-2 ) BPlayer[i].x=Width-2;
    if ( BPlayer[i].x < -1 ) BPlayer[i].x=-1;
}

int PlaceEvents(const SDL_Event *event)
{
    int i;
    Uint8 *keys,data[3];

    switch (event->type) {
	case SDL_MOUSEBUTTONDOWN:
//	    SDL_GetMouseState(&MouseX, &MouseY);
	break;    
	case SDL_KEYDOWN:
	    UndrawCursor();
	    keys = SDL_GetKeyState(NULL);
	    for (i=0;i<PlayerNum;i++) 
		if ( (!BPlayer[i].Lost) && (BPlayer[i].Local) ) {
		    if ( event->key.keysym.sym == BPlayer[i].Up    ) BPlayer[i].y--;
		    if ( event->key.keysym.sym == BPlayer[i].Down  ) BPlayer[i].y++;
		    if ( event->key.keysym.sym == BPlayer[i].Left  ) BPlayer[i].x--;
		    if ( event->key.keysym.sym == BPlayer[i].Right ) BPlayer[i].x++;
		    if ( event->key.keysym.sym == BPlayer[i].Button1 ) PutCannon(i);
		    if ( event->key.keysym.sym == BPlayer[i].Button2 ) {
			PPlayer[i].SelectedCannon=1-PPlayer[i].SelectedCannon;
			data[0]=2;
			data[1]=NET_BUTTON2;
			data[2]=i;
			Net_Send(data);
		    }
		    if ( PPlayer[i].CannonsLeft < 3 )
			PPlayer[i].SelectedCannon=0;
		    AdjustPosition(i);
		    SendPos(i,NET_PLACE_PLAYER_MOVE);
		}
	    DrawCursor();
	    Update();
	break;
    }
    
    return NormalEvents(event);
}

void ResetPlayer()
{

}

void InitPlace()
{
    int i,x,y,PlayersLeft=PlayerNum;
    char text[100];
    Coord coord;

    if (PlayerNum>2) {
        BPlayer[0].x=Width/4;
	BPlayer[0].y=Height/4;
        BPlayer[1].x=Width/4*3;
        BPlayer[1].y=Height/4;
	BPlayer[2].x=Width/4;
        BPlayer[2].y=Height/4*3;
	BPlayer[3].x=Width/4*3;
        BPlayer[3].y=Height/4*3;
    }
    for (i=0;i<PlayerNum;i++) {
	PPlayer[i].SecuredCastles=CastlesSurrounded(i);
	if (PlayerNum==2) {
            BPlayer[i].x=Width/4*(1+i*2);
	    BPlayer[i].y=Height/2;
	}
	PPlayer[i].SecuredFields=0;
	PPlayer[i].SelectedCannon=0;
	for (x=0;x<Width;x++)
	    for (y=0;y<Height;y++)
		if (BPlayer[i].Secured[x][y]) PPlayer[i].SecuredFields++;
	PPlayer[i].CannonsLeft = PPlayer[i].SecuredFields/300;
//	printf("%d - %d\n",PPlayer[i].SecuredFields,PPlayer[i].CannonsLeft);
	PPlayer[i].CannonsLeft += PPlayer[i].SecuredCastles;
	if (PPlayer[i].SecuredCastles==0) {
	    if (BPlayer[i].Lives) {
		BPlayer[i].Lives--;
		ResetPlayer();
	    } else {
		BPlayer[i].Lost = 1;
		PlayersLeft--;
	    }
	}
//	printf("%d # %d\n",PPlayer[i].SecuredCastles,PPlayer[i].CannonsLeft);
    }
    if (PlayersLeft == 0) {
	if (PlayerNum == 1) {
	    XCenteredString(Screen, Height*BSIZE/2, "Game Lost");	
	} else {
	    XCenteredString(Screen, Height*BSIZE/2, "Draw Game");
	}
	SDL_UpdateRect(Screen,0,0,0,0);
	SDL_Delay(6000);
	Quit=1;
    }
    if (PlayersLeft==1 && PlayerNum>1) {
        for (i=0;i<PlayerNum;i++)
	    if (!BPlayer[i].Lost)
		sprintf(text,"%s has won!",BPlayer[i].Name);
	XCenteredString(Screen, Height*BSIZE/2, text);
	SDL_UpdateRect(Screen,0,0,0,0);
	SDL_Delay(6000);
	Quit=1;
    }

    if (Conquer) {
	for (i=0;i<PlayerNum;i++) {
	    coord = Center(i);
	    BPlayer[i].x = coord.x;
	    BPlayer[i].y = coord.y;
	}
    }
    
    Blit(0, 0, BackBuffer);
    DrawCursor();
    Update();
}

int End()
{
    int end=1,i;
    
    for (i=0;i<PlayerNum;i++)
	if (PPlayer[i].CannonsLeft>0) end=0;

    return end;
}

void PlaceMove( void Undraw(), void Draw(), int sig)
{
    Uint8 *keys,i,update=0;
    
    keys = SDL_GetKeyState(NULL);
    
    for (i=0;i<PlayerNum;i++) 
	if ( (!BPlayer[i].Lost) && (BPlayer[i].Local) )
	{
	if ( keys[BPlayer[i].Up   ] == SDL_PRESSED ) BPlayer[i].FastUp   +=Speed;
	else BPlayer[i].FastUp   =0;
	if ( keys[BPlayer[i].Down ] == SDL_PRESSED ) BPlayer[i].FastDown +=Speed;
	else BPlayer[i].FastDown =0;
	if ( keys[BPlayer[i].Left ] == SDL_PRESSED ) BPlayer[i].FastLeft +=Speed;
	else BPlayer[i].FastLeft =0;
	if ( keys[BPlayer[i].Right] == SDL_PRESSED ) BPlayer[i].FastRight+=Speed;
	else BPlayer[i].FastRight=0;
    
	if ( BPlayer[i].FastUp    > MS_PER_MOVE ) {
	    Undraw();
	    BPlayer[i].y--;
	    BPlayer[i].FastUp-=MS_UNTIL_NEXT_MOVEMENT;
	    update=1;
	    SendPos(i,sig);
	}
	if ( BPlayer[i].FastDown  > MS_PER_MOVE ) {
	    Undraw();
	    BPlayer[i].y++;
	    BPlayer[i].FastDown-=MS_UNTIL_NEXT_MOVEMENT;
	    update=1;
	    SendPos(i,sig);
	}
	if ( BPlayer[i].FastLeft  > MS_PER_MOVE ) {
	    Undraw();
	    BPlayer[i].x--;
	    BPlayer[i].FastLeft-=MS_UNTIL_NEXT_MOVEMENT;
	    update=1;
	    SendPos(i,sig);
	}
	if ( BPlayer[i].FastRight > MS_PER_MOVE ) {
	    Undraw();
	    BPlayer[i].x++;
	    BPlayer[i].FastRight-=MS_UNTIL_NEXT_MOVEMENT;
	    update=1;
	    SendPos(i,sig);
	}
	AdjustPosition(i);
    }
    if (update) {
	Draw();
	Update();
    }
}

void Place()
{
    Phase = PLACE_PHASE;
    SDL_EventState(SDL_KEYDOWN, SDL_IGNORE);
    SDL_SetEventFilter(&PlaceEvents);
    InitPlace();
    if (!Quit) {
	Net_WaitForStart();
        ShowText("Place Your Cannons!");
        Net_WaitForStart();
        SDL_EventState(SDL_KEYDOWN, SDL_ENABLE);
        Now=SDL_GetTicks();
        EndOfPhase=Now+15*1000;
        printf("-- Place phase begins\n");
    }
    while ((!Quit)&&(SDL_GetTicks()<EndOfPhase)&&(!End())) {
	SDL_PollEvent(&event);
	GetSpeed();
	PlaceMove( &UndrawCursor, &DrawCursor, NET_PLACE_PLAYER_MOVE);
	PrintTime();
	Update();
	SDL_Delay(10);
	Network();
    }
    printf("-- Place phase has finished\n");
}
