/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 * GtkBgPixmap Copyright (C) 2000 Stefan Ondrejicka <ondrej@idata.sk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GTK_BG_PIXMAP_H__
#define __GTK_BG_PIXMAP_H__


#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_TYPE_BG_PIXMAP			 (gtk_bg_pixmap_get_type ())
#define GTK_BG_PIXMAP(obj)			 (GTK_CHECK_CAST ((obj), GTK_TYPE_BG_PIXMAP, GtkBgPixmap))
#define GTK_BG_PIXMAP_CLASS(klass)		 (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_BG_PIXMAP, GtkBgPixmapClass))
#define GTK_IS_BG_PIXMAP(obj)		 (GTK_CHECK_TYPE ((obj), GTK_TYPE_BG_PIXMAP))
#define GTK_IS_BG_PIXMAP_CLASS(klass)	 (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_BG_PIXMAP))


typedef struct _GtkBgPixmap		GtkBgPixmap;
typedef struct _GtkBgPixmapClass	GtkBgPixmapClass;

struct _GtkBgPixmap
{
  GtkWidget widget;
  
  GdkPixmap *pixmap;
  gint	    pixmap_width;
  gint      pixmap_height;
};

struct _GtkBgPixmapClass
{
  GtkWidgetClass parent_class;
};


GtkType	   gtk_bg_pixmap_get_type		(void);
GtkWidget* gtk_bg_pixmap_new			(GdkPixmap	*pixmap);
void	   gtk_bg_pixmap_set			(GtkBgPixmap	*pixmap,
						 GdkPixmap	*val);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_BG_PIXMAP_H__ */
