/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "config.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <gtk/gtk.h>
#include <math.h>
#include "gtkmultirowsel.h"
#include "gprop.h"
#include "recurse.h"

#include "pixmaps/stock_ok.xpm"
#include "pixmaps/stock_close.xpm"

extern char *combo_patterns[];

static char *st_options[] = {
		"",
		"-antialias",
		"-quality 100",
		"-quality 75",
		NULL
	};

struct ext_dlg_t {
	gboolean	source;
	GSList		*thumb_selection;
	GtkWidget	*tl;
	GtkWidget	*actionbtn;
	GtkWidget	*src_frame;
	GtkWidget	*src_dir;
	GtkWidget	*src_pattern;
	GtkWidget	*src_size;
	GtkWidget	*progress;
	GtkWidget	*frame;
};

static void ext_dlg_kill(w, ext_dlg)
GtkWidget *w;
struct ext_dlg_t *ext_dlg;
{
	while (ext_dlg->thumb_selection)
	{
		g_free(ext_dlg->thumb_selection->data);
		ext_dlg->thumb_selection = g_slist_remove_link(ext_dlg->thumb_selection, ext_dlg->thumb_selection);
	}

	if (toplevel_window)
		gtk_signal_disconnect_by_func(GTK_OBJECT(toplevel_window),
			GTK_SIGNAL_FUNC(KillAll), &ext_dlg->tl);

	g_free(ext_dlg);
}

static void ext_dlg_action(w, ext_dlg)
GtkWidget *w;
struct ext_dlg_t *ext_dlg;
{
	GList *ptr;
	picentry_t *pe;
	char *pattern, *dir;
	GSList *ptrn;
	int num;
	char *p;
	int l;
	int size;

	while (ext_dlg->thumb_selection)
	{
		g_free(ext_dlg->thumb_selection->data);
		ext_dlg->thumb_selection = g_slist_remove_link(ext_dlg->thumb_selection, ext_dlg->thumb_selection);
	}

	dir  = gtk_entry_get_text(GTK_ENTRY(ext_dlg->src_dir));
	pattern = gtk_entry_get_text(GTK_ENTRY(ext_dlg->src_pattern));


	if (!dir || !*dir)
		return;

	if (pattern && !*pattern)
		pattern = NULL;

	size = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(ext_dlg->src_size));

	gprop_set_str("ext-dlg-src-pattern", pattern);
	gprop_set_str("ext-dlg-src-dir", dir);
	gprop_set_int("ext-dlg-src-size", size);

        p = pattern;
	ptrn = NULL;
        while (p && *p)
        {
                p += strspn(p , " ");
                l = strcspn(p , " ");
                if (l)
                        ptrn = g_slist_append(ptrn, g_strndup(p, l));
                p += l;
        }

	pe = picentry_new(g_strdup(dir));
	ptr = g_list_append(NULL, (gpointer)pe);

	num = 1;

	recurse_dir(&ptr, &num, ptrn, size,
		(recurse_getname_func)picentry_get_name,
		(recurse_newentry_func)picentry_clone,
		(recurse_free_func)picentry_free);

	do 
	{
		if (ptr)
		{
			pe = (picentry_t *)ptr->data;

			ext_dlg->thumb_selection = g_slist_append(ext_dlg->thumb_selection, pe->name);
			pe->name = NULL;
			picentry_free(pe);
		}
	} while ((ptr = g_list_remove_link(ptr, ptr)));

	while (ptrn)
	{
		g_free(ptrn->data);
		ptrn = g_slist_remove_link(ptrn, ptrn);
	}
}

static void ext_source_dlg(box, ext_dlg)
GtkWidget *box;
struct ext_dlg_t *ext_dlg;
{
	GtkWidget *tab,*label,*pbox;
	GtkAdjustment *adj;
	GList *ptrn;
	int i,size;
	char *p;

	ext_dlg->src_frame = gtk_frame_new(gettext("Images selection"));
	gtk_box_pack_start(GTK_BOX(box), ext_dlg->src_frame, FALSE, FALSE, 2);
	gtk_widget_show(ext_dlg->src_frame);

	tab = gtk_table_new(2, 3, FALSE);
	gtk_container_add(GTK_CONTAINER(ext_dlg->src_frame), tab);
	gtk_widget_show(tab);

	ext_dlg->src_dir = guitl_tab_add_path_entry(tab, gettext("Source Directory: "), 0, 0, TRUE);

	if (gprop_get_str("ext-dlg-src-dir", &p))
		gtk_entry_set_text(GTK_ENTRY(ext_dlg->src_dir), p ? p : "");

	label = gtk_label_new(gettext("Pattern for recursion: "));
        gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(tab), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(label);

	ext_dlg->src_pattern = gtk_combo_new();
	gtk_table_attach(GTK_TABLE(tab), ext_dlg->src_pattern, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(ext_dlg->src_pattern);
	ptrn = NULL;
	for (i = 0; combo_patterns[i] ; i++)
		ptrn = g_list_append(ptrn, combo_patterns[i]);
	gtk_combo_set_popdown_strings(GTK_COMBO(ext_dlg->src_pattern), ptrn);
	while (ptrn) ptrn = g_list_remove_link(ptrn, ptrn);
	ext_dlg->src_pattern = GTK_COMBO(ext_dlg->src_pattern)->entry;
	if (gprop_get_str("ext-dlg-src-pattern", &p))
		gtk_entry_set_text(GTK_ENTRY(ext_dlg->src_pattern), p ? p : "");


	pbox = gtk_hbox_new(FALSE, 0);
	gtk_table_attach(GTK_TABLE(tab), pbox, 0, 2, 2, 3, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2);
	gtk_widget_show(pbox);

        label = gtk_label_new(gettext("Minimal picture size when recursing directories: "));
        gtk_box_pack_start(GTK_BOX(pbox) , label , FALSE , TRUE , 0);
        gtk_widget_show(label);

	if (!gprop_get_int("ext-dlg-src-size", &size))
		size = 0;
	
        adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat)size, 
                        0.0, 1000000.0, 1.0, 10.0, 0.0);
        ext_dlg->src_size = gtk_spin_button_new(adj , 0 , 0);
        gtk_widget_set_usize(ext_dlg->src_size , 
                gdk_string_width((ext_dlg->src_size)->style->font , "wwwwwwwww") , -1);
        gtk_box_pack_start(GTK_BOX(pbox) , ext_dlg->src_size , FALSE , TRUE , 5);
        gtk_widget_show(ext_dlg->src_size);

        label = gtk_label_new(gettext("kB"));
        gtk_box_pack_start(GTK_BOX(pbox) , label , FALSE , TRUE , 5);
        gtk_widget_show(label);



}

void ext_do_dlg(ext_dlg, title, frame_label, button_label)
struct ext_dlg_t *ext_dlg;
char *title;
char *frame_label;
char *button_label;
{
	GtkWidget *bbox,*btn,*box;

	ext_dlg->tl = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(ext_dlg->tl), title);
	gtk_container_border_width(GTK_CONTAINER(ext_dlg->tl), 4);
	gtk_signal_connect(GTK_OBJECT(ext_dlg->tl), "destroy",
		GTK_SIGNAL_FUNC(ext_dlg_kill), ext_dlg);

	gtk_signal_connect(GTK_OBJECT(toplevel_window),
		"destroy", GTK_SIGNAL_FUNC(KillAll), &ext_dlg->tl);

	box = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(ext_dlg->tl), box);
	gtk_widget_show(box);

	if (ext_dlg->source)
		ext_source_dlg(box, ext_dlg);

	ext_dlg->frame = gtk_frame_new(frame_label);
	gtk_box_pack_start(GTK_BOX(box), ext_dlg->frame, FALSE, FALSE, 5);
	gtk_widget_show(ext_dlg->frame);

	ext_dlg->progress = gtk_progress_bar_new();
	gtk_box_pack_start(GTK_BOX(box), ext_dlg->progress, FALSE, FALSE, 4);

	bbox = gtk_hbutton_box_new();
	gtk_box_pack_start(GTK_BOX(box), bbox, FALSE, FALSE, 4);
	gtk_widget_show(bbox);

	ext_dlg->actionbtn = btn = guitl_pixmap_button(stock_ok_xpm, button_label);
	gtk_container_add(GTK_CONTAINER(bbox), btn);
	gtk_widget_show(btn);
	if (ext_dlg->source)
		gtk_signal_connect(GTK_OBJECT(btn), "clicked",
			GTK_SIGNAL_FUNC(ext_dlg_action), ext_dlg);

	btn = guitl_pixmap_button(stock_close_xpm, gettext("Cancel"));
	gtk_container_add(GTK_CONTAINER(bbox), btn);
	gtk_widget_show(btn);
	gtk_signal_connect(GTK_OBJECT(btn), "clicked",
		GTK_SIGNAL_FUNC(KillWin), ext_dlg->tl);
}

static void ext_dlg_action_start(ext_dlg)
struct ext_dlg_t *ext_dlg;
{
	gtk_progress_bar_update(GTK_PROGRESS_BAR(ext_dlg->progress), (gfloat)0.0);
	gtk_widget_show(ext_dlg->progress);
	gtk_widget_set_sensitive(ext_dlg->frame, FALSE);
	if (ext_dlg->source)
		gtk_widget_set_sensitive(ext_dlg->src_frame, FALSE);
	gtk_widget_set_sensitive(ext_dlg->actionbtn, FALSE);

	while (gtk_events_pending()) gtk_main_iteration();
}

/*****************/
/* BATCH SCALING */
/****************/
struct ext_scale_dlg_t {
	struct ext_dlg_t	dlg;
	GtkWidget		*aspect;
	GtkWidget		*dir;
	GtkWidget		*size;
	GtkWidget		*add;
};

static void ext_scale_image_scale_do(imagename, dir, width, height, additional)
char *imagename;
char *dir;
int width;
int height;
char *additional;
{
	char *basename;
	char *p;

	if ((basename = strrchr(imagename, '/')))
		basename++;
	else
		basename = imagename;

	p = g_strdup_printf("convert -geometry %dx%d %s \"%s\" \"%s/%s\"", 
		width, height, 
		additional ? additional : "",
		imagename, dir, basename);

	system(p);

	g_free(p);
}

static void ext_scale_image_dlg_scale(widget, ext_scale_dlg)
GtkWidget *widget;
struct ext_scale_dlg_t *ext_scale_dlg;
{
	char *p,*dir,*additional;
	int w,h;
	GSList *ptr;
	gboolean aspect;
	int num, cur;

	if (!ext_scale_dlg->dlg.thumb_selection)
	{
		gdk_beep();
		return;
	}

	dir = gtk_entry_get_text(GTK_ENTRY(ext_scale_dlg->dir));
	if (!dir || !dir[0] || makealldirs(dir))
	{
		gdk_beep();
		return;
	}

	p = gtk_entry_get_text(GTK_ENTRY(ext_scale_dlg->size));
	if (!p || (sscanf(p, "%dx%d", &w,&h) != 2) || !w || !h)
	{
		gdk_beep();
		return;
	}

	additional = gtk_entry_get_text(GTK_ENTRY(ext_scale_dlg->add));

	aspect = GTK_TOGGLE_BUTTON(ext_scale_dlg->aspect)->active;
	dir = g_strdup(dir);

	gprop_set_int("ext_scale-width", w);
	gprop_set_int("ext_scale-height", h);
	gprop_set_str("ext_scale-directory", dir);
	gprop_set_bool("ext_scale-aspect", aspect);
	gprop_set_str("ext_scale-additional", additional);

	ext_dlg_action_start(ext_scale_dlg);

	gtk_window_set_title(GTK_WINDOW(ext_scale_dlg->dlg.tl), gettext("ChBg: batch scale (scaling ...)"));
	while (gtk_events_pending()) gtk_main_iteration();

	num = g_slist_length(ext_scale_dlg->dlg.thumb_selection);
	cur = 1;

	for (ptr = ext_scale_dlg->dlg.thumb_selection; ptr; ptr = ptr->next, cur++)
	{
		char *name = (char *)ptr->data ;
		int width, height;

		width = w;
		height = h;

		if (aspect)
		{
			double factor;
			absimg_image_t *img;

			if ((img = absimg_load(name)))
			{
				factor = MAX(((double)img->rgb_width)/(double)w, ((double)img->rgb_height)/(double)h);

				width = (int) ceil(((double)img->rgb_width)/factor);
				height = (int) ceil(((double)img->rgb_height)/factor);
				absimg_destroy(img);
			}
		}
		while (gtk_events_pending()) gtk_main_iteration();

		ext_scale_image_scale_do(name, dir, width, height, additional);

		if (ext_scale_dlg->dlg.tl)
		{
			gtk_progress_bar_update(GTK_PROGRESS_BAR(ext_scale_dlg->dlg.progress), (gfloat)cur/(gfloat)num);
			while (gtk_events_pending()) gtk_main_iteration();
		}
		else
			break;
	}

	g_free(dir);

	if (ext_scale_dlg->dlg.tl)
		gtk_widget_destroy(ext_scale_dlg->dlg.tl);
}

void ext_scale_image_dlg(source, thumb_selection)
gboolean source;
GSList *thumb_selection;
{
	struct ext_scale_dlg_t *ext_scale_dlg;
	GtkWidget *tab,*label;
	GList *ptr;
	int i;
	int w,h;
	char *p;
	char *st_sizes[] = {
		"160x120",
		"320x240",
		"640x480",
		"800x600",
		"1024x768",
		"1280x1024",
		"1600x1200",
		NULL
	};

	if (!source && !thumb_selection)
	{
		gdk_beep();
		return;
	}

	ext_scale_dlg = g_malloc(sizeof(struct ext_scale_dlg_t));

	ext_scale_dlg->dlg.thumb_selection = thumb_selection;
	ext_scale_dlg->dlg.source = source;

	ext_do_dlg(ext_scale_dlg, gettext("ChBg: batch scaling"),
		gettext("Scaling parameters"), gettext("Scale"));

	tab = gtk_table_new(2, 4, FALSE);
	gtk_container_add(GTK_CONTAINER(ext_scale_dlg->dlg.frame), tab);
	gtk_widget_show(tab);

	ext_scale_dlg->dir = guitl_tab_add_path_entry(tab, gettext("Destination directory: "), 0, 0, TRUE);
	if (gprop_get_str("ext_scale-directory", &p))
		gtk_entry_set_text(GTK_ENTRY(ext_scale_dlg->dir), p ? p : "");

	label = gtk_label_new(gettext("Dimensions: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(tab), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(label);
	
	ext_scale_dlg->size = gtk_combo_new();
	gtk_table_attach(GTK_TABLE(tab), ext_scale_dlg->size, 1, 2, 1, 2, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2);
	gtk_widget_show(ext_scale_dlg->size);
	ptr = NULL;
	for (i = 0; st_sizes[i]; i++)
		ptr = g_list_append(ptr, st_sizes[i]);
	gtk_combo_set_popdown_strings(GTK_COMBO(ext_scale_dlg->size), ptr);
	while (ptr) ptr = g_list_remove_link(ptr, ptr);
	ext_scale_dlg->size = GTK_COMBO(ext_scale_dlg->size)->entry;
	if (gprop_get_int("ext_scale-width", &w) &&
	    gprop_get_int("ext_scale-height", &h))
	{
		char pom[64];
		sprintf(pom, "%dx%d", w, h);
		gtk_entry_set_text(GTK_ENTRY(ext_scale_dlg->size), pom);
	}

	label = gtk_label_new(gettext("Additional convert options: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(tab), label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(label);
	
	ext_scale_dlg->add = gtk_combo_new();
	gtk_table_attach(GTK_TABLE(tab), ext_scale_dlg->add, 1, 2, 2, 3, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2);
	gtk_widget_show(ext_scale_dlg->add);
	ptr = NULL;
	for (i = 0; st_options[i]; i++)
		ptr = g_list_append(ptr, st_options[i]);
	gtk_combo_set_popdown_strings(GTK_COMBO(ext_scale_dlg->add), ptr);
	while (ptr) ptr = g_list_remove_link(ptr, ptr);
	ext_scale_dlg->add = GTK_COMBO(ext_scale_dlg->add)->entry;
	if (gprop_get_str("ext_scale-additional", &p))
		gtk_entry_set_text(GTK_ENTRY(ext_scale_dlg->add), p ? p : "");

	ext_scale_dlg->aspect = gtk_check_button_new_with_label(gettext("Keep aspect ratio"));
	gtk_table_attach(GTK_TABLE(tab), ext_scale_dlg->aspect, 0, 2, 3, 4, GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(ext_scale_dlg->aspect);
	if (gprop_get_bool("ext_scale-aspect", &i))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ext_scale_dlg->aspect), i);

	gtk_signal_connect(GTK_OBJECT(ext_scale_dlg->dlg.actionbtn), "clicked",
		GTK_SIGNAL_FUNC(ext_scale_image_dlg_scale), ext_scale_dlg);

	gtk_widget_show_now(ext_scale_dlg->dlg.tl);
	if (GTK_WIDGET_REALIZED(ext_scale_dlg->dlg.tl))
		gdk_window_raise(ext_scale_dlg->dlg.tl->window);
}


/***************************/
/* BATCH FORMAT CONVERTING */
/***************************/
struct ext_convert_dlg_t {
	struct ext_dlg_t	dlg;
	GtkWidget		*dir;
	GtkWidget		*format;
	GtkWidget		*add;
};



static char *ext_convert_adjust_format(line)
char *line;
{
	char *p;
	char *format,*descr,*type;
	int i;
	char *bad_formats[] = {
		"H",
		"HISTOGRAM",
		"HTM",
		"HTML",
		"ICC",
		"MAP",
		"NETSCAPE",
		"PM",
		"PREVIEW",
		"SHTML",
		"UIL",
		"X",
		NULL
	};

	p = line+strlen(line)-1;
	while (p > line && isspace(*p)) {*p = '\0'; p--;}

	p = line;
	while (isspace(*p)) p++;

	format = strtok(p, " ");
	type = strtok(NULL, " ");
	descr = strtok(NULL, "");
	format = strtok(format, "*");

	for (i = 0; bad_formats[i]; i++)
	{
		if (!strcmp(bad_formats[i], format))
			return NULL;
	}

	if (type[1] == 'w')
	{
		return g_strconcat(format, " -", descr, NULL);
	}

	return NULL;
}

static GList *ext_convert_image_get_formats()
{
	FILE *f;
	GList *ret = NULL;
	char line[256];
	gboolean formats = FALSE;

	if (!(f = popen("convert", "r")))
	{
		perror("popen(convert)");
		return NULL;
	}

	while (fgets(line, sizeof(line)-1, f))
	{
		char *p;

		if (!formats && !strncmp(line, "----------", 10))
		{
			formats = TRUE;
		}
		else if (!strcmp(line, "\n") || !strcmp(line, "\r\n"))
		{
			formats = FALSE;
		}
		else if (formats)
		{
			p = ext_convert_adjust_format(line);
			if (p)
				ret = g_list_append(ret, p);
		}
	}
	pclose(f);

	return ret;
}

static void ext_convert_image_convert_do(imagename, dir, format, additional)
char *imagename;
char *dir;
char *format;
char *additional;
{
	char *basename,*fmt;
	char *p;

	if ((basename = strrchr(imagename, '/')))
		basename++;
	else
		basename = imagename;

	if ((p = strrchr(basename, '.')))
		basename = g_strndup(basename, p - basename);
	else
		basename = g_strdup(basename);

	fmt = g_strdup(format);
	for (p = fmt; *p ; p++)
		*p = tolower(*p);

	p = basename;
	basename = g_strconcat(basename, ".", fmt, NULL);
	g_free(fmt);
	g_free(p);

	p = g_strdup_printf("convert %s \"%s\" %s:\"%s/%s\"", 
		additional ? additional : "",
		imagename, format, dir, basename);

	g_free(basename);

	system(p);

	g_free(p);
}

static void ext_convert_image_dlg_convert(widget, ext_convert_dlg)
GtkWidget *widget;
struct ext_convert_dlg_t *ext_convert_dlg;
{
	char *dir,*format,*additional;
	int num,cur;
	GSList *ptr;

	if (!ext_convert_dlg->dlg.thumb_selection)
	{
		gdk_beep();
		return;
	}

	dir = gtk_entry_get_text(GTK_ENTRY(ext_convert_dlg->dir));
	if (!dir || !dir[0] || makealldirs(dir))
	{
		gdk_beep();
		return;
	}

	additional = gtk_entry_get_text(GTK_ENTRY(ext_convert_dlg->add));

	format = gtk_entry_get_text(GTK_ENTRY(ext_convert_dlg->format));

	gprop_set_str("ext_convert-directory", dir);
	gprop_set_str("ext_convert-format", format);
	gprop_set_str("ext_convert-additional", additional);

	dir = g_strdup(dir);
	format = g_strndup(format, strcspn(format, " "));

	ext_dlg_action_start(ext_convert_dlg);

	gtk_window_set_title(GTK_WINDOW(ext_convert_dlg->dlg.tl), gettext("ChBg: batch format conversion (converting ...)"));
	while (gtk_events_pending()) gtk_main_iteration();

	num = g_slist_length(ext_convert_dlg->dlg.thumb_selection);
	cur = 1;

	for (ptr = ext_convert_dlg->dlg.thumb_selection; ptr; ptr = ptr->next, cur++)
	{
		while (gtk_events_pending()) gtk_main_iteration();

		ext_convert_image_convert_do((char *)ptr->data, dir, format, additional);

		if (ext_convert_dlg->dlg.tl)
		{
			gtk_progress_bar_update(GTK_PROGRESS_BAR(ext_convert_dlg->dlg.progress), (gfloat)cur/(gfloat)num);
			while (gtk_events_pending()) gtk_main_iteration();
		}
		else
			break;
	}

	if (ext_convert_dlg->dlg.tl)
		gtk_widget_destroy(ext_convert_dlg->dlg.tl);

	g_free(format);
	g_free(dir);
}

void ext_convert_image_dlg(source, thumb_selection)
gboolean source;
GSList *thumb_selection;
{
	struct ext_convert_dlg_t *ext_convert_dlg;
	static GList *st_formats = NULL;
	GtkWidget *tab,*label;
	char *p;
	int i;
	GList *ptr;

	if (!source && !thumb_selection)
	{
		gdk_beep();
		return;
	}

	if (!st_formats)
		st_formats = ext_convert_image_get_formats();

	ext_convert_dlg = g_malloc(sizeof(struct ext_convert_dlg_t));

	ext_convert_dlg->dlg.thumb_selection = thumb_selection;
	ext_convert_dlg->dlg.source = source;

	ext_do_dlg(ext_convert_dlg, gettext("ChBg: batch format conversion"),
		gettext("Format conversion parameters"), gettext("Convert"));

	tab = gtk_table_new(2, 3, FALSE);
	gtk_container_add(GTK_CONTAINER(ext_convert_dlg->dlg.frame), tab);
	gtk_widget_show(tab);

	ext_convert_dlg->dir = guitl_tab_add_path_entry(tab, gettext("Destination directory: "), 0, 0, TRUE);
	if (gprop_get_str("ext_scale-directory", &p))
		gtk_entry_set_text(GTK_ENTRY(ext_convert_dlg->dir), p ? p : "");

	label = gtk_label_new(gettext("Image format: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(tab), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(label);
	
	ext_convert_dlg->format = gtk_combo_new();
	gtk_table_attach(GTK_TABLE(tab), ext_convert_dlg->format, 1, 2, 1, 2, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2);
	gtk_widget_show(ext_convert_dlg->format);
	gtk_combo_set_popdown_strings(GTK_COMBO(ext_convert_dlg->format), st_formats);
	ext_convert_dlg->format = GTK_COMBO(ext_convert_dlg->format)->entry;
	gtk_entry_set_editable(GTK_ENTRY(ext_convert_dlg->format), FALSE);
	if (gprop_get_str("ext_convert-format", &p))
		gtk_entry_set_text(GTK_ENTRY(ext_convert_dlg->format), p ? p : "");
	label = gtk_label_new(gettext("Additional convert options: "));
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(tab), label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(label);
	
	ext_convert_dlg->add = gtk_combo_new();
	gtk_table_attach(GTK_TABLE(tab), ext_convert_dlg->add, 1, 2, 2, 3, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2);
	gtk_widget_show(ext_convert_dlg->add);
	ptr = NULL;
	for (i = 0; st_options[i]; i++)
		ptr = g_list_append(ptr, st_options[i]);
	gtk_combo_set_popdown_strings(GTK_COMBO(ext_convert_dlg->add), ptr);
	ext_convert_dlg->add = GTK_COMBO(ext_convert_dlg->add)->entry;
	if (gprop_get_str("ext_convert-additional", &p))
		gtk_entry_set_text(GTK_ENTRY(ext_convert_dlg->add), p ? p : "");


	gtk_signal_connect(GTK_OBJECT(ext_convert_dlg->dlg.actionbtn), "clicked",
		GTK_SIGNAL_FUNC(ext_convert_image_dlg_convert), ext_convert_dlg);

	gtk_widget_show_now(ext_convert_dlg->dlg.tl);
	if (GTK_WIDGET_REALIZED(ext_convert_dlg->dlg.tl))
		gdk_window_raise(ext_convert_dlg->dlg.tl->window);
}

