/*
 * Cheops Network User Interface
 *
 * Copyright (C) 1999, Adtran, Inc.
 * 
 * Distributed under the terms of the GNU GPL
 *
 */

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <pwd.h>
#include <sys/time.h>
#include <sys/socket.h>
#include "cheops.h"

/* Probing routines, may be useful for monitoring as well */

static int fd=-1;
static FILE *f=NULL;

struct probe {
	int port;
	char *name;
	char * (*report_version)(unsigned int ip_addr, unsigned short port);
	struct probe *next;
};

static struct probe *probes=NULL;

void register_probes()
{
#if 0
	struct probe *p;
	GList *l, *l2;
	l = list_plugin(TYPE_PROBE);
	l2 = l;
	while(l2) {
		p = g_new0(struct probe, 1);
		l2 = g_list_next(l2);
	}
	g_list_free(l);
#endif
}

static void close_connection()
{
	if (f) {
		fclose(f);
		f=NULL;
	}
	if (fd > -1) {
		close(fd);
		fd = -1;
	}
}

FILE *open_connection(unsigned int addr, unsigned short port)
{
	struct sockaddr_in sin;
	int res;
	sin.sin_addr.s_addr = addr;
	sin.sin_port = ntohs(port);
	sin.sin_family = AF_INET;
	close_connection();
	fd = socket(AF_INET, SOCK_STREAM, IPPROTO_IP);
	if (fd < 0) {
		perror("socket");
		return NULL;
	}
	res=connect(fd, (struct sockaddr *)&sin,  sizeof(sin));
	if (res < 0) {
		perror("connect");
		return NULL;
	}
	f = fdopen(fd, "r+");
	if (!f) {
		perror("fdopen");
	}
	return f;
	
}

static int wait_data(int timeout)
{
	struct timeval tv;
	fd_set fds;
	tv.tv_usec = 0;
	tv.tv_sec = timeout;
	FD_ZERO(&fds);
	if (fd > -1) {
		FD_SET(fd, &fds);
		return select(fd + 1, &fds, NULL, NULL, &tv);
	} else
		printf("fd is %d :( \n", fd);
	return -1;
}

static char *std_version(unsigned int ip_addr, unsigned short port) 
{
	FILE *f;
	static char buf[256];
	f = open_connection(ip_addr, port);
	if (!f)
		return "Inoperable";
	if (wait_data(10) < 0)
		return "No answer";
	if (!fgets(buf, sizeof(buf), f))
		return "No answer";
	close_connection();
	return buf;
}

static char *www_version(unsigned int ip_addr, unsigned short port)
{
	FILE *f;
	static char buf[256];
	f = open_connection(ip_addr, port);
	if (!f)
		return "Inoperable";
	fprintf(f, "GET / HTTP/1.0\n\n");
	fflush(f);
	while(!feof(f)) {
		if (wait_data(10) < 0)
			return "No answer";
		if (!fgets(buf, sizeof(buf), f))
			return "No answer";
		if (!strncasecmp(buf, "Server:", 7)) {
			close_connection();
			return buf + 8;
		}
	}
	close_connection();
	return NULL;
}

static char *strip_version(unsigned int addr, unsigned short port)
{
	char *c, *d;
	c = std_version(addr, port);
	if (c) {
		if (!strcasecmp(c, "No Answer") ||
		    !strcasecmp(c, "Inoperable"))
		    	return c;
		    
		d = strchr(c, ' ');
		if (d)
			return d + 1;
	}
	return c;
}

static char *strip2_version(unsigned int addr, unsigned short port)
{
	char *c, *d;
	c = std_version(addr, port);
	if (c) {
		if (!strcasecmp(c, "No Answer") ||
		    !strcasecmp(c, "Inoperable"))
		    	return c;
		d = strchr(c, ' ');
		if (d) {
			c = d;
			d = strchr(c, ' ');
			if (d)
				return d + 1;
		}
	}
	return c;
}

static struct probe probesa[] = {
	{ 21, "FTP", strip_version, NULL },
	{ 22, "SSH", std_version, NULL },
	{ 25, "E-mail", strip_version, NULL },
	{ 80, "Web", www_version, NULL },
	{ 110, "POP3",  strip2_version, NULL },
	{ 119, "News", strip_version, NULL },
	{ 143, "IMAP", strip2_version, NULL },
	{ 5900, "VNC(0)", std_version, NULL },
	{ 5901, "VNC(1)", std_version, NULL },
	{ 5902, "VNC(2)", std_version, NULL },
	{ 5903, "VNC(3)", std_version, NULL },
	{ 5904, "VNC(4)", std_version, NULL },
	{ 5905, "VNC(5)", std_version, NULL },
	{ 5906, "VNC(6)", std_version, NULL },
	{ 5907, "VNC(7)", std_version, NULL },
};

static int probe_cnt = sizeof(probesa) / sizeof(struct probe);

char *get_version(unsigned int addr, unsigned short port)
{
	int x;
	for (x=0;x<probe_cnt;x++) 
		if (probesa[x].port == port) 
			if (probesa[x].report_version)
				return probesa[x].report_version(addr, port);
	return NULL;
}

char *get_name(unsigned short port)
{
	int x;
	for (x=0;x<probe_cnt;x++) 
		if (probesa[x].port == port) 
			return probesa[x].name;
	return NULL;
}
