/*
   cipelib - library routines common to CIPE (user-mode part) and PKCIPE

   Copyright 2000 Olaf Titz <olaf@bigred.inka.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the License, or (at your option) any later version.
*/
/* $Id: hexstr.c,v 1.4 2000/12/13 01:38:56 olaf Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <sys/mman.h>
#include "cipelib.h"

extern const char cipelib_HEX[];
#define HEX cipelib_HEX
#ifndef NULL
#define NULL 0
#endif

#define CHUNK 128 /* power of two! */

char *hexstr(const void *d, int l)
{
    static char *buf=NULL;
    static int bufl=0;
    register const unsigned char *p=d;
    register int i, j;

    i=2*l+1;
    if (i>bufl) {
	bufl=(i+CHUNK)&(~(CHUNK-1));
	if (!(buf=realloc(buf, bufl))) {
            bufl=0;
            fprintf(stderr, "hexstr: malloc failure\n");
            return NULL;
        }
	/* This routine is used on secret keys, so lock the buffer */
	if (mlock(buf, bufl)<0)
	    cipe_syslog(LOG_ERR, "hexstr: mlock: %m"); /* not fatal */
    }
    for (i=j=0; i<l; ++p,++i) {
	buf[j++]=HEX[*p>>4];
	buf[j++]=HEX[*p&15];
    }
    buf[j]='\0';
    return buf;
}
