/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2003 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Teknobyen, Abels Gate 5, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

#ifndef COIN_TIDBITS_H
#define COIN_TIDBITS_H

#include <Inventor/C/basic.h>
#include <stdarg.h>

#ifdef __cplusplus
extern "C" {
#endif

/* ********************************************************************** */

int coin_snprintf(char * dst, unsigned int n, const char * fmtstr, ...);
int coin_vsnprintf(char * dst, unsigned int n, const char * fmtstr, va_list args);

const char * coin_getenv(const char *);

int coin_strncasecmp(const char *, const char *, int);

/* int coin_host_get_endianness(void); - internal, declared static */

uint16_t coin_hton_uint16(uint16_t value);
uint16_t coin_ntoh_uint16(uint16_t value);
uint32_t coin_hton_uint32(uint32_t value);
uint32_t coin_ntoh_uint32(uint32_t value);
float coin_hton_float(float value);
float coin_ntoh_float(float value);

SbBool coin_isascii(const int c);
SbBool coin_isspace(const char c);

SbBool coin_is_power_of_two(unsigned int x);

typedef void coin_atexit_f(void);
void coin_atexit(coin_atexit_f *);

/* ********************************************************************** */

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

/* ********************************************************************** */

#endif /* !COIN_TIDBITS_H */
