<?php
/* daCode http://www.dacode.org/
 * htdocs/dacode.php3
 * Fabien Penso <penso@linuxfr.org>
 * $Id: dacode.php3,v 1.47.2.17 2003/02/09 17:44:56 ruffy Exp $
 */

	/*
	 * This is to prevent someone else to require a remote file
	 */
	if (eregi("(http|ftp)",$topdir) || isset($HTTP_GET_VARS['topdir']) 
		|| isset($HTTP_POST_VARS['topdir']) 
		|| isset($HTTP_COOKIE_VARS['topdir'])) {
		exit;
	}

	// PHP guys love name changes
	if (!isset($_FILES) && isset($HTTP_POST_FILES)) {
		$_FILES = $HTTP_POST_FILES;
	}
	if (!isset($HTTP_SERVER_VARS)) {
		// looks likes a PHP3 server
		if (isset($HTTP_X_FORWARDED_FOR))
			$HTTP_SERVER_VARS['HTTP_X_FORWARDED_FOR'] = $HTTP_X_FORWARDED_FOR;
		if (isset($REMOTE_ADDR))
			$HTTP_SERVER_VARS['REMOTE_ADDR'] = $REMOTE_ADDR;
		if (isset($HTTP_X_HOST))
			$HTTP_SERVER_VARS['HTTP_X_HOST'] = $HTTP_X_HOST;
		if (isset($HTTP_HOST))
			$HTTP_SERVER_VARS['HTTP_HOST'] = $HTTP_HOST;
		if (isset($HTTP_REFERER)) {
			$HTTP_SERVER_VARS['HTTP_REFERER'] = $HTTP_REFERER;
		} else {
			$HTTP_SERVER_VARS['HTTP_REFERER'] = '';
		}
		if (isset($HTTP_ACCEPT_LANGUAGE))
			$HTTP_SERVER_VARS['HTTP_ACCEPT_LANGUAGE'] = $HTTP_ACCEPT_LANGUAGE;
		if (isset($HTTP_USER_AGENT))
			$HTTP_SERVER_VARS['HTTP_USER_AGENT'] = $HTTP_USER_AGENT;
		if (isset($PATH_INFO))
			$HTTP_SERVER_VARS['PATH_INFO'] = $PATH_INFO;
		if (isset($QUERY_STRING))
			$HTTP_SERVER_VARS['QUERY_STRING'] = $QUERY_STRING;
		if (isset($REQUEST_URI))
			$HTTP_SERVER_VARS['REQUEST_URI'] = $REQUEST_URI;
		if (isset($SCRIPT_URL))
			$HTTP_SERVER_VARS['SCRIPT_URL'] = $SCRIPT_URL;
	}

	if (empty($topdir)) {
		$topdir = './';
	} elseif ($topdir[strlen($topdir)-1] != '/') {
		$topdir .= '/';
	}
	$libdir = $topdir.'../phplib/';
	$php_ext = 'php3';

	// Ensure class files are loaded only once
	if (!defined("DACODE_PHP3")) {
		define("DACODE_PHP3", "1");
		include $libdir."config.".$php_ext;

		//   Load variables
		$config = new Config();
		$config->version = "1.4.1";

		include $libdir."session.".$config->php;
		include $libdir."cal.".$config->php;
		include $libdir."html.".$config->php;
		include $libdir."utils.".$config->php;
		include $libdir."db".$config->sql_backend.'.'.$config->php;
		include $libdir."cache.".$config->php;
		include $libdir."fortunes.".$config->php;
		include $libdir."hits.".$config->php;
		include $libdir."lang.".$config->php;
		include $libdir."nospider.".$config->php;
		include $libdir."users.".$config->php;
		include $libdir."sidebox.".$config->php;
		include $libdir."news.".$config->php;
		include $libdir."comments.".$config->php;
		include $libdir."board.".$config->php;
		include $libdir."messages.".$config->php;
		include $libdir."redirects.".$config->php;
		include $libdir."admin.".$config->php;
		include $libdir."poll.".$config->php;
		include $libdir."backends.".$config->php;
		include $libdir."search.".$config->php;
		include $libdir."webcam.".$config->php;
		include $libdir."tar.".$config->php;

		//Load xnts
		if (isset($config->extensions) &&
				gettype($config->extensions) == "array") {
			reset($config->extensions);
			while (list(, $path)  = each($config->extensions)) {
				include $libdir  . $path  . "include." . $config->php;
			}
		}

		include $libdir."libdacode.".$config->php;
		include $libdir."tips.".$config->php;
		include $libdir."ldap.".$config->php;
		include $libdir."submitComments.".$config->php;

		//   Disable magic quotes for SQL queries
		set_magic_quotes_runtime(0);

		//  1) Unescape POST variables when magic_quotes_gpc are
		//     set to On. GET vars are used in search engine.
		//     There is no need to check COOKIE vars.
		//  2) Some browsers add \r and \n to POST variables
		$post_vars = array ();
		if (is_array($HTTP_POST_VARS)) {
			reset($HTTP_POST_VARS);
			while(list($key, $val) = each($HTTP_POST_VARS)) {
				$key = trim($key);
				if (is_array($val)) {
					while(list($k2, $v2) = each($val)) {
						$v2 = trim($v2);
						if (get_magic_quotes_gpc())
							$v2 = stripslashes($v2);
						$val[$k2] = $v2;
					}
				} else {
					$val = trim($val);
					if (get_magic_quotes_gpc())
						$val = stripslashes($val);
				}
				$post_vars[$key] = $val;
			}
		}
		$HTTP_POST_VARS = $post_vars;

		//  Some scripts also need this variable
		$post_vars = array ();
		if (isset($table) && is_array($table)) {
			reset($table);
			while(list($key, $val) = each($table)) {
				$key = trim($key);
				$val = trim($val);
				if (get_magic_quotes_gpc())
					$val = stripslashes($val);
				$post_vars[$key] = $val;
			}
		}
		$table = $post_vars;

		//  GET
		$get_vars = array ();
		if (is_array($HTTP_GET_VARS)) {
			reset($HTTP_GET_VARS);
			while(list($key, $val) = each($HTTP_GET_VARS)) {
				$key = trim($key);
				$val = trim($val);
				if (get_magic_quotes_gpc())
					$val = stripslashes($val);
				$get_vars[$key] = $val;
			}
		}
		$HTTP_GET_VARS = $get_vars;

		//  Compute relative path of the base directory
		$tmp_url = isset($HTTP_SERVER_VARS['REQUEST_URI'])?
			$HTTP_SERVER_VARS['REQUEST_URI']:'';
		if (preg_match('/^http:\/\/?[^\/]+\/(.+)$/i',
				$config->baseurl,$tmp_array)) {
			$config->baselink = $tmp_array[1];
			$tmp_url = ereg_replace('^/'.$config->baselink,'/',$tmp_url);
		}
		$tmp = preg_replace('/^\//','',$tmp_url);
		if (preg_match('/\?$/', $config->newsfile)) {
			$tmp = preg_replace('/'.$config->newsfile.'.*$/i','',$tmp);
		} 
		$tmp = preg_replace('/[^\/]*/i','',$tmp);
		$config->depth = strlen($tmp);
		$tmp = str_replace("/","../",$tmp);
		if ($tmp == "") {
			$tmp = "./";
		}
		$config->basehref = $tmp;
	}
?>
