
/* darkstat: a network traffic analyzer
 * (c) 2001-2003, Emil Mikulic.
 */

#ifndef __PORT_DB_H
#define __PORT_DB_H

#include "db.h"
#include "bignum.h"
#include <stdio.h>

typedef struct
{
	word port;
	int64 data_in, data_out;
} port_record;

typedef struct
{
	char *name;
	word number;
} service;



/* Global database */
extern db port_db;
extern service *services;



const char *service_name(word port);

void port_db_init(void);
void port_db_free(void);

/* needs to be deallocated when it's no longer needed */
inline port_record *port_make(const word port);

inline void port_update_in(port_record *p, const dword in);
inline void port_update_out(port_record *p, const dword out);

inline port_record *port_find(const word port);
inline port_record *port_from_num(const word port);

inline port_record **port_db_sort(sort_type st);

void port_db_save(FILE *fp);
int port_db_load(FILE *fp);

#endif

