/*
  DB Audiolib
  ===========

  DB Audiolib is a series of routines to simplify access to the DBMix 
  Fourier Synthesis Daemon (dbfsd)

  This software is brought to you by the letter C and the number 1.

  This library is intended to be as simple to use as possible. If a 
  function here is similar to a known system function, then the 
  local function (i.e. DBAudio_Write()) is designed to be similar
  in operation to the system function (i.e. write()).

  Version: C.2
  Author:  Bob Dean
  Copyright (c) 1999, 2000


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#ifdef __cplusplus
extern "C"
{
#endif

#include <dbsoundcard.h>
#include <dbchannel.h>
#include <dbdebug.h>
#include <dbaudiolib.h>

#include "prototypes.h"

extern int errno;
extern int debug_level; /* declared in debug module */


DBAudioLibFunctions dbaudio_fxns =
{
	DBAudio_Init,
	DBAudio_Ready,
	DBAudio_Write,
	DBAudio_Read,
	DBAudio_Close,
	DBAudio_Set_Volume,
	DBAudio_Get_Volume,
	DBAudio_Pause,
	DBAudio_Get_Version,
	DBAudio_Get_Channel_Name,
	DBAudio_Set_Channel_Name,
	DBAudio_Get_Channel_Type,
	DBAudio_Set_Channel_Type,
	DBAudio_Cue_Enabled,
	DBAudio_Set_Rate,
	DBAudio_Get_Rate,
	DBAudio_Set_Channels,
	DBAudio_Get_Channels,
	DBAudio_Set_Format,
	DBAudio_Get_Format,
	DBAudio_Set_Cue,
	DBAudio_Get_Cue,
	DBAudio_Get_Bufsize,
	DBAudio_perror,
	DBAudio_Set_Message_Handler,
	DBAudio_Handle_Message_Queue,
	DBAudio_Set_Channel_Flag,
	DBAudio_Clear_Channel_Flag,
	DBAudio_Get_Channel_Flags
};


DBAudioLibFunctions * DBAudio_Get_Functions()
{
	return &dbaudio_fxns;
}


#ifdef __cplusplus
}
#endif
