/*
  fsadders.h

  structure and function definitions for the fourier synthesis adders

  Author: Robert Michael S Dean
  Copyright (c) 1999

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#ifndef __FSADDERS_H_
#define __FSADDERS_H_

signed short *  fs_add2channels(signed short * output, channel_buf * input1, 
			       channel_buf * input2);

signed short * fs_add3channels(signed short * output, channel_buf * input1, 
		    channel_buf * input2, channel_buf* input3);

signed short * fs_add4channels(signed short *output, channel_buf *input1, 
			       channel_buf *input2, channel_buf *input3, 
			       channel_buf *input4);

signed short * fs_add5channels(signed short *output, channel_buf *input1, 
			       channel_buf *input2, channel_buf *input3, 
			       channel_buf *input4, channel_buf *input5);

signed short * fs_add6channels(signed short *output, channel_buf *input1, 
			       channel_buf *input2, channel_buf *input3, 
			       channel_buf *input4, channel_buf *input5,
			       channel_buf *input6);

signed short * fs_add7channels(signed short *output, channel_buf *input1, 
			       channel_buf *input2, channel_buf *input3, 
			       channel_buf *input4, channel_buf *input5,
			       channel_buf *input6, channel_buf *input7);

signed short * fs_add8channels(signed short *output, channel_buf *input1, 
			       channel_buf *input2, channel_buf *input3, 
			       channel_buf *input4, channel_buf *input5,
			       channel_buf *input6, channel_buf *input7,
			       channel_buf *input8);

signed short * fs_addNchannels(signed short* output, channel_buf ** 
			       in_channels, int num_channels);

#endif /* __FSADDERS_H_ */




