/*****************************************************************************
DBTCP
(C) 2000 Giussani Cristian
Released under GPL v2
*****************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>

#include <define.h>
#include <protocol.h>

char *linea=NULL;

int main ( int argc, char *argv[] )
{
  dbftp_result *results;
  char *host="tazio";
  char *dsn="DSN=dbanticipi";
  char *query="SELECT * FROM tAnticipi";
  int port=3000;


  results=init_dbftp_result();
  
  if ( results != NULL )
    {
      /* ----------------------------------------------------------- Connect */
      if ( dbftp_connect ( results, host, port, dsn ) == OK )
	{
	  printf ( "Connected to %s:%s\n", host, dsn );
	  
	  /* -------------------------------------------------- Send a query */
          if ( dbftp_sql ( results, query ) == OK )
            {
              int idmy,rec_num=0;

              for ( idmy=0; idmy<dbftp_num_field(results); idmy++ )
                {
		  printf ( "Field %d: '%s' (length %d - type %c)\n",idmy , dbftp_field_name(results,idmy)
                           , dbftp_field_len(results,idmy)
                           , dbftp_field_type(results,idmy) );
		}

	      /* --------------------------------------------- Fetch results */
	      while ( dbftp_fetch_row ( results ) == OK )
		{
		  char *cptrdmy;

		  /* ---------------------------------- Fetch a single value */
		  for ( idmy=0; idmy < dbftp_num_field(results); idmy++ )
                    {
                      cptrdmy=dbftp_fetch_value ( results, idmy );
                      if ( cptrdmy != NULL )
                        {
			  printf ( "%s", dbftp_fetch_value( results, idmy ));
			}
                      else
                        {
                          printf ( "NULL" );
                        }

		      /* is the last field ? */
                      if ( idmy == ( dbftp_num_field(results)-1 ) )
			printf( "\n" );
		      else
			printf( "," );
                    }
		}
	      
	    }
	}
      else
	{
	  fprintf ( stderr, "CONNECT ERROR: %s\n", dbftp_error_string ( results ) );
	}
      
    }
  else
    {
      printf ( "Unable to initializa dbtcp protocol\n" );
    }
  exit ( 1 );
}
