/*****************************************************************************
Modulo string.c 
(C) 1998 Giussani Cristian Fastflow Srl
Routine di manipolazione di stringhe con allocazione dinamica della
lunghezza.
Routine esportate:
*****************************************************************************/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <my_string.h>
#include <define.h>

/* 
   Attenzione non controlla che la stringa sia gia' allocata 
 */
int string_init ( MY_STRING *stringa, ulong len_inizio, ulong incremento, char *valore )
{
  ulong lunghezza,inizio;

  if (incremento == 0)
    stringa->increment = 128;
  else
    stringa->increment = incremento;

  if (valore != NULL)
    lunghezza = strlen (valore) + 1;
  else
    lunghezza = 1;

  if (len_inizio < (lunghezza + stringa->increment))
    inizio = lunghezza + stringa->increment;
  else
    inizio = len_inizio;

  if (((stringa->string) = malloc (inizio)) == NULL)
    return (ERR);

  stringa->length = lunghezza - 1;
  stringa->max_length = inizio;

  if (valore != NULL)
    strcpy (stringa->string, valore);
  else
    stringa->string[0] = CHR_NULL;
  
  return (OK);
}

/******************************************************************************

 *****************************************************************************/
int string_append ( MY_STRING *stringa, char *altra, ulong length )
{
  ulong lunghezza;
  char *newptr;

  if (length == 0)
    lunghezza = strlen (altra) + 1;
  else
    lunghezza = length + 1;
  
  if (stringa->max_length <= (stringa->length) + lunghezza)
    {
      newptr = (char *) malloc (stringa->max_length + lunghezza + stringa->increment);
      /*if ( realloc (stringa->string, stringa->max_length+lunghezza+stringa->increment ) == NULL ) */
      if (newptr == NULL)
	{
	  /* Il blocco di memoria non e' stato toccato */
	  printf ("Errore allocazione di memoria\n");
	  return (ERR);
	}
      memcpy (newptr, stringa->string, stringa->length);
      free (stringa->string);
      stringa->string = newptr;
      stringa->max_length += lunghezza + stringa->increment;

    }
  
  memcpy (&(stringa->string[stringa->length]), altra, lunghezza);
  stringa->length += lunghezza - 1;
  stringa->string[stringa->length] = CHR_NULL;
  
  return (OK);
}

/******************************************************************************

 *****************************************************************************/
int 
string_free ( MY_STRING *stringa )
{
  if (stringa->max_length != 0)
    {
      free (stringa->string);
      stringa->string = NULL;
      stringa->length = 0;
      stringa->max_length = 0;
    }

  return (OK);
}

/******************************************************************************
int string_replace ( MY_STRING *string, char *find, char *replace )
Cerca la stringa 'find' e la sostituisce con 'replace' nella stringa dinamica 'string'.
Valori restituiti:
                   0 - Nessuna sostituzione
                  >0 - Numero delle sostituzioni effettuate
 *****************************************************************************/
int string_replace ( MY_STRING *string, char *find, char *replace )
{
  MY_STRING new;
  char *source, *pnt;
  ulong len_find,len_replace,idx;

  if ( ( string->string != NULL ) &&
       ( find != NULL ) &&
       ( replace != NULL ) )
    {
      string_init ( &new, string_length(string), 256, string->string );
      string_clear ( &new );

      len_find=strlen(find);
      len_replace=strlen(replace);
      idx=0;
      source=string->string;
      while ( (pnt=strstr( source, find )) != NULL )
        {
	  /* Copia la parte prima della stringa e attacca la sostituzione */
	  string_append ( &new, source, (pnt-source) );
	  string_append ( &new, replace, len_replace );
          source = pnt+len_find;
	  idx++;
        }

      if ( idx != 0 )
	{
	  /* Ho fatto delle sostituzioni */
	  string_append ( &new, source, 0 );
	  string_free ( string );
	  memcpy ( string, &new, sizeof ( MY_STRING ) );
	  return ( idx );
	}
      else
	{
	  /* Non ho fatto delle sostituzione */
	  string_free ( &new );
	}

    }
  
  return ( 0 );
}

#ifdef TEST
int main ( int args, char *argv[] )
{
  MY_STRING stringa;
  int ret,idmy;

  string_init ( &stringa, 256, 256, "Ciao sono $NOME e sono una stringa dinamica" );

  ret=0;
  for ( idmy=0; idmy<100; idmy++ )
    ret+=string_replace ( &stringa, "$NOME", "(UN_BEL_NOME_LUNGO_PER_VEDERE_SE_SFORA {$NOME} )" );
  printf ( "%d='%s'", ret, stringa.string );
  
  return ( 0 );

}
#endif
