<?php
/*
 * $Id: class.boWorkorders.inc.php,v 1.8.2.3.2.20 2003/12/10 05:54:06 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('bo');
LoadStringResource('wo');

class boWorkorders
{
	function newjcn()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.htmlWorkOrderForm');
		$obj->Show();
	}

	function newseq()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		if (!IsSet($GLOBALS['jcn']))
			$GLOBALS['jcn'] = 0;

		$obj = CreateObject('dcl.htmlWorkOrderForm');
		$obj->Show($GLOBALS['jcn']);
	}

	function modifyjcn()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_MOD_WO']))
			return PrintPermissionDenied();

		$objWO = CreateObject('dcl.dbWorkorders');
		$objWO->Connect();
		$objWO->Load($GLOBALS['jcn'], $GLOBALS['seq']);

		$obj = CreateObject('dcl.htmlWorkOrderForm');
		$obj->Show($GLOBALS['jcn'], $objWO);
	}

	function dbnewjcn()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$objWorkorder = CreateObject('dcl.dbWorkorders');
		$objWorkorder->Connect();

		// If we're creating a seq, be sure the jcn exists
		if (IsSet($GLOBALS['jcn']) && $GLOBALS['jcn'] > 0)
		{
			$objWorkorder->Query('SELECT jcn FROM workorders where jcn=' . $GLOBALS['jcn']);
			if (!$objWorkorder->next_record())
			{
				echo '<center>';
				PrintWithChocoFont(sprintf(STR_BO_NOJCNFORSEQWARNING, $GLOBALS['jcn']));
				echo '</center>';
				$GLOBALS['jcn'] = 0;
			}
		}
		$objWorkorder->InitFromGlobals();
		$objWorkorder->createby = $GLOBALS['DCLID'];
		$objWorkorder->Add();

		// multiple accounts?
		if ($dcl_info['DCL_WO_SECONDARY_ACCOUNTS_ENABLED'] == 'Y')
		{
			if (IsSet($GLOBALS['secaccounts']) && $GLOBALS['secaccounts'] != '')
			{
				$aAccounts = explode(',', $GLOBALS['secaccounts']);
				if (count($aAccounts) > 0)
				{
					$oWOA = CreateObject('dcl.dbWorkOrderAccount');
					$oWOA->Connect();
					$oWOA->wo_id = $objWorkorder->jcn;
					$oWOA->seq = $objWorkorder->seq;

					for ($i = 0; $i < count($aAccounts); $i++)
					{
						if ($aAccounts[$i] > 0)
						{
							$oWOA->account_id = $aAccounts[$i];
							$oWOA->Add();
						}
					}
				}
			}
		}
		else if (IsSet($GLOBALS['account']) && $GLOBALS['account'] > 0)
		{
			$oWOA = CreateObject('dcl.dbWorkOrderAccount');
			$oWOA->Connect();
			$oWOA->wo_id = $objWorkorder->jcn;
			$oWOA->seq = $objWorkorder->seq;
			$oWOA->account_id = $GLOBALS['account'];
			$oWOA->Add();
		}

		// add to a project?
		if (IsSet($GLOBALS['projectid']) && $GLOBALS['projectid'] > 0 && $GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'])
		{
			$objPM = CreateObject('dcl.dbProjectmap');
			$objPM->Connect();

			if (IsSet($GLOBALS['addall']) && $GLOBALS['addall'] == '1')
				$objPM->Execute('DELETE FROM projectmap WHERE jcn=' . $objWorkorder->jcn);

			$objPM->projectid = $GLOBALS['projectid'];
			$objPM->jcn = $objWorkorder->jcn;
			$objPM->seq = $objWorkorder->seq;
			if (IsSet($GLOBALS['addall']) && $GLOBALS['addall'] == '1')
				$objPM->seq = 0;

			$objPM->Add();
		}

		// upload a file attachment?
		if (IsSet($GLOBALS['userfile']) && $GLOBALS['userfile'] != 'none')
		{
			if (!((IsSet($HTTP_POST_VARS['userfile']) && $HTTP_POST_VARS['userfile'] == $GLOBALS['userfile']) ||
				(IsSet($HTTP_GET_VARS['userfile']) && $HTTP_GET_VARS['userfile'] == $GLOBALS['userfile']) ||
				(IsSet($HTTP_COOKIE_VARS['userfile']) && $HTTP_COOKIE_VARS['userfile'] == $GLOBALS['userfile'])))
			{
				$o = CreateObject('dcl.boFile');
				$o->iType = ATTACHMENT_WORKORDER;
				$o->iKey1 = $objWorkorder->jcn;
				$o->iKey2 = $objWorkorder->seq;
				$o->sFileName = is_array($GLOBALS['userfile']) ? $GLOBALS['userfile']['name'] : $GLOBALS['userfile_name'];
				$o->sTempFileName = is_array($GLOBALS['userfile']) ? $GLOBALS['userfile']['tmp_name'] : $GLOBALS['userfile'];
				$o->sRoot = $dcl_info['DCL_FILE_PATH'] . '/attachments';
				$o->Upload();
			}
		}

		// copied from ticket?
		if (IsSet($GLOBALS['ticketid']) && $GLOBALS['ticketid'] > 0)
		{
			$oTR = CreateObject('dcl.dbTicketresolutions');
			$oTR->Connect();
			$oTR->ticketid = $GLOBALS['ticketid'];
			$oTR->loggedby = $GLOBALS['DCLID'];
			$oTR->loggedon = date($dcl_info['DCL_TIMESTAMP_FORMAT']);
			$oTR->startedon = date($dcl_info['DCL_TIMESTAMP_FORMAT']);
			$oTR->resolution = sprintf('Copied to dcl://workorders/%d-%d', $objWorkorder->jcn, $objWorkorder->seq);

			$oTck = CreateObject('dcl.dbTickets');
			$oTck->Connect($oTR->conn);
			$oTck->Load($oTR->ticketid);
			$oTck->lastactionon = date($dcl_info['DCL_TIMESTAMP_FORMAT']);
			$oTR->status = $oTck->status;

			$oTR->BeginTransaction();
			$oTR->Add();
			$oTck->Edit();
			$oTR->EndTransaction();
		}

		$objWtch = CreateObject('dcl.boWatches');
		$objWtch->sendNotification($objWorkorder, '4,1');

		if (EvaluateReturnTo())
			return;

		$objWO = CreateObject('dcl.htmlWorkOrderDetail');
		$objWO->Show($objWorkorder->jcn, $objWorkorder->seq);
	}

	function dbmodifyjcn()
	{
		global $dcl_info;
		
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_MOD_WO']))
			return PrintPermissionDenied();

		$objWorkorder = CreateObject('dcl.dbWorkorders');
		$objWorkorder->Connect();
		$objWorkorder->Load($GLOBALS['jcn'], $GLOBALS['seq']);

		$objWorkorder->product = $GLOBALS['product'];
		$objWorkorder->module_id = $GLOBALS['module_id'];
		$objWorkorder->wo_type_id = $GLOBALS['wo_type_id'];
		$objWorkorder->deadlineon = $GLOBALS['deadlineon'];
		$objWorkorder->eststarton = $GLOBALS['eststarton'];

		$objWorkorder->estendon = $GLOBALS['estendon'];
		$objWorkorder->esthours = $GLOBALS['esthours'];
		$objWorkorder->priority = $GLOBALS['priority'];
		$objWorkorder->severity = $GLOBALS['severity'];

		$objWorkorder->contact = $objWorkorder->GPCStripSlashes($GLOBALS['contact']);
		$objWorkorder->contactphone = $GLOBALS['contactphone'];
		$objWorkorder->summary = $objWorkorder->GPCStripSlashes($GLOBALS['summary']);
		$objWorkorder->notes = $objWorkorder->GPCStripSlashes($GLOBALS['notes']);

		$objWorkorder->description = $objWorkorder->GPCStripSlashes($GLOBALS['description']);
		$objWorkorder->responsible = $GLOBALS['responsible'];
		$objWorkorder->revision = $objWorkorder->GPCStripSlashes($GLOBALS['revision']);

		$objWorkorder->Edit();

		// secondary accounts?
		if ($dcl_info['DCL_WO_SECONDARY_ACCOUNTS_ENABLED'] == 'Y' && IsSet($GLOBALS['secaccounts']))
		{
			// Delete existing references
			$oWOA = CreateObject('dcl.dbWorkOrderAccount');
			$oWOA->Connect();
			$oWOA->DeleteByWorkOrder($objWorkorder->jcn, $objWorkorder->seq);

			// Add the new ones - TODO: load accounts and apply diff instead of blindly wiping and re-adding everything
			$aAccounts = explode(',', $GLOBALS['secaccounts']);
			if (count($aAccounts) > 0)
			{
				$oWOA->wo_id = $objWorkorder->jcn;
				$oWOA->seq = $objWorkorder->seq;

				for ($i = 0; $i < count($aAccounts); $i++)
				{
					if ($aAccounts[$i] > 0)
					{
						$oWOA->account_id = $aAccounts[$i];
						$oWOA->Add();
					}
				}
			}
		}
		else if (IsSet($GLOBALS['account']))
		{
			$oWOA = CreateObject('dcl.dbWorkOrderAccount');
			$oWOA->Connect();
			$oWOA->DeleteByWorkOrder($objWorkorder->jcn, $objWorkorder->seq);

			if ($GLOBALS['account'] > 0)
			{
				$oWOA->wo_id = $objWorkorder->jcn;
				$oWOA->seq = $objWorkorder->seq;
				$oWOA->account_id = $GLOBALS['account'];
				$oWOA->Add();
			}
		}

		$objWtch = CreateObject('dcl.boWatches');
		$objWtch->sendNotification($objWorkorder, '4');

		if (EvaluateReturnTo())
			return;

		$objWO = CreateObject('dcl.htmlWorkOrderDetail');
		$objWO->Show($objWorkorder->jcn, $objWorkorder->seq);
	}

	function delete()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_DEL_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.htmlWorkOrderDetail');
		$obj->Show($GLOBALS['jcn'], $GLOBALS['seq'], 0, true);
	}

	function dbdelete()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_DEL_WO']))
			return PrintPermissionDenied();

		// Remove from projects
		$objPM = CreateObject('dcl.boProjects');
		$objPM->dbunmap($GLOBALS['jcn'], $GLOBALS['seq'], true);
		
		// Remove secondary accounts
		if ($dcl_info['DCL_WO_SECONDARY_ACCOUNTS_ENABLED'] == 'Y')
		{
			$oWOA = CreateObject('dcl.dbWorkOrderAccount');
			$oWOA->Connect();
			$oWOA->DeleteByWorkOrder($GLOBALS['jcn'], $GLOBALS['seq']);
		}

		// Remove the work order entry - also does time cards
		$obj = CreateObject('dcl.dbWorkorders');
		$obj->Connect();
		$obj->jcn = $GLOBALS['jcn'];
		$obj->seq = $GLOBALS['seq'];

		$obj->Delete();

		// Remove account references
		$oWOA = CreateObject('dcl.dbWorkOrderAccount');
		$oWOA->Connect();
		$oWOA->DeleteByWorkOrder($objWorkorder->jcn, $objWorkorder->seq);

		// Remove all attachments
		$attachPath = $dcl_info['DCL_FILE_PATH'] . '/attachments/wo/' . substr($GLOBALS['jcn'], -1) . '/' . $GLOBALS['jcn'] . '/' . $GLOBALS['seq'] . '/';
		if ($hDir = @opendir($attachPath))
		{
			while ($fileName = @readdir($hDir))
			{
				if (is_file($attachPath . $fileName) && is_readable($attachPath . $fileName))
					unlink($attachPath . $fileName);
			}

			@closedir($hDir);
		}

		print('<center>');
		PrintWithChocoFont(sprintf(STR_BO_WORKORDERDELETED, $GLOBALS['jcn'], $GLOBALS['seq']));
		print('</center>');

		$objMy = CreateObject('dcl.htmlMyDCL');
		$objMy->showMy();
	}

	function viewjcn()
	{
		commonHeader();
		if ($GLOBALS['jcn'] == '')
		{
			print(STR_WO_NEEDJCNERR);
			return;
		}

		if ($GLOBALS['seq'] != '')
		{
			$obj = CreateObject('dcl.htmlWorkOrderDetail');
			$obj->Show($GLOBALS['jcn'], $GLOBALS['seq']);
			return;
		}

		$objView = CreateObject('dcl.boView');
		$objView->style = 'report';
		$objView->title = STR_WO_RESULTSTITLE;

		$objView->AddDef('filter', 'jcn', $GLOBALS['jcn']);
		if (IsSet($GLOBALS['seq']) && $GLOBALS['seq'] != '')
			$objView->AddDef('filter', 'seq', $GLOBALS['seq']);

		$objView->AddDef('columns', '',
			array('jcn', 'seq', 'responsible.short', 'products.name', 'statuses.name', 'eststarton', 'deadlineon',
				'etchours', 'totalhours', 'summary'));

		$objView->AddDef('order', '', array('jcn', 'seq'));

		$objView->AddDef('columnhdrs', '',
			array(STR_WO_JCN, STR_WO_SEQ, STR_WO_RESPONSIBLE, STR_WO_PRODUCT,
				STR_WO_STATUS, STR_WO_ESTSTART, STR_WO_DEADLINE, STR_WO_ETCHOURS, STR_WO_ACTHOURS, STR_WO_SUMMARY));

		$objHV = CreateObject('dcl.htmlWorkOrderResults');
		$objHV->Render($objView);
	}

	function dbsearch()
	{
		global $responsible, $createby, $closedby, $personnel, $product, $project, $module_id, $wo_type_id, $department;
		global $severity, $priority, $status, $dcl_status_type, $account;
		global $createdon, $closedon, $statuson, $lastactionon, $deadlineon;
		global $eststarton, $estendon, $starton, $dateFrom, $dateTo;
		global $summary, $notes, $description, $searchText;
		global $columns, $groups, $order, $columnhdrs;

		commonHeader();

		$objView = CreateObject('dcl.boView');
		$objView->table = 'workorders';

		if (strlen($columnhdrs) > 0)
			$columnhdrs = explode(',', $columnhdrs);
		else
			$columnhdrs = array();

		if (strlen($columns) > 0)
			$columns = explode(',', $columns);
		else
			$columns = array();

		if (strlen($groups) > 0)
			$groups = explode(',', $groups);
		else
			$groups = array();

		if (strlen($order) > 0)
			$order = explode(',', $order);
		else
			$order = array();

		if (count($personnel) > 0 || count($department) > 0)
		{
			$fieldList = array('responsible', 'createby', 'closedby');
			$bStrippedDepartments = false;
			$pers_sel = array();
			while (list($key, $field) = each($fieldList))
			{
				if ($$field == '1')
				{
					if (count($personnel) > 0)
					{
						if (!$bStrippedDepartments)
						{
							$bStrippedDepartments = true;

							// Have actual personnel?  If so, only set personnel for their associated departments instead of the department
							// then unset the department from the array
							reset($personnel);
							while (list(, $encoded_pers) = each($personnel))
							{
								list($dpt_id, $pers_id) = explode(',', $encoded_pers);
								$pers_sel[count($pers_sel)] = $pers_id;
								if (count($department) > 0 && in_array($dpt_id, $department))
								{
									reset($department);
									while(list($key, $department_id) = each($department))
									{
										if ($department_id == $dpt_id)
										{
											unset($department[$key]);
											break;
										}
									}
								}
							}
						}

						$objView->AddDef('filter', $field, $pers_sel);
					}

					if (count($department) > 0)
						$objView->AddDef('filter', $field . '.department', $department);
				}
			}
		}

		$fieldList = array('priority', 'severity', 'wo_type_id');
		while (list($key, $field) = each($fieldList))
		{
			if (count($$field) > 0)
				$objView->AddDef('filter', $field, $$field);
		}

		if (count($module_id) > 0)
		{
			// Have modules?  If so, only set module IDs for their associated products instead of the product ID
			// then unset the product id from the array
			reset($module_id);
			$module = array();
			while (list(, $encoded_mod) = each($module_id))
			{
				list($mod_prod_id, $mod_id) = explode(',', $encoded_mod);
				$module[count($module)] = $mod_id;
				if (count($product) > 0 && in_array($mod_prod_id, $product))
				{
					reset($product);
					while(list($key, $product_id) = each($product))
					{
						if ($product_id == $mod_prod_id)
						{
							unset($product[$key]);
							break;
						}
					}
				}
			}

			$objView->AddDef('filter', 'module_id', $module);
		}

		if (count($product) > 0)
			$objView->AddDef('filter', 'product', $product);

		if (count($status) > 0)
		{
			// Have statuses?  If so, only set status IDs for their associated types instead of the status type ID
			// then unset the status type id from the array
			reset($status);
			$statuses = array();
			while (list(, $encoded_status) = each($status))
			{
				list($type_id, $status_id) = explode(',', $encoded_status);
				$statuses[count($statuses)] = $status_id;
				if (count($dcl_status_type) > 0 && in_array($type_id, $dcl_status_type))
				{
					reset($dcl_status_type);
					while(list($key, $status_type_id) = each($dcl_status_type))
					{
						if ($status_type_id == $type_id)
						{
							unset($dcl_status_type[$key]);
							break;
						}
					}
				}
			}

			$objView->AddDef('filter', 'status', $statuses);
		}

		if (count($account) > 0)
			$objView->AddDef('filter', 'dcl_wo_account.account_id', $account);

		if (count($dcl_status_type) > 0)
			$objView->AddDef('filter', 'statuses.dcl_status_type', $dcl_status_type);

		if (count($project) > 0)
			$objView->AddDef('filter', 'dcl_projects.projectid', $project);

		if ($dateFrom != '' || $dateTo != '')
		{
			$fieldList = array('createdon', 'closedon', 'statuson', 'lastactionon', 'deadlineon',
					'eststarton', 'estendon', 'starton');

			while (list($key, $field) = each($fieldList))
			{
				if ($$field == '1')
					$objView->AddDef('filterdate', $field, array($dateFrom, $dateTo));
			}
		}

		if ($searchText != '')
		{
			$fieldList = array('summary', 'notes', 'description');
			while (list($key, $field) = each($fieldList))
			{
				if ($$field == '1')
					$objView->AddDef('filterlike', $field, $searchText);
			}
		}

		if (count($columns) > 0)
			$objView->AddDef('columns', '', $columns);

		if (count($groups) > 0)
		{
			reset($groups);
			while (list($key, $groupField) = each($groups))
			{
				if ($groupField == 'priorities.name')
					$groups[$key] = 'priorities.weight';
				else if ($groupField == 'severities.name')
					$groups[$key] = 'severities.weight';
			}

			$objView->AddDef('groups', '', $groups);
		}

		if (count($columnhdrs) > 0)
			$objView->AddDef('columnhdrs', '', $columnhdrs);

		if (count($order) > 0)
		{
			reset($order);
			while (list($key, $orderField) = each($order))
			{
				if ($orderField == 'priorities.name')
					$order[$key] = 'priorities.weight';
				else if ($orderField == 'severities.name')
					$order[$key] = 'severities.weight';
			}

			$objView->AddDef('order', '', $order);
		}
		else
			$objView->AddDef('order', '', array('jcn', 'seq'));

		$objView->style = 'report';

		if ($GLOBALS['title'] != '')
		{
			$o = CreateObject('dcl.dbPersonnel');
			$objView->title = $o->GPCStripSlashes($GLOBALS['title']);
		}
		else
			$objView->title = STR_WO_RESULTSTITLE;
		
		$obj = CreateObject('dcl.htmlWorkOrderResults');
		$obj->Render($objView);
	}

	function graph()
	{
		commonHeader();

		// GD is required, so short-circuit if not installed
		if (!extension_loaded('gd'))
		{
			print('<center>');
			PrintWithChocoFont(STR_BO_GRAPHNEEDSGD);
			print('</center>');
			return;
		}

		$obj = CreateObject('dcl.htmlWorkorders');
		$obj->DisplayGraphForm();
	}

	function showgraph()
	{
		commonHeader();

		// GD is required, so short-circuit if not installed
		if (!extension_loaded('gd'))
		{
			print('<center>');
			PrintWithChocoFont(STR_BO_GRAPHNEEDSGD);
			print('</center>');
			return;
		}

		$objG = CreateObject('dcl.boGraph');
		$obj = CreateObject('dcl.dbWorkorders');
		$obj->Connect();
		$beginDate = new DCLTimestamp;
		$endDate = new DCLTimestamp;
		$testDate = new DCLDate;
		$testTS = new DCLTimestamp;

		$endDate->SetFromDisplay($GLOBALS['dateFrom'] . ' 23:59:59');
		$beginDate->SetFromDisplay($GLOBALS['dateFrom'] . ' 00:00:00');
		$beginDate->time -= (($GLOBALS["days"] - 1) * 86400);
		$query = 'SELECT createdon,closedon FROM workorders WHERE ';
		if ($GLOBALS['product'] > 0)
			$query .= 'product = ' . $GLOBALS['product'] . 'AND ';

		$query .= '(createdon between ' . $obj->DisplayToSQL($beginDate->ToDisplay());
		$query .= ' AND ' . $obj->DisplayToSQL($endDate->ToDisplay());
		$query .= ') OR (closedon between ' . $obj->DisplayToSQL($beginDate->ToDisplay());
		$query .= ' AND ' . $obj->DisplayToSQL($endDate->ToDisplay()) . ')';
		$obj->Query($query);

		$objG->data[0] = array(); // Open
		$objG->data[1] = array(); // Closed

		$daysBack = array();
		$testDate->time = $beginDate->time;
		for ($i = 0; $i < $GLOBALS['days']; $i++)
		{
			$daysBack[$i] = $testDate->time;
			// Set the relevant object properties while we're at it
			$objG->line_captions_x[$i] = date('m/d', $testDate->time);
			$objG->data[0][$i] = 0;
			$objG->data[1][$i] = 0;

			$testDate->time += 86400;
		}

		while ($obj->next_record())
		{
			$iTime = 0;
			for ($y = 0; $y < 2; $y++)
			{
				if ($y == 0)
				{
					$testTS->SetFromDB($obj->f($y));
					$iTime = $testTS->time;
				}
				else
				{
					$testDate->SetFromDB($obj->f($y));
					$iTime = $testDate->time;
				}

				$j = $GLOBALS['days'] - 1;
				while ($j >= 0)
				{
					if ($iTime >= $daysBack[$j])
					{
						if (!IsSet($objG->data[$y][$j]))
							$objG->data[$y][$j] = 0;
						$objG->data[$y][$j]++;
						break;
					}

					$j--;
				}
			}
		}

		$objG->title = STR_BO_WOGRAPHTITLE;
		if (isset($GLOBALS['product']) && $GLOBALS['product'] > 0)
		{
			$oDB = CreateObject('dcl.dbProducts');
			$oDB->Connect();
			if ($oDB->Load($GLOBALS['product']) != -1)
				$objG->title .= ' ' . $oDB->name;
		}

		$objG->caption_y = STR_BO_WOGRAPHCAPTIONY;
		$objG->caption_x = STR_BO_GRAPHCAPTIONX;
		$objG->num_lines_y = 15;
		$objG->num_lines_x = $GLOBALS['days'];
		$objG->colors = array('red', 'blue');


		print('<center>');
		echo '<img border="0" src="', menuLink('', 'menuAction=boGraph.Show&' . $objG->ToURL()), '">';
		print('</center>');
	}

	function reassign()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$objWO = CreateObject('dcl.htmlWorkorders');
		$objWO->PrintReassignForm();

		$obj = CreateObject('dcl.htmlWorkOrderDetail');
		$obj->Show($GLOBALS['jcn'], $GLOBALS['seq']);
	}

	function dbreassign()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$objWO = CreateObject('dcl.dbWorkorders');
		$objWO->Connect();
		$objWO->Load($GLOBALS['jcn'], $GLOBALS['seq']);
		if ($objWO->responsible != $GLOBALS['responsible'] ||
				$objWO->deadlineon != $GLOBALS['deadlineon'] ||
				$objWO->eststarton != $GLOBALS['eststarton'] ||
				$objWO->estendon != $GLOBALS['estendon'] ||
				$objWO->esthours != $GLOBALS['esthours'] ||
				$objWO->etchours != $GLOBALS['etchours'] ||
				$objWO->priority != $GLOBALS['priority'] ||
				$objWO->status == $dcl_info['DCL_DEF_STATUS_UNASSIGN_WO'] ||
				$objWO->severity != $GLOBALS['severity'])
		{
			$objWO->responsible = $GLOBALS['responsible'];
			$objWO->deadlineon = $GLOBALS['deadlineon'];
			$objWO->eststarton = $GLOBALS['eststarton'];
			$objWO->estendon = $GLOBALS['estendon'];
			$objWO->esthours = $GLOBALS['esthours'];
			
			$oStatus = CreateObject("dcl.dbStatuses");
			if ($oStatus->GetStatusType($objWO->status) != 2)
			{
				$objWO->etchours = $GLOBALS['etchours'];
				if ($objWO->status == $dcl_info['DCL_DEF_STATUS_UNASSIGN_WO'])
				{
					$objWO->status = $dcl_info['DCL_DEF_STATUS_ASSIGN_WO'];
					$objWO->statuson = $objWO->GetDateSQL();
				}
			}
			else
				$objWO->etchours = 0.0;

			$objWO->priority = $GLOBALS['priority'];
			$objWO->severity = $GLOBALS['severity'];
			$objWO->Edit();
			
			$objWtch = CreateObject('dcl.boWatches');
			$objWtch->sendNotification($objWO, '4');
		}

		$objHTMLWO = CreateObject('dcl.htmlWorkOrderDetail');
		$objHTMLWO->Show($GLOBALS['jcn'], $GLOBALS['seq']);
	}

	function batchassign()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$objWO = CreateObject('dcl.htmlWorkorders');
		$objWO->PrintReassignForm();

		$obj = CreateObject('dcl.htmlTimeCards');
		$obj->ShowBatchWO();
	}

	function dbbatchassign()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		if (IsSet($GLOBALS['selected']) && is_array($GLOBALS['selected']) && count($GLOBALS['selected']) > 0)
		{
			$objWtch = CreateObject('dcl.boWatches');
			$objWO = CreateObject('dcl.dbWorkorders');
			$objWO->Connect();
			$bNeedBreak = false;

			while (list($key, $val) = each($GLOBALS['selected']))
			{
				list($jcn, $seq) = explode('.', $val);

				$objWO->Load($jcn, $seq);
				if ($objWO->responsible != $GLOBALS['responsible'] ||
						$objWO->priority != $GLOBALS['priority'] ||
						$objWO->severity != $GLOBALS['severity'])
				{
					$objWO->responsible = $GLOBALS['responsible'];
					$objWO->priority = $GLOBALS['priority'];
					$objWO->severity = $GLOBALS['severity'];
					$objWO->Edit();

					$objWtch->sendNotification($objWO, '4,1');
				}
			}
		}

		if (EvaluateReturnTo())
			return;

		$objView = CreateObject('dcl.boView');
		$objView->SetFromURL();
		$objH = CreateObject('dcl.htmlWorkOrderResults');
		$objH->Render($objView);
	}

	function upload()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.htmlWorkorders');
		$obj->ShowUploadFileForm($GLOBALS['jcn'], $GLOBALS['seq']);

		$objWO = CreateObject('dcl.htmlWorkOrderDetail');
		$objWO->Show($GLOBALS['jcn'], $GLOBALS['seq']);
	}

	function doupload()
	{
		global $dcl_info, $HTTP_POST_VARS, $HTTP_GET_VARS, $HTTP_COOKIE_VARS;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		if (IsSet($GLOBALS['userfile']))
		{
			if ((IsSet($HTTP_POST_VARS['userfile']) && $HTTP_POST_VARS['userfile'] == $GLOBALS['userfile']) ||
				(IsSet($HTTP_GET_VARS['userfile']) && $HTTP_GET_VARS['userfile'] == $GLOBALS['userfile']) ||
				(IsSet($HTTP_COOKIE_VARS['userfile']) && $HTTP_COOKIE_VARS['userfile'] == $GLOBALS['userfile']))
			{
				return PrintPermissionDenied();
			}
		}

		if ($GLOBALS['userfile'] != 'none')
		{
			$o = CreateObject('dcl.boFile');
			$o->iType = ATTACHMENT_WORKORDER;
			$o->iKey1 = $GLOBALS['jcn'];
			$o->iKey2 = $GLOBALS['seq'];
			$o->sFileName = is_array($GLOBALS['userfile']) ? $GLOBALS['userfile']['name'] : $GLOBALS['userfile_name'];
			$o->sTempFileName = is_array($GLOBALS['userfile']) ? $GLOBALS['userfile']['tmp_name'] : $GLOBALS['userfile'];
			$o->sRoot = $dcl_info['DCL_FILE_PATH'] . '/attachments';
			$o->Upload();
		}

		$obj = CreateObject('dcl.htmlWorkOrderDetail');
		$obj->Show($GLOBALS['jcn'], $GLOBALS['seq']);
	}

	function deleteattachment()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$objH = CreateObject('dcl.htmlWorkorders');
		$objH->ShowDeleteAttachmentYesNo($GLOBALS['jcn'], $GLOBALS['seq'], $GLOBALS['filename']);

		$obj = CreateObject('dcl.htmlWorkOrderDetail');
		$obj->Show($GLOBALS['jcn'], $GLOBALS['seq']);
	}

	function dodeleteattachment()
	{
		global $dcl_info;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$attachPath = $dcl_info['DCL_FILE_PATH'] . '/attachments/wo/' . substr($GLOBALS['jcn'], -1) . '/' . $GLOBALS['jcn'] . '/' . $GLOBALS['seq'] . '/';
		if (is_file($attachPath . $GLOBALS['filename']) && is_readable($attachPath . $GLOBALS['filename']))
			unlink($attachPath . $GLOBALS['filename']);

		$obj = CreateObject('dcl.htmlWorkOrderDetail');
		$obj->Show($GLOBALS['jcn'], $GLOBALS['seq']);
	}

	// THANKS: Urmet Janes
	function csvupload()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$objHTMLWO = CreateObject('dcl.htmlWorkorders');
		$objHTMLWO->ShowCSVUploadDialog();
	}

	// THANKS: Urmet Janes
	function docsvupload()
	{
		global $dcl_info, $HTTP_POST_VARS, $HTTP_GET_VARS, $HTTP_COOKIE_VARS;

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		if (IsSet($GLOBALS['userfile']))
		{
			if ((IsSet($HTTP_POST_VARS['userfile']) && $HTTP_POST_VARS['userfile'] == $GLOBALS['userfile']) ||
				(IsSet($HTTP_GET_VARS['userfile']) && $HTTP_GET_VARS['userfile'] == $GLOBALS['userfile']) ||
				(IsSet($HTTP_COOKIE_VARS['userfile']) && $HTTP_COOKIE_VARS['userfile'] == $GLOBALS['userfile']))
			{
				return PrintPermissionDenied();
			}
		}

		$sTempFileName = is_array($GLOBALS['userfile']) ? $GLOBALS['userfile']['tmp_name'] : $GLOBALS['userfile'];
		if ($sTempFileName == 'none')
		{
			echo '<b>' . STR_BO_CSVUPLOADNONE . '</b>';
			return;
		}

		// Open the file as text - let PHP take care of line
		// delimiter differences
		$hFile = fopen($sTempFileName, 'r');
		if(!$hFile)
		{
			echo '<b>' . STR_BO_CSVUPLOADERR . '</b>';
			return;
		}

		// Get the line containing field names
		$line = 1;
		$fields = fgetcsv($hFile, 1000);

		// Define a useful function for mapping a short name to ID
		// It is really ineffective to instantiate a new object for
		// each field!
		function findID($obj, $table, $value, $pk = 'id', $fd = 'short', $fd2 = '', $val2 = '')
		{
			$sSQL = "SELECT $pk FROM $table WHERE $fd = '$value'";
			if ($fd2 != '' && $val2 != '')
				$sSQL .= " AND $fd2 = $val2";

			$obj->Query($sSQL);
			if($obj->next_record())
				return $obj->f(0);
			else
				return -1;
		}

		$objWorkorder = CreateObject('dcl.dbWorkorders');
		$objWorkorder->Connect();
		$objTemp = CreateObject('dcl.dbWorkorders');
		$objTemp->Connect();
		$objProjectmap = CreateObject('dcl.dbProjectmap');
		$objProjectmap->Connect();
		$objWtch = CreateObject('dcl.boWatches');

		while($data = fgetcsv($hFile, 1000))
		{
			$line++;
			$projectid = -1;
			$module_id = -1;
			$objWorkorder->Clear();

			while (list($i, $val) = each($data))
			{
				if (!is_numeric($val))
				{
					// we may need to convert smth
					switch ($fields[$i])
					{
						case 'product':
							$new_val = findID($objTemp, 'products', $val);
							break;
						case 'module_id':
							$module_id = $val;
							continue;
							break;
						case 'account':
							$new_val = findID($objTemp, 'accounts', $val);
							break;
						case 'wo_type_id':
							$new_val = findID($objTemp, 'dcl_wo_type', $val, 'wo_type_id', 'type_name');
							break;
						case 'priority':
							$new_val = findID($objTemp, 'priorities', $val);
							break;
						case 'severity':
							$new_val = findID($objTemp, 'severities', $val);
							break;
						case 'responsible':
							$new_val = findID($objTemp, 'personnel', $val);
							break;
						case 'project':
							$new_val = findID($objTemp, 'dcl_projects', $val, 'projectid', 'name');
							break;
						default:
							$new_val = $val;
					}

					if ($new_val == -1)
					{
						// An error on mapping
						echo '<b>';
						printf(STR_BO_CSVMAPERR, $fields[$i], $line);
						echo '</b><br>';
						continue 2;       // On to next line in the file
					}

					$val = $new_val;
				}
				else if ($fields[$i] == 'module_id')
					$module_id = $val;

				if ($fields[$i] != 'project' && $fields[$i] != 'module_id')
				{
					// This will ignore nonexisting members
					// Only works in PHP4 because Clear() initializes each field!
					if (isset($objWorkorder->$fields[$i]))
						$objWorkorder->$fields[$i] = $val;
				}
			}

			// Lookup module if specified
			if ($module_id != -1)
			{
				if (is_numeric($module_id))
				{
					// just verify this module exists for this product
					if ($objTemp->ExecuteScalar("SELECT COUNT(*) FROM dcl_product_module WHERE product_module_id = $module_id AND product_id = " . $objWorkorder->product) > 0)
						$objWorkorder->module_id = $module_id;
				}
				else
					$objWorkorder->module_id = findID($objTemp, 'dcl_product_module', $module_id, 'product_module_id', 'module_name', 'product_id', $objWorkorder->product);
			}

			$objWorkorder->createby = $GLOBALS['DCLID'];
			$objWorkorder->Add();

			if ($objWorkorder->jcn > 0)
			{
				if ($projectid > 0)
				{
					// Project specified, so try to add it
					$objProjectmap->projectid = $projectid;
					$objProjectmap->jcn = $objWorkorder->jcn;
					$objProjectmap->seq = $objWorkorder->seq;
					$objProjectmap->Add();
				}

				// Add it to our new work order collection
				$newjcns[] = $objWorkorder->jcn;

				// Send notification
				$objWtch->sendNotification($objWorkorder, '4,1');
			}
		}

		// Display imported work orders
		$objView = CreateObject('dcl.boView');
		$objView->style = 'report';
		$objView->title = 'Work Order CSV Upload Results';
		$objView->AddDef('filter', 'jcn', $newjcns);
		$objView->AddDef('order', 'jcn');

		$objView->AddDef('columns', '',
			array('jcn', 'seq', 'responsible.short', 'products.name', 'statuses.name', 'eststarton', 'deadlineon',
				'etchours', 'totalhours', 'summary'));

		$objView->AddDef('columnhdrs', '',
			array(STR_WO_JCN, STR_WO_SEQ, STR_WO_RESPONSIBLE, STR_WO_PRODUCT,
				STR_WO_STATUS, STR_WO_ESTSTART, STR_WO_DEADLINE, STR_WO_ETCHOURS, STR_WO_ACTHOURS, STR_WO_SUMMARY));

		$objHV = CreateObject('dcl.htmlWorkOrderResults');
		$objHV->Render($objView);
	}

	function showmy()
	{
		commonHeader();
		$obj = CreateObject('dcl.htmlWorkorders');
		$objDB = CreateObject('dcl.dbWorkorders');
		$objDB->Connect();
		if ($GLOBALS['which'] == 'responsible')
			$obj->showmy($objDB, 'responsible', STR_WO_MYWO, STR_WO_NOOPEN, 0);
		else
			$obj->showmy($objDB, 'createby', STR_WO_MYSUBMISSIONS, STR_WO_NOSUBMISSIONS, 0);
	}

	function batchdetail()
	{
		commonHeader();

		if (IsSet($GLOBALS['selected']) && is_array($GLOBALS['selected']) && count($GLOBALS['selected']) > 0)
		{
			$obj = CreateObject('dcl.htmlWorkOrderDetail');
			$objWorkorder = CreateObject('dcl.dbWorkorders');
			$bNeedBreak = false;
			while (list($key, $val) = each($GLOBALS['selected']))
			{
				if ($bNeedBreak)
					print('<p style="page-break-after: always;">');

				list($jcn, $seq) = explode('.', $val);
				$objWorkorder->Load($jcn, $seq);
				$obj->Show($jcn, $seq);
				$bNeedBreak = true;
			}
		}
		else
		{
			$objView = CreateObject('dcl.boView');
			$objView->SetFromURL();
			$objH = CreateObject('dcl.htmlWorkOrderResults');
			$objH->Render($objView);
		}
	}
}
?>
