<?php
/*
 * $Id: class.htmlWorkOrderType.inc.php,v 1.1.2.2 2003/12/10 05:54:06 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('wo');
LoadStringResource('cfg');

class htmlWorkOrderType
{
	var $public;

	function htmlWorkOrderType()
	{
		$this->public = array('add', 'modify', 'delete', 'submitAdd', 'submitModify', 'submitDelete', 'PrintAll');
	}

	function createCombo($default = 0, $cbName = 'wo_type_id', $size = 0, $activeOnly = true)
	{
		print $this->GetCombo($default, $cbName, $size, $activeOnly);
	}

	function GetCombo($default = 0, $cbName = 'wo_type_id', $size = 0, $activeOnly = true)
	{
		$filter = '';
		$table = 'dcl_wo_type';

		if ($activeOnly)
			$filter = "active='Y'";

		$order = 'type_name';

		$obj = CreateObject('dcl.htmlSelect');
		$obj->SetOptionsFromDb($table, 'wo_type_id', 'type_name', $filter, $order);
		$obj->vDefault = $default;
		$obj->sName = $cbName;
		$obj->iSize = $size;
		$obj->sZeroOption = STR_CMMN_SELECTONE;

		return $obj->GetHTML();
	}

	function RenderOptions(&$aRecord)
	{
		echo '<td>';
		echo '<a class="adark" href="' . menuLink('', 'menuAction=htmlWorkOrderType.modify&wo_type_id=' . $aRecord['wo_type_id']) . '">' . STR_CMMN_EDIT . '</a>';
		echo '&nbsp;';
		echo '<a class="adark" href="' . menuLink('', 'menuAction=htmlWorkOrderType.delete&wo_type_id=' . $aRecord['wo_type_id']) . '">' . STR_CMMN_DELETE . '</a>';
		echo '</td>';
	}

	function RenderNav()
	{
		global $dcl_info;

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
		{
			RenderSepMenu(array(STR_CMMN_NEW => menuLink('', 'menuAction=htmlWorkOrderType.add'),
								STR_CFG_TITLE => menuLink('', 'menuAction=boAdmin.ShowSystemConfig')));
		}
	}

	function ShowAll($orderBy = 'type_name')
	{
		global $dcl_info;

		commonHeader();

		$o = CreateObject('dcl.boView');
		$o->table = 'dcl_wo_type';
		$o->title = sprintf('Work Order Types');
		$o->AddDef('columns', '', array('wo_type_id', 'active', 'type_name'));
		$o->AddDef('columnhdrs', '', array(STR_CMMN_ID, STR_CMMN_ACTIVE, STR_CMMN_NAME));
		$o->AddDef('order', $orderBy);

		$oView = CreateObject('dcl.htmlWorkOrderTypeView');
		$oView->bColumnSort = false;
		$oView->bShowPager = false;
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
		{
			$oView->sColumnTitle = STR_CMMN_OPTIONS;
		}

		$oView->Render($o);
	}

	function add()
	{
		commonHeader();
		$this->ShowEntryForm();
		print('<p>');
		$this->ShowAll();
	}

	function modify()
	{
		commonHeader();
		$obj = CreateObject('dcl.dbWorkOrderType');
		$obj->Load($GLOBALS[GetSourceArray()]['wo_type_id']);
		$this->ShowEntryForm($obj);
	}

	function delete()
	{
		commonHeader();
		$obj = CreateObject('dcl.dbWorkOrderType');
		$obj->Load($GLOBALS[GetSourceArray()]['wo_type_id']);
		ShowDeleteYesNo('Work Order Type', 'htmlWorkOrderType.submitDelete', $obj->wo_type_id, $obj->type_name);
	}

	function submitAdd()
	{
		commonHeader();

		$obj = CreateObject('dcl.boWorkOrderType');
		CleanVars('HTTP_POST_VARS');
		$obj->add($GLOBALS['HTTP_POST_VARS']);
		$this->ShowAll();
	}

	function submitModify()
	{
		commonHeader();
		$obj = CreateObject('dcl.boWorkOrderType');
		CleanVars('HTTP_POST_VARS');
		$obj->modify($GLOBALS['HTTP_POST_VARS']);

		$this->ShowAll();
	}

	function submitDelete()
	{
		commonHeader();

		$obj = CreateObject('dcl.boWorkOrderType');
		CleanVars('HTTP_POST_VARS');
		$obj->delete(array('wo_type_id' => $GLOBALS['HTTP_POST_VARS']['id']));

		$this->ShowAll();
	}

	function ShowEntryForm($obj = '')
	{
		global $dcl_info;

		$isEdit = is_object($obj);
		$Template = CreateTemplate(array('hForm' => 'htmlWorkOrderTypeForm.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());

		$hidden_vars = '';
		if ($isEdit)
		{
			$Template->set_var('TXT_FUNCTION', 'Edit Work Order Type');
			$hidden_vars .= GetHiddenVar('menuAction', 'htmlWorkOrderType.submitModify');
			$hidden_vars .= GetHiddenVar('wo_type_id', $GLOBALS[GetSourceArray()]['wo_type_id']);
		}
		else
		{
			$Template->set_var('TXT_FUNCTION', 'Add Work Order Type');
			$hidden_vars .= GetHiddenVar('menuAction', 'htmlWorkOrderType.submitAdd');
		}

		$Template->set_var('HIDDEN_VARS', $hidden_vars);

		// Labels
		$Template->set_var('TXT_ACTIVE', STR_CMMN_ACTIVE);
		$Template->set_var('TXT_NAME', STR_CMMN_NAME);
		$Template->set_var('BTN_OK', STR_CMMN_SAVE);
		$Template->set_var('BTN_CANCEL', STR_CMMN_CANCEL);
		$Template->set_var('URL_BACK', menuLink('', 'menuAction=htmlWorkOrderType.ShowAll'));
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_CMMN_HIGHLIGHTEDNOTE);
		$Template->set_var('TXT_ATTRIBUTESNOTE', STR_CMMN_ATTRIBUTENOTE);

		// Data
		if ($isEdit)
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo($obj->active, 'active', 0, false));
			$Template->set_var('VAL_NAME', $obj->type_name);
		}
		else
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo('Y', 'active', 0, false));
			$Template->set_var('VAL_NAME', '');
		}

		$Template->pparse('out', 'hForm');
	}
}
?>
