/*!

\if MANPAGES
\page xml2dcm Convert XML document to DICOM file or data set
\else
\page xml2dcm xml2dcm: Convert XML document to DICOM file or data set
\endif

\section synopsis SYNOPSIS

\verbatim
xml2dcm [options] xmlfile-in dcmfile-out
\endverbatim

\section description DESCRIPTION

The \b xml2dcm utility converts the contents of an XML (Extensible Markup
Language) document to DICOM file or data set.  The XML document is expected to
validate against the DTD (Document Type Definition) which is described in file
<em>dcm2xml.dtd</em>.  An appropriate XML file can be created using the
\b dcm2xml tool (option \e +Wb recommended to include binary data).

\section parameters PARAMETERS

\verbatim
xmlfile-in   XML input filename to be converted (stdin: "-")

dcmfile-out  DICOM output filename
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h   --help
         print this help text and exit

       --version
         print version information and exit

  -v   --verbose
         verbose mode, print processing details

  -d   --debug
         debug mode, print debug information
\endverbatim

\subsection processing_options processing options
\verbatim
validation:

  +Vd  --validate-document
         validate XML document against DTD

  +Vn  --check-namespace
         check XML namespace in document root
\endverbatim

\subsection output_options output options
\verbatim
output file format:

  +F   --write-file
         write file format (default)

  -F   --write-dataset
         write data set without file meta information

output transfer syntax:

  +t=  --write-xfer-same
         write with same TS as input (default)

  +te  --write-xfer-little
         write with explicit VR little endian TS

  +tb  --write-xfer-big
         write with explicit VR big endian TS

  +ti  --write-xfer-implicit
         write with implicit VR little endian TS

post-1993 value representations:

  +u   --enable-new-vr
         enable support for new VRs (UN/UT) (default)

  -u   --disable-new-vr
         disable support for new VRs, convert to OB

group length encoding:

  +g=  --group-length-recalc
         recalculate group lengths if present (default)

  +g   --group-length-create
         always write with group length elements

  -g   --group-length-remove
         always write without group length elements

length encoding in sequences and items:

  +e   --length-explicit
         write with explicit lengths (default)

  -e   --length-undefined
         write with undefined lengths

data set trailing padding (not with --write-dataset):

  -p=  --padding-retain
         do not change padding (default if not --write-dataset)

  -p   --padding-off
         no padding (implicit if --write-dataset)

  +p   --padding-create  [f]ile-pad [i]tem-pad: integer
         align file on multiple of f bytes and items on
         multiple of i bytes
\endverbatim

\section notes NOTES

The basic structure of the XML input expected looks like the following:

\verbatim
<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE file-format SYSTEM "dcm2xml.dtd">
<file-format xmlns="http://dicom.offis.de/dcmtk">
  <meta-header xfer="1.2.840.10008.1.2.1" name="LittleEndianExplicit">
    <element tag="0002,0000" vr="UL" vm="1" len="4"
             name="MetaElementGroupLength">
      166
    </element>
    ...
    <element tag="0002,0013" vr="SH" vm="1" len="16"
             name="ImplementationVersionName">
      OFFIS_DCMTK_353
    </element>
  </meta-header>
  <data-set xfer="1.2.840.10008.1.2" name="LittleEndianImplicit">
    <element tag="0008,0005" vr="CS" vm="1" len="10"
             name="SpecificCharacterSet">
      ISO_IR 100
    </element>
    ...
    <sequence tag="0028,3010" vr="SQ" card="2" name="VOILUTSequence">
      <item card="3">
        <element tag="0028,3002" vr="xs" vm="3" len="6"
                 name="LUTDescriptor">
          256\\0\\8
        </element>
        ...
      </item>
      ...
    </sequence>
    ...
    <element tag="7fe0,0010" vr="OW" vm="1" len="262144"
             name="PixelData" loaded="no" binary="hidden">
    </element>
  </data-set>
</file-format>
\endverbatim
\if MANPAGES
.fi
\endif

The "file-format" and "meta-header" tags maybe absent for DICOM data sets.

\subsection character_encoding Character Encoding

The DICOM character encoding is determined automatically from the element with
tag "0008,0005" (Specific Character Set) - if present.  The following
character sets are currently supported (requires \b libxml2 to include \b iconv
support):

\verbatim
ASCII         "ISO_IR 6"    (UTF-8)
ISO Latin 1   "ISO_IR 100"  (ISO-8859-1)
ISO Latin 2   "ISO_IR 101"  (ISO-8859-2)
ISO Latin 3   "ISO_IR 109"  (ISO-8859-3)
ISO Latin 4   "ISO_IR 110"  (ISO-8859-4)
ISO Latin 5   "ISO_IR 148"  (ISO-8859-9)
Cyrillic      "ISO_IR 144"  (ISO-8859-5)
Arabic        "ISO_IR 127"  (ISO-8859-6)
Greek         "ISO_IR 126"  (ISO-8859-7)
Hebrew        "ISO_IR 138"  (ISO-8859-8)
\endverbatim
\if MANPAGES
.fi
\endif

Multiple character sets are not supported (only the first value of the
"Specific Character Set" is used for the character encoding in case of value
multiplicity).

See \b dcm2xml documentation for more details on the XML structure.

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b xml2dcm utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section files FILES

<em>lib/dcm2xml.dtd</em> - Document Type Definition (DTD) file

\section see_also SEE ALSO

<b>dcm2xml</b>(1)

\section copyright COPYRIGHT

Copyright (C) 2003-2004 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/
