#!/bin/bash -e

for i in books/*; do \
    echo "Untarring $i..."; 
    (cd debian/tmp/usr/share/devhelp/books && 
	tar zxpf ../../../../../../$i
	test -f book.devhelp || mv book/*.devhelp ./book.devhelp 
	name=`cat book.devhelp | head | grep name  | head -1 | sed 's,.*name=,,g' | cut -d '"' -f 2`
	version=`cat book.devhelp | head | grep version | grep -v xml | head -1 | sed 's,.*version=,,g' | cut -d '"' -f 2`
	echo "Name: $name" 
	echo "Version: $version"
	if [ -n "$version" ]; then
	    mv book ${name}-${version}
	    mv book.devhelp ${name}-${version}/${name}-${version}.devhelp
	    gzip -9 ${name}-${version}/${name}-${version}.devhelp
	else
	    mv book ${name}; 
	    mv book.devhelp ${name}/${name}.devhelp
	    gzip -9 ${name}/${name}.devhelp
	fi)
done
