/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

struct s_lista_archivos {
	gchar *nombre;
	GtkSourceBuffer *datos;
	gboolean analizado;
	GtkTextMark *posicion;
	GtkTreeIter nodo_arbol;
	struct s_lista_archivos *anterior;
	struct s_lista_archivos *siguiente;
	GtkSourceView *editor; // un puntero al widget en el que se esta mostrando el archivo.
	gint pestana; // nos indica en que pestaa del notebook se esta mostrando el archivo. -1 si no esta en ninguna.
};


//*******************************************************************

struct s_lista_archivos *raiz_lista_archivos;
struct s_lista_archivos *edit_actual;
guint edit_posicion;
gboolean edit_abriendo_llave;
GtkSourceView *edit_editor;
GtkSourceView *edit_funciones;
GtkSourceBuffer *edit_funciones_buffer;
GdkColor c_fondo,c_nada,c_comentario,c_directiva,c_cadena_cs,c_cadena_cd,c_etiqueta,c_entero,c_real,c_hexadecimal,c_octal,c_prelight;
gint edit_total_pestanas;
GList *edit_historico_funciones;
gboolean edit_congelar_historico;
guint edit_marcador;

//*******************************************************************
void edit_inicializar(void);

void edit_cerrar(void);

void edit_anadir(gchar *nombre,GtkTreeIter *nodo_arbol);

void edit_guardar_todo(void);

void edit_ver(gchar *nombre);

void edit_borrar_seleccion(void);

void edit_copiar_seleccion(void);

void edit_cortar_seleccion(void);

void edit_pegar_seleccion(void);

void edit_guardar(void);

void edit_eliminar(gchar *nombre);

void edit_actualizar(void);

void edit_actualizar_fila(void);

void edit_auto_formato(GtkTextBuffer *buffer,const gchar *texto,guint longitud,GtkTextIter *posicion);

gboolean edit_comprobar_perdida_datos(void);

void edit_mensaje(gchar *mensaje);

void edit_ir_a_posicion(guint posicion);

gboolean edit_repetido(gchar *nombre);

void edit_anadir_tabulacion(void);

void edit_eliminar_tabulacion(void);

// El GtkTextIter que se pasa como parametro tiene que estar previamente alojado.
gchar *edit_tabulacion(GtkTextIter *posicion);

// Funcion que se posiciona en la fila indicada. En posicion devueve un GtkTextIter que previamete tiene que ser alojado, y que 
// corresponde al principio de la fila.
void edit_ir_a_fila(guint fila,GtkTextIter *posicion);

struct s_lista_archivos *edit_conseguir_nodo(gchar *nombre);

GList *edit_cambiar_reglas_coloreado(void);

void edit_aplicar_reglas_coloreado(GtkSourceBuffer *buffer);

void edit_recargar_archivo(gchar *nombre);

void edit_ver_funcion(gchar *funcion, gboolean actualizar_historico);
