/* dblist.c -- interations between idlist and database tables
 *
 * Copyright (c) 1998-2002  Mike Oliphant <oliphant@gtk.org>
 *
 *   http://www.nostatic.org/grip
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <stdio.h>
#include "mp3db.h"
#include "dblist.h"

void GetListFromQuery(MYSQL *mysql,IDList *idlist,char *query,
		      gboolean do_alloc)
{
  MYSQL_RES *res;
  MYSQL_ROW row;
  int *ids;
  int row_num;
  int num_rows;

  if(mysql_query(mysql,query)) {
    printf("Query error\n");

    return;
  }

  if(!(res = mysql_store_result(mysql))) {
    printf("Query error\n");

    return;
  }

  num_rows=mysql_num_rows(res);

  if(!num_rows) {
    ids=NULL;
  }
  else {
    if(do_alloc) {
      idlist->num_ids=0;
      
      ids=g_new(int,num_rows);
      if(!ids) {
	printf("Memory error\n");
	
	mysql_free_result(res);
	
	return;
      }
    }
    else {
      ids=idlist->ids;
    }
    
    row_num=idlist->num_ids;
    
    while((row=mysql_fetch_row(res))) {
      ids[row_num++]=DBNum(row[0]);
    }
  }

  mysql_free_result(res);

  if(num_rows) {
    idlist->ids=ids;

    idlist->num_ids+=num_rows;
  }
}

