# 
# bootmisc.sh	Miscellaneous things to be done during bootup.
#
# Version:	@(#)bootmisc.sh  1.20  09-Jan-1999  miquels@cistron.nl
#

# modified for diskless-image, secure mode, 1999-09-20

. /etc/default/rcS

#
# Put a nologin file in /etc to prevent people from logging in before
# system startup is complete. --- not done in secure mode.
#
#if [ "$DELAYLOGIN" = yes ]
#then
#  echo "System bootup in progress - please wait" > /etc/nologin
#  cp /etc/nologin /etc/nologin.boot
#fi

#
# Wipe /rw-secure (and don't erase `lost+found', `quota.user' or `quota.group')!
# Note that files _in_ lost+found _are_ deleted.
#
[ "$VERBOSE" != no ] && echo -n "Cleaning: /rw-secure"
#
#	If $TMPTIME is set to 0, we do not use any ctime expression
#	at all, so we can also delete files with timestamps
#	in the future! --- not done in secure mode.
#
#if [ "$TMPTIME" = 0 ]
#then
	TEXPR=""
#else
#	TEXPR="! -ctime -$TMPTIME"
#fi
( cd /tmp && \
  find . -xdev \
  $TEXPR \
  ! -name . \
  ! \( -name lost+found -uid 0 \) \
  ! \( -name quota.user -uid 0 \) \
  ! \( -name quota.group -uid 0 \) \
    -depth -exec rm -rf -- {} \; )
rm -f /tmp/.X*-lock

[ "$VERBOSE" != no ] && echo "."

[ "$VERBOSE" != no ] && echo -n "Copying /rw to /rw-secure..."
tar -C /rw -cf- . | tar -C /rw-secure -xpf-
[ "$VERBOSE" != no ] && echo "done."

[ "$VERBOSE" != no ] && echo -n "Mounting /rw..."
mount /rw
[ "$VERBOSE" != no ] && echo "done."

#
# Clean up any stale locks.
#
[ "$VERBOSE" != no ] && echo -n "Cleaning: /var/lock"
( cd /var/lock && find . -type f -exec rm -f -- {} \; )
#
# Clean up /var/run and create /var/run/utmp so that we can login.
#
[ "$VERBOSE" != no ] && echo -n " /var/run"
( cd /var/run && \
	find . ! -type d ! -name utmp ! -name innd.pid ! -name random-seed \
	-exec rm -f -- {} \; )
: > /var/run/utmp
[ "$VERBOSE" != no ] && echo "."

#
# Set pseudo-terminal access permissions.
#
chmod 666 /dev/tty[p-za-e][0-9a-f]
chown root:tty /dev/tty[p-za-e][0-9a-f]

#
# Update /etc/motd. --- not done in secure mode.
#
#if [ "$EDITMOTD" != no ]
#then
#	uname -a > /etc/motd.tmp
#	sed 1d /etc/motd >> /etc/motd.tmp
#	mv /etc/motd.tmp /etc/motd
#fi
