<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: block.xsl,v 1.3 2003/05/24 13:52:45 stevecheng Exp $
     ********************************************************************

     &copy; 2000 Steve Cheng <stevecheng@users.sourceforge.net>

     Part of docbook2X, DocBook to man page conversion.


     ******************************************************************** -->

<!-- ==================================================================== -->

<xsl:template name="block-object">
  <para>
    <xsl:apply-templates/>
  </para>
</xsl:template>

<xsl:template name="indented.block-object">
  <indent>
    <xsl:apply-templates/>
  </indent>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="para|simpara">
  <para>
    <xsl:apply-templates/>
  </para>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="formalpara">
  <para>
    <xsl:apply-templates/>
  </para>
</xsl:template>

<xsl:template match="formalpara/title">
  <!-- run-in head; FIXME i18n -->
  <b><xsl:apply-templates/>.</b>
  <xsl:text> </xsl:text>
</xsl:template>

<xsl:template match="formalpara/para">
  <xsl:apply-templates/>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="blockquote">
  <indent>
    <xsl:apply-templates/>
    <xsl:apply-templates select="attribution" mode="blockquote.attribution.mode" />
  </indent>
</xsl:template>

<xsl:template match="blockquote/title">
  <xsl:call-template name="make-caption" />
</xsl:template>

<xsl:template match="attribution"></xsl:template>
<xsl:template match="attribution" mode="blockquote.attribution.mode">
  <para>&#x2014; <xsl:apply-templates /></para>
  <!-- FIXME: need i18n for #x2014=&mdash? -->
</xsl:template>

<xsl:template match="epigraph">
  <xsl:apply-templates />
  <xsl:apply-templates select="attribution" mode="blockquote.attribution.mode" />
</xsl:template>


<!-- ==================================================================== -->

<xsl:template match="sidebar">
</xsl:template>


<!-- ==================================================================== -->

<xsl:template match="abstract">
</xsl:template>


<!-- ==================================================================== -->

<xsl:template match="msgset">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="msgentry">
  <xsl:call-template name="block-object"/>
</xsl:template>

<xsl:template match="simplemsgentry">
  <xsl:call-template name="block-object"/>
</xsl:template>

<xsl:template match="msg">
  <xsl:call-template name="block-object"/>
</xsl:template>

<xsl:template match="msgmain">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="msgmain/title">
  <strong><xsl:apply-templates/></strong>
</xsl:template>

<xsl:template match="msgsub">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="msgsub/title">
  <strong><xsl:apply-templates/></strong>
</xsl:template>

<xsl:template match="msgrel">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="msgrel/title">
  <strong><xsl:apply-templates/></strong>
</xsl:template>

<xsl:template match="msgtext">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="msginfo">
  <xsl:call-template name="block-object"/>
</xsl:template>

<xsl:template match="msglevel|msgorig|msgaud">
  <xsl:call-template name="make-caption">
    <xsl:with-param name="content">
      <xsl:call-template name="gentext-title"/>
      <xsl:text>: </xsl:text><!-- FIXME -->
      <xsl:apply-templates/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="msgexplan">
  <xsl:call-template name="block-object"/>
</xsl:template>

<xsl:template match="msgexplan/title">
  <para><strong><xsl:apply-templates/></strong></para>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="revhistory">
  <multitable distribution=".33 .33 .33">
    <xsl:apply-templates />
  </multitable>
</xsl:template>
  
<xsl:template match="revhistory/revision">
  <xsl:variable name="revnumber" select=".//revnumber"/>
  <xsl:variable name="revdate"   select=".//date"/>
  <xsl:variable name="revauthor" select=".//authorinitials"/>
  <xsl:variable name="revremark" select=".//revremark|../revdescription"/>

  <item />
  <xsl:if test="$revnumber">
    <xsl:call-template name="gentext-title"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates select="$revnumber"/>
  </xsl:if>
  
  <tab />
  <xsl:apply-templates select="$revdate"/>

  <tab />
  <xsl:if test="count($revauthor)!=0">
    <xsl:apply-templates select="$revauthor"/>
  </xsl:if>

  <xsl:if test="$revremark">
    <item />
      <xsl:apply-templates select="$revremark"/>
  </xsl:if>
</xsl:template>

<xsl:template match="revision/revnumber">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="revision/date">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="revision/authorinitials">
  <xsl:text>, </xsl:text>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="revision/authorinitials[1]">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="revision/revremark">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="revision/revdescription">
  <xsl:apply-templates/>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="ackno">
  <xsl:call-template name="block-object" />
</xsl:template>

<!-- ==================================================================== -->

</xsl:stylesheet>
