import com.tildemh.jgwizard.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;


/**
 * <p>When filesystem method has been chosen, this determines whether Dirscan or
 * link follow should be used
 */
public class FileSysMethodPage extends WizardPage{

	/**
	 * Constructs a new FileSysPage
	 */
	public FileSysMethodPage(WizardForm wizard, WizardPage parent){
		super(wizard, parent, DomesdayGUI.messages.getString("FileSysMethodTitle"));
	}


	/**	Radio button for dirscan */
	private static RadioButton dirScan = null;
	/** Radio button for linkFollow */
	private static RadioButton linkFollow = null;
	/** If true, dirScanner is being used. */
	private boolean useDirScan = false;
	
	/**
	 * Sets up the widgets of the screen.
	 */
	protected void customise(){		
		VBox mainVBox = new VBox(false, 5);

		Label head = new Label(  DomesdayGUI.messages.getString("FileSysMethodHead") );
		head.setLineWrap(true);
		mainVBox.add(head);		
		
		dirScan = new RadioButton(null, DomesdayGUI.messages.getString("DirScan"), true );
		mainVBox.add(dirScan);
		Label desc = new Label( DomesdayGUI.messages.getString("DirScanDesc") );
		desc.setLineWrap(true);
		mainVBox.add(desc);
		
		linkFollow = new RadioButton(dirScan,  DomesdayGUI.messages.getString("LinkFollow"), true );
		mainVBox.add(linkFollow);						
		desc = new Label( DomesdayGUI.messages.getString("LinkFollowDesc") );
		desc.setLineWrap(true);
		mainVBox.add(desc);

		scListener  = new sourceChangeHandler();
		dirScan.addListener( (ToggleListener) scListener);

		mainVBox.showAll();
		content =  mainVBox;
		System.out.println("Customised FileSysMethodPage");
	}
	
	/**
	 * Load the setting from the project file before displaying the page.
	 */
	protected void preShow(){
		try{
			useDirScan = DomesdayGUI.project.getEnumSetting("FILE_SYSTEM_SEARCH").equals("FILE_SYSTEM_SEARCH_DIR_SCAN");
		}catch(IllegalVariableException e){
			DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
			e.printStackTrace();
		}
		dirScan.setState(useDirScan);
	}

	private static sourceChangeHandler scListener;
	/**
	 * Listener for changes to the setting
	 */
	public class sourceChangeHandler implements ToggleListener{
		/**
		 * If the setting has changed, the index source will be updated, as will
		 * the project
		 */
		public void toggleEvent(ToggleEvent event){
			if (useDirScan != dirScan.getState()){
				useDirScan = dirScan.getState();
				try{
					if (useDirScan){
						DomesdayGUI.project.storeSettingByVar("FILE_SYSTEM_SEARCH","FILE_SYSTEM_SEARCH_DIR_SCAN" );
					}else{
						DomesdayGUI.project.storeSettingByVar("FILE_SYSTEM_SEARCH","FILE_SYSTEM_SEARCH_LINK_FOLLOW" );
					}
				}catch(IllegalVariableException e){
					DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
					e.printStackTrace();
				}
				((DomesdayGUI) wizard).changeFileSysMethod();
			}
		}
	}

}
